/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.jasper.compiler;

import com.bes.enterprise.web.jasper.Constants;
import com.bes.enterprise.web.jasper.JasperException;
import com.bes.enterprise.web.jasper.compiler.ELNode;
import com.bes.enterprise.web.jasper.compiler.Node;
import com.bes.enterprise.web.util.security.PrivilegedGetTccl;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.jsp.tagext.FunctionInfo;

public class ELFunctionMapper {
    private int currFunc = 0;
    private StringBuilder ds;
    private StringBuilder ss;

    public static void map(Node.Nodes page) throws JasperException {
        ELFunctionMapper map = new ELFunctionMapper();
        map.ds = new StringBuilder();
        map.ss = new StringBuilder();
        ELFunctionMapper eLFunctionMapper = map;
        eLFunctionMapper.getClass();
        page.visit(eLFunctionMapper.new ELFunctionVisitor());
        String ds = map.ds.toString();
        if (ds.length() > 0) {
            Node.Root root = page.getRoot();
            Node.Declaration unused = new Node.Declaration(map.ss.toString(), null, root);
            unused = new Node.Declaration("static {\n" + ds + "}\n", null, root);
        }
    }

    private class ELFunctionVisitor
    extends Node.Visitor {
        private final HashMap<String, String> gMap = new HashMap();

        private ELFunctionVisitor() {
        }

        @Override
        public void visit(Node.ParamAction n2) throws JasperException {
            this.doMap(n2.getValue());
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.IncludeAction n2) throws JasperException {
            this.doMap(n2.getPage());
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.ForwardAction n2) throws JasperException {
            this.doMap(n2.getPage());
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.SetProperty n2) throws JasperException {
            this.doMap(n2.getValue());
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.UseBean n2) throws JasperException {
            this.doMap(n2.getBeanName());
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.PlugIn n2) throws JasperException {
            this.doMap(n2.getHeight());
            this.doMap(n2.getWidth());
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.JspElement n2) throws JasperException {
            Node.JspAttribute[] attrs = n2.getJspAttributes();
            for (int i2 = 0; attrs != null && i2 < attrs.length; ++i2) {
                this.doMap(attrs[i2]);
            }
            this.doMap(n2.getNameAttribute());
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.UninterpretedTag n2) throws JasperException {
            Node.JspAttribute[] attrs = n2.getJspAttributes();
            for (int i2 = 0; attrs != null && i2 < attrs.length; ++i2) {
                this.doMap(attrs[i2]);
            }
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.CustomTag n2) throws JasperException {
            Node.JspAttribute[] attrs = n2.getJspAttributes();
            for (int i2 = 0; attrs != null && i2 < attrs.length; ++i2) {
                this.doMap(attrs[i2]);
            }
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.ELExpression n2) throws JasperException {
            this.doMap(n2.getEL());
        }

        private void doMap(Node.JspAttribute attr) throws JasperException {
            if (attr != null) {
                this.doMap(attr.getEL());
            }
        }

        private void doMap(ELNode.Nodes el) throws JasperException {
            if (el == null) {
                return;
            }
            class Fvisitor
            extends ELNode.Visitor {
                private final List<ELNode.Function> funcs = new ArrayList<ELNode.Function>();
                private final Set<String> keySet = new HashSet<String>();

                Fvisitor() {
                }

                @Override
                public void visit(ELNode.Function n2) throws JasperException {
                    String key = n2.getPrefix() + ":" + n2.getName();
                    if (this.keySet.add(key)) {
                        this.funcs.add(n2);
                    }
                }
            }
            Fvisitor fv = new Fvisitor();
            el.visit(fv);
            List functions = fv.funcs;
            if (functions.size() == 0) {
                return;
            }
            String decName = this.matchMap(functions);
            if (decName != null) {
                el.setMapName(decName);
                return;
            }
            decName = this.getMapName();
            ELFunctionMapper.this.ss.append("private static com.bes.enterprise.web.jasper.runtime.ProtectedFunctionMapper " + decName + ";\n");
            ELFunctionMapper.this.ds.append("  " + decName + "= ");
            ELFunctionMapper.this.ds.append("com.bes.enterprise.web.jasper.runtime.ProtectedFunctionMapper");
            String funcMethod = null;
            if (functions.size() == 1) {
                funcMethod = ".getMapForFunction";
            } else {
                ELFunctionMapper.this.ds.append(".getInstance();\n");
                funcMethod = "  " + decName + ".mapFunction";
            }
            for (ELNode.Function f2 : functions) {
                FunctionInfo funcInfo = f2.getFunctionInfo();
                String fnQName = f2.getPrefix() + ":" + f2.getName();
                if (funcInfo == null) {
                    ELFunctionMapper.this.ds.append(funcMethod + "(null, null, null, null);\n");
                } else {
                    ELFunctionMapper.this.ds.append(funcMethod + "(\"" + fnQName + "\", " + this.getCanonicalName(funcInfo.getFunctionClass()) + ".class, " + '\"' + f2.getMethodName() + "\", new Class[] {");
                    String[] params = f2.getParameters();
                    for (int k2 = 0; k2 < params.length; ++k2) {
                        int iArray;
                        if (k2 != 0) {
                            ELFunctionMapper.this.ds.append(", ");
                        }
                        if ((iArray = params[k2].indexOf(91)) < 0) {
                            ELFunctionMapper.this.ds.append(params[k2] + ".class");
                            continue;
                        }
                        String baseType = params[k2].substring(0, iArray);
                        ELFunctionMapper.this.ds.append("java.lang.reflect.Array.newInstance(");
                        ELFunctionMapper.this.ds.append(baseType);
                        ELFunctionMapper.this.ds.append(".class,");
                        int aCount = 0;
                        for (int jj = iArray; jj < params[k2].length(); ++jj) {
                            if (params[k2].charAt(jj) != '[') continue;
                            ++aCount;
                        }
                        if (aCount == 1) {
                            ELFunctionMapper.this.ds.append("0).getClass()");
                            continue;
                        }
                        ELFunctionMapper.this.ds.append("new int[" + aCount + "]).getClass()");
                    }
                    ELFunctionMapper.this.ds.append("});\n");
                }
                this.gMap.put(fnQName + ':' + f2.getUri(), decName);
            }
            el.setMapName(decName);
        }

        private String matchMap(List<ELNode.Function> functions) {
            String mapName = null;
            for (ELNode.Function f2 : functions) {
                String temName = this.gMap.get(f2.getPrefix() + ':' + f2.getName() + ':' + f2.getUri());
                if (temName == null) {
                    return null;
                }
                if (mapName == null) {
                    mapName = temName;
                    continue;
                }
                if (temName.equals(mapName)) continue;
                return null;
            }
            return mapName;
        }

        private String getMapName() {
            return "_jspx_fnmap_" + ELFunctionMapper.this.currFunc++;
        }

        private String getCanonicalName(String className) throws JasperException {
            Class<?> clazz;
            ClassLoader tccl;
            if (Constants.IS_SECURITY_ENABLED) {
                PrivilegedGetTccl pa = new PrivilegedGetTccl();
                tccl = AccessController.doPrivileged(pa);
            } else {
                tccl = Thread.currentThread().getContextClassLoader();
            }
            try {
                clazz = Class.forName(className, false, tccl);
            }
            catch (ClassNotFoundException e2) {
                throw new JasperException(e2);
            }
            return clazz.getCanonicalName();
        }
    }
}

