/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.jasper.compiler;

import com.bes.enterprise.web.jasper.JasperException;
import com.bes.enterprise.web.jasper.JspCompilationContext;
import com.bes.enterprise.web.jasper.compiler.ErrorDispatcher;
import com.bes.enterprise.web.jasper.compiler.PageInfo;
import com.bes.enterprise.web.jasper.compiler.ParserController;
import com.bes.enterprise.web.jasper.compiler.TagFileProcessor;
import com.bes.enterprise.web.util.descriptor.tld.ImplicitTldRuleSet;
import com.bes.enterprise.web.util.descriptor.tld.TaglibXml;
import com.bes.enterprise.web.util.descriptor.tld.TldParser;
import com.bes.enterprise.web.util.descriptor.tld.TldResourcePath;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.xml.sax.SAXException;

class ImplicitTagLibraryInfo
extends TagLibraryInfo {
    private static final String WEB_INF_TAGS = "/WEB-INF/tags";
    private static final String TAG_FILE_SUFFIX = ".tag";
    private static final String TAGX_FILE_SUFFIX = ".tagx";
    private static final String TAGS_SHORTNAME = "tags";
    private static final String TLIB_VERSION = "1.0";
    private static final String JSP_VERSION = "2.0";
    private static final String IMPLICIT_TLD = "implicit.tld";
    private final Hashtable<String, String> tagFileMap;
    private final ParserController pc;
    private final PageInfo pi;
    private final Vector<TagFileInfo> vec;

    public ImplicitTagLibraryInfo(JspCompilationContext ctxt, ParserController pc, PageInfo pi, String prefix, String tagdir, ErrorDispatcher err) throws JasperException {
        super(prefix, null);
        this.pc = pc;
        this.pi = pi;
        this.tagFileMap = new Hashtable();
        this.vec = new Vector();
        this.functions = new FunctionInfo[0];
        this.tlibversion = TLIB_VERSION;
        this.jspversion = JSP_VERSION;
        if (!tagdir.startsWith(WEB_INF_TAGS)) {
            err.jspError("jsp.error.invalid.tagdir", tagdir);
        }
        if (tagdir.equals(WEB_INF_TAGS) || tagdir.equals("/WEB-INF/tags/")) {
            this.shortname = TAGS_SHORTNAME;
        } else {
            this.shortname = tagdir.substring(WEB_INF_TAGS.length());
            this.shortname = this.shortname.replace('/', '-');
        }
        Set<String> dirList = ctxt.getResourcePaths(tagdir);
        if (dirList != null) {
            for (String path : dirList) {
                TaglibXml taglibXml;
                if (path.endsWith(TAG_FILE_SUFFIX) || path.endsWith(TAGX_FILE_SUFFIX)) {
                    String suffix = path.endsWith(TAG_FILE_SUFFIX) ? TAG_FILE_SUFFIX : TAGX_FILE_SUFFIX;
                    String tagName = path.substring(path.lastIndexOf(47) + 1);
                    tagName = tagName.substring(0, tagName.lastIndexOf(suffix));
                    this.tagFileMap.put(tagName, path);
                    continue;
                }
                if (!path.endsWith(IMPLICIT_TLD)) continue;
                try {
                    URL url = ctxt.getResource(path);
                    TldResourcePath resourcePath = new TldResourcePath(url, path);
                    ServletContext servletContext = ctxt.getServletContext();
                    boolean validate = Boolean.parseBoolean(servletContext.getInitParameter("com.bes.enterprise.web.jasper.XML_VALIDATE_TLD"));
                    String blockExternalString = servletContext.getInitParameter("com.bes.enterprise.web.jasper.XML_BLOCK_EXTERNAL");
                    boolean blockExternal = blockExternalString == null ? true : Boolean.parseBoolean(blockExternalString);
                    TldParser parser = new TldParser(true, validate, new ImplicitTldRuleSet(), blockExternal);
                    taglibXml = parser.parse(resourcePath);
                }
                catch (IOException | SAXException e2) {
                    err.jspError(e2);
                    throw new JasperException(e2);
                }
                this.tlibversion = taglibXml.getTlibVersion();
                this.jspversion = taglibXml.getJspVersion();
                try {
                    double version = Double.parseDouble(this.jspversion);
                    if (version < 2.0) {
                        err.jspError("jsp.error.invalid.implicit.version", path);
                    }
                }
                catch (NumberFormatException e3) {
                    err.jspError("jsp.error.invalid.implicit.version", path);
                }
                if (pi == null) continue;
                pi.addDependant(path, ctxt.getLastModified(path));
            }
        }
    }

    @Override
    public TagFileInfo getTagFile(String shortName) {
        TagFileInfo tagFile = super.getTagFile(shortName);
        if (tagFile == null) {
            String path = this.tagFileMap.get(shortName);
            if (path == null) {
                return null;
            }
            TagInfo tagInfo = null;
            try {
                tagInfo = TagFileProcessor.parseTagFileDirectives(this.pc, shortName, path, null, this);
            }
            catch (JasperException je) {
                throw new RuntimeException(je.toString(), je);
            }
            tagFile = new TagFileInfo(shortName, path, tagInfo);
            this.vec.addElement(tagFile);
            this.tagFiles = new TagFileInfo[this.vec.size()];
            this.vec.copyInto(this.tagFiles);
        }
        return tagFile;
    }

    @Override
    public TagLibraryInfo[] getTagLibraryInfos() {
        Collection<TagLibraryInfo> coll = this.pi.getTaglibs();
        return coll.toArray(new TagLibraryInfo[0]);
    }
}

