/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.jasper.compiler;

import com.bes.enterprise.web.jasper.JasperException;
import com.bes.enterprise.web.jasper.compiler.ErrorDispatcher;
import com.bes.enterprise.web.jasper.compiler.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.VariableInfo;

class ScriptingVariabler {
    private static final Integer MAX_SCOPE = Integer.MAX_VALUE;

    ScriptingVariabler() {
    }

    public static void set(Node.Nodes page, ErrorDispatcher err) throws JasperException {
        page.visit(new CustomTagCounter());
        page.visit(new ScriptingVariableVisitor(err));
    }

    private static class ScriptingVariableVisitor
    extends Node.Visitor {
        private final ErrorDispatcher err;
        private final Map<String, Integer> scriptVars;
        private Stack<String> scopeStack = new Stack();
        public static char CLB = (char)123;
        public static char CRB = (char)125;
        public static String SLB = "{";
        public static String SRB = "}";
        public static char DQ = (char)34;
        public static char SQ = (char)39;
        public static boolean varScopeCheck = Boolean.parseBoolean(System.getProperty("com.bes.web.jsp.compile.checkVarScope", "true"));

        public ScriptingVariableVisitor(ErrorDispatcher err) {
            this.err = err;
            this.scriptVars = new HashMap<String, Integer>();
        }

        @Override
        public void visit(Node.Scriptlet n2) {
            int n3;
            if (!varScopeCheck) {
                return;
            }
            JspScriptReader reader = new JspScriptReader(n2.getText().toCharArray());
            int n4 = -1;
            while ((n3 = reader.nextChar()) != -1) {
                if (n3 == DQ) {
                    reader.skipUntil(DQ);
                    continue;
                }
                if (n3 == SQ) {
                    reader.skipUntil(SQ);
                    continue;
                }
                if (n3 == 47 && reader.peekChar() == 47) {
                    reader.skipUntil("\n");
                    continue;
                }
                if (n3 == 47 && reader.peekChar() == 42) {
                    reader.skipUntil("*/");
                    continue;
                }
                if (n3 == CLB) {
                    this.scopeStack.push(SLB);
                    continue;
                }
                if (n3 != CRB) continue;
                while (!this.scopeStack.isEmpty() && !this.scopeStack.peek().equals(SLB)) {
                    this.scopeStack.pop();
                }
                if (this.scopeStack.isEmpty() || !this.scopeStack.peek().equals(SLB)) continue;
                this.scopeStack.pop();
            }
        }

        @Override
        public void visit(Node.CustomTag n2) throws JasperException {
            this.setScriptingVars(n2, 1);
            this.setScriptingVars(n2, 0);
            this.visitBody(n2);
            this.setScriptingVars(n2, 2);
        }

        /*
         * WARNING - void declaration
         */
        private void setScriptingVars(Node.CustomTag n2, int scope) throws JasperException {
            Integer currentRange;
            TagVariableInfo[] tagVarInfos = n2.getTagVariableInfos();
            VariableInfo[] varInfos = n2.getVariableInfos();
            if (tagVarInfos.length == 0 && varInfos.length == 0) {
                return;
            }
            ArrayList<Object> vec = new ArrayList<Object>();
            Integer ownRange = null;
            Node.CustomTag parent = n2.getCustomTagParent();
            ownRange = scope == 1 || scope == 2 ? (parent == null ? MAX_SCOPE : parent.getNumCount()) : n2.getNumCount();
            if (varInfos.length > 0) {
                for (int i2 = 0; i2 < varInfos.length; ++i2) {
                    String string;
                    if (varInfos[i2].getScope() != scope || !varInfos[i2].getDeclare() || (currentRange = this.scriptVars.get(string = varInfos[i2].getVarName())) != null && ownRange.compareTo(currentRange) <= 0 && (!varScopeCheck || this.scopeStack.contains(string))) continue;
                    this.scriptVars.put(string, ownRange);
                    vec.add(varInfos[i2]);
                }
            } else {
                for (int i2 = 0; i2 < tagVarInfos.length; ++i2) {
                    void var9_11;
                    String string;
                    if (tagVarInfos[i2].getScope() != scope || !tagVarInfos[i2].getDeclare()) continue;
                    String string2 = tagVarInfos[i2].getNameGiven();
                    if (string2 == null && (string = n2.getTagData().getAttributeString(tagVarInfos[i2].getNameFromAttribute())) == null) {
                        this.err.jspError((Node)n2, "jsp.error.scripting.variable.missing_name", tagVarInfos[i2].getNameFromAttribute());
                    }
                    if ((currentRange = this.scriptVars.get(var9_11)) != null && ownRange.compareTo(currentRange) <= 0 && (!varScopeCheck || this.scopeStack.contains(var9_11))) continue;
                    this.scriptVars.put((String)var9_11, ownRange);
                    vec.add(tagVarInfos[i2]);
                }
            }
            if (varScopeCheck) {
                for (Object e2 : vec) {
                    if (e2 instanceof VariableInfo) {
                        this.scopeStack.push(((VariableInfo)e2).getVarName());
                        continue;
                    }
                    if (!(e2 instanceof TagVariableInfo)) continue;
                    String varName2 = ((TagVariableInfo)e2).getNameGiven();
                    if (varName2 == null) {
                        varName2 = n2.getTagData().getAttributeString(((TagVariableInfo)e2).getNameFromAttribute());
                    }
                    this.scopeStack.push(varName2);
                }
            }
            n2.setScriptingVars(vec, scope);
        }

        final class Mark {
            int cursor;
            int line;
            int col;
            char[] stream = null;

            public Mark(char[] inStream) {
                this.stream = inStream;
                this.cursor = 0;
                this.line = 1;
                this.col = 1;
            }

            public Mark(Mark other) {
                this.cursor = other.cursor;
                this.line = other.line;
                this.col = other.col;
                this.stream = other.stream;
            }

            public String toString() {
                return "Mark [cursor=" + this.cursor + ", line=" + this.line + ", col=" + this.col + ", stream=" + Arrays.toString(this.stream) + "]";
            }
        }

        class JspScriptReader {
            private Mark current;

            public JspScriptReader(char[] inStream) {
                this.current = new Mark(inStream);
            }

            public Mark skipUntil(char limit) {
                boolean escape = false;
                int ch = this.nextChar();
                while (ch != -1) {
                    block6: {
                        block5: {
                            if (ch != 92) break block5;
                            ch = this.nextChar();
                            if (ch == 92) break block6;
                            escape = true;
                        }
                        if (ch == limit && !escape) {
                            return new Mark(this.current);
                        }
                        escape = false;
                    }
                    ch = this.nextChar();
                }
                return null;
            }

            public Mark skipUntil(String limit) {
                int limLen = limit.length();
                int ch = this.nextChar();
                while (ch != -1) {
                    block4: {
                        if (ch == limit.charAt(0)) {
                            Mark restart = this.mark();
                            for (int i2 = 1; i2 < limLen; ++i2) {
                                if (this.peekChar() != limit.charAt(i2)) {
                                    this.reset(restart);
                                    break block4;
                                }
                                this.nextChar();
                            }
                            return this.mark();
                        }
                    }
                    ch = this.nextChar();
                }
                return null;
            }

            public int nextChar() {
                if (!this.hasMoreInput()) {
                    return -1;
                }
                char ch = this.current.stream[this.current.cursor];
                ++this.current.cursor;
                if (ch == '\n') {
                    ++this.current.line;
                    this.current.col = 0;
                } else {
                    ++this.current.col;
                }
                return ch;
            }

            public int peekChar() {
                if (!this.hasMoreInput()) {
                    return -1;
                }
                return this.current.stream[this.current.cursor];
            }

            public void reset(Mark mark) {
                this.current = new Mark(mark);
            }

            public Mark mark() {
                return new Mark(this.current);
            }

            public boolean hasMoreInput() {
                return this.current.stream != null && this.current.cursor < this.current.stream.length;
            }
        }
    }

    private static class CustomTagCounter
    extends Node.Visitor {
        private int count;
        private Node.CustomTag parent;

        private CustomTagCounter() {
        }

        @Override
        public void visit(Node.CustomTag n2) throws JasperException {
            n2.setCustomTagParent(this.parent);
            Node.CustomTag tmpParent = this.parent;
            this.parent = n2;
            this.visitBody(n2);
            this.parent = tmpParent;
            n2.setNumCount(this.count++);
        }
    }
}

