/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.jasper.compiler;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.jasper.JasperException;
import com.bes.enterprise.web.jasper.JspCompilationContext;
import com.bes.enterprise.web.jasper.compiler.Localizer;
import com.bes.enterprise.web.jasper.compiler.Mark;
import com.bes.enterprise.web.jasper.compiler.Node;
import com.bes.enterprise.web.jasper.compiler.SmapGenerator;
import com.bes.enterprise.web.jasper.compiler.SmapStratum;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SmapUtil {
    private static final String SMAP_ENCODING = "UTF-8";

    public static String[] generateSmap(JspCompilationContext ctxt, Node.Nodes pageNodes) throws IOException {
        PreScanVisitor psVisitor = new PreScanVisitor();
        try {
            pageNodes.visit(psVisitor);
        }
        catch (JasperException jasperException) {
            // empty catch block
        }
        HashMap<String, SmapStratum> map = psVisitor.getMap();
        SmapGenerator g2 = new SmapGenerator();
        SmapStratum s2 = new SmapStratum();
        g2.setOutputFileName(SmapUtil.unqualify(ctxt.getServletJavaFileName()));
        SmapUtil.evaluateNodes(pageNodes, s2, map, ctxt.getOptions().getMappedFile());
        s2.optimizeLineSection();
        g2.setStratum(s2);
        if (ctxt.getOptions().isSmapDumped()) {
            File outSmap = new File(ctxt.getClassFileName() + ".smap");
            PrintWriter so = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outSmap), SMAP_ENCODING));
            so.print(g2.getString());
            so.close();
        }
        String classFileName = ctxt.getClassFileName();
        int innerClassCount = map.size();
        String[] smapInfo = new String[2 + innerClassCount * 2];
        smapInfo[0] = classFileName;
        smapInfo[1] = g2.getString();
        int count = 2;
        for (Map.Entry<String, SmapStratum> entry : map.entrySet()) {
            String innerClass = entry.getKey();
            s2 = entry.getValue();
            s2.optimizeLineSection();
            g2 = new SmapGenerator();
            g2.setOutputFileName(SmapUtil.unqualify(ctxt.getServletJavaFileName()));
            g2.setStratum(s2);
            String innerClassFileName = classFileName.substring(0, classFileName.indexOf(".class")) + '$' + innerClass + ".class";
            if (ctxt.getOptions().isSmapDumped()) {
                File outSmap = new File(innerClassFileName + ".smap");
                PrintWriter so = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outSmap), SMAP_ENCODING));
                so.print(g2.getString());
                so.close();
            }
            smapInfo[count] = innerClassFileName;
            smapInfo[count + 1] = g2.getString();
            count += 2;
        }
        return smapInfo;
    }

    public static void installSmap(String[] smap) throws IOException {
        if (smap == null) {
            return;
        }
        for (int i2 = 0; i2 < smap.length; i2 += 2) {
            File outServlet = new File(smap[i2]);
            SDEInstaller.install(outServlet, smap[i2 + 1].getBytes(StandardCharsets.ISO_8859_1));
        }
    }

    private static String unqualify(String path) {
        path = path.replace('\\', '/');
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static void evaluateNodes(Node.Nodes nodes, SmapStratum s2, HashMap<String, SmapStratum> innerClassMap, boolean breakAtLF) {
        try {
            nodes.visit(new SmapGenVisitor(s2, breakAtLF, innerClassMap));
        }
        catch (JasperException jasperException) {
            // empty catch block
        }
    }

    private static class PreScanVisitor
    extends Node.Visitor {
        HashMap<String, SmapStratum> map = new HashMap();

        private PreScanVisitor() {
        }

        @Override
        public void doVisit(Node n2) {
            String inner = n2.getInnerClassName();
            if (inner != null && !this.map.containsKey(inner)) {
                this.map.put(inner, new SmapStratum());
            }
        }

        HashMap<String, SmapStratum> getMap() {
            return this.map;
        }
    }

    private static class SmapGenVisitor
    extends Node.Visitor {
        private SmapStratum smap;
        private final boolean breakAtLF;
        private final HashMap<String, SmapStratum> innerClassMap;

        SmapGenVisitor(SmapStratum s2, boolean breakAtLF, HashMap<String, SmapStratum> map) {
            this.smap = s2;
            this.breakAtLF = breakAtLF;
            this.innerClassMap = map;
        }

        @Override
        public void visitBody(Node n2) throws JasperException {
            SmapStratum smapSave = this.smap;
            String innerClass = n2.getInnerClassName();
            if (innerClass != null) {
                this.smap = this.innerClassMap.get(innerClass);
            }
            super.visitBody(n2);
            this.smap = smapSave;
        }

        @Override
        public void visit(Node.Declaration n2) throws JasperException {
            this.doSmapText(n2);
        }

        @Override
        public void visit(Node.Expression n2) throws JasperException {
            this.doSmapText(n2);
        }

        @Override
        public void visit(Node.Scriptlet n2) throws JasperException {
            this.doSmapText(n2);
        }

        @Override
        public void visit(Node.IncludeAction n2) throws JasperException {
            this.doSmap(n2);
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.ForwardAction n2) throws JasperException {
            this.doSmap(n2);
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.GetProperty n2) throws JasperException {
            this.doSmap(n2);
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.SetProperty n2) throws JasperException {
            this.doSmap(n2);
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.UseBean n2) throws JasperException {
            this.doSmap(n2);
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.PlugIn n2) throws JasperException {
            this.doSmap(n2);
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.CustomTag n2) throws JasperException {
            this.doSmap(n2);
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.UninterpretedTag n2) throws JasperException {
            this.doSmap(n2);
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.JspElement n2) throws JasperException {
            this.doSmap(n2);
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.JspText n2) throws JasperException {
            this.doSmap(n2);
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.NamedAttribute n2) throws JasperException {
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.JspBody n2) throws JasperException {
            this.doSmap(n2);
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.InvokeAction n2) throws JasperException {
            this.doSmap(n2);
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.DoBodyAction n2) throws JasperException {
            this.doSmap(n2);
            this.visitBody(n2);
        }

        @Override
        public void visit(Node.ELExpression n2) throws JasperException {
            this.doSmap(n2);
        }

        @Override
        public void visit(Node.TemplateText n2) throws JasperException {
            Mark mark = n2.getStart();
            if (mark == null) {
                return;
            }
            String fileName = mark.getFile();
            this.smap.addFile(SmapUtil.unqualify(fileName), fileName);
            int iInputStartLine = mark.getLineNumber();
            int iOutputStartLine = n2.getBeginJavaLine();
            int iOutputLineIncrement = this.breakAtLF ? 1 : 0;
            this.smap.addLineData(iInputStartLine, fileName, 1, iOutputStartLine, iOutputLineIncrement);
            ArrayList<Integer> extraSmap = n2.getExtraSmap();
            if (extraSmap != null) {
                for (int i2 = 0; i2 < extraSmap.size(); ++i2) {
                    this.smap.addLineData(iInputStartLine + extraSmap.get(i2), fileName, 1, iOutputStartLine += iOutputLineIncrement, iOutputLineIncrement);
                }
            }
        }

        private void doSmap(Node n2, int inLineCount, int outIncrement, int skippedLines) {
            Mark mark = n2.getStart();
            if (mark == null) {
                return;
            }
            String unqualifiedName = SmapUtil.unqualify(mark.getFile());
            this.smap.addFile(unqualifiedName, mark.getFile());
            this.smap.addLineData(mark.getLineNumber() + skippedLines, mark.getFile(), inLineCount - skippedLines, n2.getBeginJavaLine() + skippedLines, outIncrement);
        }

        private void doSmap(Node n2) {
            this.doSmap(n2, 1, n2.getEndJavaLine() - n2.getBeginJavaLine(), 0);
        }

        private void doSmapText(Node n2) {
            String text = n2.getText();
            int index = 0;
            int next = 0;
            int lineCount = 1;
            int skippedLines = 0;
            boolean slashStarSeen = false;
            boolean beginning = true;
            while ((next = text.indexOf(10, index)) > -1) {
                if (beginning) {
                    String line = text.substring(index, next).trim();
                    if (!slashStarSeen && line.startsWith("/*")) {
                        slashStarSeen = true;
                    }
                    if (slashStarSeen) {
                        ++skippedLines;
                        int endIndex = line.indexOf("*/");
                        if (endIndex >= 0) {
                            slashStarSeen = false;
                            if (endIndex < line.length() - 2) {
                                --skippedLines;
                                beginning = false;
                            }
                        }
                    } else if (line.length() == 0 || line.startsWith("//")) {
                        ++skippedLines;
                    } else {
                        beginning = false;
                    }
                }
                ++lineCount;
                index = next + 1;
            }
            this.doSmap(n2, lineCount, 1, skippedLines);
        }
    }

    private static class SDEInstaller {
        private final Log log = LogFactory.getLog(SDEInstaller.class);
        static final String nameSDE = "SourceDebugExtension";
        byte[] orig;
        byte[] sdeAttr;
        byte[] gen;
        int origPos = 0;
        int genPos = 0;
        int sdeIndex;

        static void install(File classFile, byte[] smap) throws IOException {
            File tmpFile = new File(classFile.getPath() + "tmp");
            SDEInstaller installer = new SDEInstaller(classFile, smap);
            installer.install(tmpFile);
            if (!classFile.delete()) {
                throw new IOException(Localizer.getMessage("jsp.error.unable.deleteClassFile", classFile.getAbsolutePath()));
            }
            if (!tmpFile.renameTo(classFile)) {
                throw new IOException(Localizer.getMessage("jsp.error.unable.renameClassFile", tmpFile.getAbsolutePath(), classFile.getAbsolutePath()));
            }
        }

        SDEInstaller(File inClassFile, byte[] sdeAttr) throws IOException {
            if (!inClassFile.exists()) {
                throw new FileNotFoundException("no such file: " + inClassFile);
            }
            this.sdeAttr = sdeAttr;
            this.orig = SDEInstaller.readWhole(inClassFile);
            this.gen = new byte[this.orig.length + sdeAttr.length + 100];
        }

        void install(File outClassFile) throws IOException {
            this.addSDE();
            try (FileOutputStream outStream = new FileOutputStream(outClassFile);){
                outStream.write(this.gen, 0, this.genPos);
            }
        }

        static byte[] readWhole(File input) throws IOException {
            int len = (int)input.length();
            byte[] bytes = new byte[len];
            try (FileInputStream inStream = new FileInputStream(input);){
                if (inStream.read(bytes, 0, len) != len) {
                    throw new IOException("expected size: " + len);
                }
            }
            return bytes;
        }

        void addSDE() throws UnsupportedEncodingException, IOException {
            this.copy(8);
            int constantPoolCountPos = this.genPos;
            int constantPoolCount = this.readU2();
            if (this.log.isDebugEnabled()) {
                this.log.debug("constant pool count: " + constantPoolCount);
            }
            this.writeU2(constantPoolCount);
            this.sdeIndex = this.copyConstantPool(constantPoolCount);
            if (this.sdeIndex < 0) {
                this.writeUtf8ForSDE();
                this.sdeIndex = constantPoolCount++;
                this.randomAccessWriteU2(constantPoolCountPos, constantPoolCount);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("SourceDebugExtension not found, installed at: " + this.sdeIndex);
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("SourceDebugExtension found at: " + this.sdeIndex);
            }
            this.copy(6);
            int interfaceCount = this.readU2();
            this.writeU2(interfaceCount);
            if (this.log.isDebugEnabled()) {
                this.log.debug("interfaceCount: " + interfaceCount);
            }
            this.copy(interfaceCount * 2);
            this.copyMembers();
            this.copyMembers();
            int attrCountPos = this.genPos;
            int attrCount = this.readU2();
            this.writeU2(attrCount);
            if (this.log.isDebugEnabled()) {
                this.log.debug("class attrCount: " + attrCount);
            }
            if (!this.copyAttrs(attrCount)) {
                this.randomAccessWriteU2(attrCountPos, ++attrCount);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("class attrCount incremented");
                }
            }
            this.writeAttrForSDE(this.sdeIndex);
        }

        void copyMembers() {
            int count = this.readU2();
            this.writeU2(count);
            if (this.log.isDebugEnabled()) {
                this.log.debug("members count: " + count);
            }
            for (int i2 = 0; i2 < count; ++i2) {
                this.copy(6);
                int attrCount = this.readU2();
                this.writeU2(attrCount);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("member attr count: " + attrCount);
                }
                this.copyAttrs(attrCount);
            }
        }

        boolean copyAttrs(int attrCount) {
            boolean sdeFound = false;
            for (int i2 = 0; i2 < attrCount; ++i2) {
                int nameIndex = this.readU2();
                if (nameIndex == this.sdeIndex) {
                    sdeFound = true;
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("SDE attr found");
                    continue;
                }
                this.writeU2(nameIndex);
                int len = this.readU4();
                this.writeU4(len);
                this.copy(len);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("attr len: " + len);
            }
            return sdeFound;
        }

        void writeAttrForSDE(int index) {
            this.writeU2(index);
            this.writeU4(this.sdeAttr.length);
            for (int i2 = 0; i2 < this.sdeAttr.length; ++i2) {
                this.writeU1(this.sdeAttr[i2]);
            }
        }

        void randomAccessWriteU2(int pos, int val) {
            int savePos = this.genPos;
            this.genPos = pos;
            this.writeU2(val);
            this.genPos = savePos;
        }

        int readU1() {
            return this.orig[this.origPos++] & 0xFF;
        }

        int readU2() {
            int res = this.readU1();
            return (res << 8) + this.readU1();
        }

        int readU4() {
            int res = this.readU2();
            return (res << 16) + this.readU2();
        }

        void writeU1(int val) {
            this.gen[this.genPos++] = (byte)val;
        }

        void writeU2(int val) {
            this.writeU1(val >> 8);
            this.writeU1(val & 0xFF);
        }

        void writeU4(int val) {
            this.writeU2(val >> 16);
            this.writeU2(val & 0xFFFF);
        }

        void copy(int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                this.gen[this.genPos++] = this.orig[this.origPos++];
            }
        }

        byte[] readBytes(int count) {
            byte[] bytes = new byte[count];
            for (int i2 = 0; i2 < count; ++i2) {
                bytes[i2] = this.orig[this.origPos++];
            }
            return bytes;
        }

        void writeBytes(byte[] bytes) {
            for (int i2 = 0; i2 < bytes.length; ++i2) {
                this.gen[this.genPos++] = bytes[i2];
            }
        }

        int copyConstantPool(int constantPoolCount) throws UnsupportedEncodingException, IOException {
            int sdeIndex = -1;
            block7: for (int i2 = 1; i2 < constantPoolCount; ++i2) {
                int tag = this.readU1();
                this.writeU1(tag);
                switch (tag) {
                    case 7: 
                    case 8: 
                    case 16: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(i2 + " copying 2 bytes");
                        }
                        this.copy(2);
                        continue block7;
                    }
                    case 15: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(i2 + " copying 3 bytes");
                        }
                        this.copy(3);
                        continue block7;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 18: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(i2 + " copying 4 bytes");
                        }
                        this.copy(4);
                        continue block7;
                    }
                    case 5: 
                    case 6: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(i2 + " copying 8 bytes");
                        }
                        this.copy(8);
                        ++i2;
                        continue block7;
                    }
                    case 1: {
                        int len = this.readU2();
                        this.writeU2(len);
                        byte[] utf8 = this.readBytes(len);
                        String str = new String(utf8, SmapUtil.SMAP_ENCODING);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(i2 + " read class attr -- '" + str + "'");
                        }
                        if (str.equals(nameSDE)) {
                            sdeIndex = i2;
                        }
                        this.writeBytes(utf8);
                        continue block7;
                    }
                    default: {
                        throw new IOException("unexpected tag: " + tag);
                    }
                }
            }
            return sdeIndex;
        }

        void writeUtf8ForSDE() {
            int len = nameSDE.length();
            this.writeU1(1);
            this.writeU2(len);
            for (int i2 = 0; i2 < len; ++i2) {
                this.writeU1(nameSDE.charAt(i2));
            }
        }
    }
}

