/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.jasper.compiler;

import com.bes.enterprise.web.jasper.JasperException;
import com.bes.enterprise.web.jasper.Options;
import com.bes.enterprise.web.jasper.compiler.Compiler;
import com.bes.enterprise.web.jasper.compiler.Node;
import com.bes.enterprise.web.jasper.compiler.PageInfo;

public class TextOptimizer {
    public static void concatenate(Compiler compiler, Node.Nodes page) throws JasperException {
        TextCatVisitor v2 = new TextCatVisitor(compiler);
        page.visit(v2);
        v2.collectText();
    }

    private static class TextCatVisitor
    extends Node.Visitor {
        private static final String EMPTY_TEXT = "";
        private final Options options;
        private final PageInfo pageInfo;
        private int textNodeCount = 0;
        private Node.TemplateText firstTextNode = null;
        private StringBuilder textBuffer;

        public TextCatVisitor(Compiler compiler) {
            this.options = compiler.getCompilationContext().getOptions();
            this.pageInfo = compiler.getPageInfo();
        }

        @Override
        public void doVisit(Node n2) throws JasperException {
            this.collectText();
        }

        @Override
        public void visit(Node.PageDirective n2) throws JasperException {
        }

        @Override
        public void visit(Node.TagDirective n2) throws JasperException {
        }

        @Override
        public void visit(Node.TaglibDirective n2) throws JasperException {
        }

        @Override
        public void visit(Node.AttributeDirective n2) throws JasperException {
        }

        @Override
        public void visit(Node.VariableDirective n2) throws JasperException {
        }

        @Override
        public void visitBody(Node n2) throws JasperException {
            super.visitBody(n2);
            this.collectText();
        }

        @Override
        public void visit(Node.TemplateText n2) throws JasperException {
            if ((this.options.getTrimSpaces() || this.pageInfo.isTrimDirectiveWhitespaces()) && n2.isAllSpace()) {
                n2.setText(EMPTY_TEXT);
                return;
            }
            if (this.textNodeCount++ == 0) {
                this.firstTextNode = n2;
                this.textBuffer = new StringBuilder(n2.getText());
            } else {
                this.textBuffer.append(n2.getText());
                n2.setText(EMPTY_TEXT);
            }
        }

        private void collectText() {
            if (this.textNodeCount > 1) {
                this.firstTextNode.setText(this.textBuffer.toString());
            }
            this.textNodeCount = 0;
        }
    }
}

