/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.jasper.runtime;

import com.bes.enterprise.web.jasper.Constants;
import com.bes.enterprise.web.jasper.el.ELContextImpl;
import com.bes.enterprise.web.jasper.el.JasperELResolver;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELContextEvent;
import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspContext;

public class JspApplicationContextImpl
implements JspApplicationContext {
    private static final String KEY = JspApplicationContextImpl.class.getName();
    private final ExpressionFactory expressionFactory = ExpressionFactory.newInstance();
    private final List<ELContextListener> contextListeners = new ArrayList<ELContextListener>();
    private final List<ELResolver> resolvers = new ArrayList<ELResolver>();
    private boolean instantiated = false;
    private ELResolver resolver;

    @Override
    public void addELContextListener(ELContextListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("ELContextListener was null");
        }
        this.contextListeners.add(listener);
    }

    public static JspApplicationContextImpl getInstance(ServletContext context) {
        if (context == null) {
            throw new IllegalArgumentException("ServletContext was null");
        }
        JspApplicationContextImpl impl = (JspApplicationContextImpl)context.getAttribute(KEY);
        if (impl == null) {
            impl = new JspApplicationContextImpl();
            context.setAttribute(KEY, impl);
        }
        return impl;
    }

    public ELContextImpl createELContext(JspContext context) {
        if (context == null) {
            throw new IllegalArgumentException("JspContext was null");
        }
        final ELResolver r2 = this.createELResolver();
        ELContextImpl ctx = Constants.IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedAction<ELContextImpl>(){

            @Override
            public ELContextImpl run() {
                return new ELContextImpl(r2);
            }
        }) : new ELContextImpl(r2);
        ctx.putContext(JspContext.class, context);
        this.fireListeners(ctx);
        return ctx;
    }

    protected void fireListeners(ELContext elContext) {
        ELContextEvent event = new ELContextEvent(elContext);
        for (int i2 = 0; i2 < this.contextListeners.size(); ++i2) {
            this.contextListeners.get(i2).contextCreated(event);
        }
    }

    private ELResolver createELResolver() {
        this.instantiated = true;
        if (this.resolver == null) {
            JasperELResolver r2 = new JasperELResolver(this.resolvers, this.expressionFactory.getStreamELResolver());
            this.resolver = r2;
        }
        return this.resolver;
    }

    @Override
    public void addELResolver(ELResolver resolver) throws IllegalStateException {
        if (resolver == null) {
            throw new IllegalArgumentException("ELResolver was null");
        }
        if (this.instantiated) {
            throw new IllegalStateException("cannot call addELResolver after the first request has been made");
        }
        this.resolvers.add(resolver);
    }

    @Override
    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }
}

