/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.jasper.servlet;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.InstanceManager;
import com.bes.enterprise.web.SimpleInstanceManager;
import com.bes.enterprise.web.jasper.compiler.Localizer;
import com.bes.enterprise.web.jasper.compiler.TldCache;
import com.bes.enterprise.web.jasper.runtime.JspFactoryImpl;
import com.bes.enterprise.web.jasper.security.SecurityClassLoad;
import com.bes.enterprise.web.jasper.servlet.TldScanner;
import java.io.IOException;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspFactory;
import org.xml.sax.SAXException;

public class JasperInitializer
implements ServletContainerInitializer {
    private static final String MSG = "com.bes.enterprise.web.jasper.servlet.JasperInitializer";
    private final Log log = LogFactory.getLog(JasperInitializer.class);

    @Override
    public void onStartup(Set<Class<?>> types, ServletContext context) throws ServletException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(Localizer.getMessage("com.bes.enterprise.web.jasper.servlet.JasperInitializer.onStartup", context.getServletContextName()));
        }
        if (context.getAttribute(InstanceManager.class.getName()) == null) {
            context.setAttribute(InstanceManager.class.getName(), new SimpleInstanceManager());
        }
        boolean validate = Boolean.parseBoolean(context.getInitParameter("com.bes.enterprise.web.jasper.XML_VALIDATE_TLD"));
        String blockExternalString = context.getInitParameter("com.bes.enterprise.web.jasper.XML_BLOCK_EXTERNAL");
        boolean blockExternal = blockExternalString == null ? true : Boolean.parseBoolean(blockExternalString);
        TldScanner scanner = this.newTldScanner(context, true, validate, blockExternal);
        try {
            scanner.scan();
        }
        catch (IOException | SAXException e2) {
            throw new ServletException(e2);
        }
        for (String listener : scanner.getListeners()) {
            context.addListener(listener);
        }
        context.setAttribute(TldCache.SERVLET_CONTEXT_ATTRIBUTE_NAME, new TldCache(context, scanner.getUriTldResourcePathMap(), scanner.getTldResourcePathTaglibXmlMap()));
    }

    protected TldScanner newTldScanner(ServletContext context, boolean namespaceAware, boolean validate, boolean blockExternal) {
        return new TldScanner(context, namespaceAware, validate, blockExternal);
    }

    static {
        JspFactoryImpl factory = new JspFactoryImpl();
        SecurityClassLoad.securityClassLoad(factory.getClass().getClassLoader());
        if (System.getSecurityManager() != null) {
            String basePackage = "com.bes.enterprise.web.jasper.";
            try {
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspFactoryImpl$PrivilegedGetPageContext");
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspFactoryImpl$PrivilegedReleasePageContext");
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspRuntimeLibrary");
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.ServletResponseWrapperInclude");
                factory.getClass().getClassLoader().loadClass(basePackage + "servlet.JspServletWrapper");
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
        }
        if (JspFactory.getDefaultFactory() == null) {
            JspFactory.setDefaultFactory(factory);
        }
    }
}

