/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.jasper.util;

import com.bes.enterprise.web.jasper.compiler.Localizer;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class UniqueAttributesImpl
extends AttributesImpl {
    private static final String IMPORT = "import";
    private static final String PAGE_ENCODING = "pageEncoding";
    public static final boolean CUSTOMTAG_ALLOW_DUPLICATE = Boolean.getBoolean("com.bes.enterprise.web.compatibleWeblogic");
    private final boolean pageDirective;
    private final Set<String> qNames = new HashSet<String>();

    public UniqueAttributesImpl() {
        this.pageDirective = false;
    }

    public UniqueAttributesImpl(boolean pageDirective) {
        this.pageDirective = pageDirective;
    }

    @Override
    public void clear() {
        this.qNames.clear();
        super.clear();
    }

    @Override
    public void setAttributes(Attributes atts) {
        for (int i2 = 0; i2 < atts.getLength(); ++i2) {
            if (this.qNames.add(atts.getQName(i2))) continue;
            this.handleDuplicate(atts.getQName(i2), atts.getValue(i2));
        }
        super.setAttributes(atts);
    }

    @Override
    public void addAttribute(String uri, String localName, String qName, String type, String value) {
        if (this.qNames.add(qName)) {
            super.addAttribute(uri, localName, qName, type, value);
        } else {
            this.handleDuplicate(qName, value);
        }
    }

    @Override
    public void setAttribute(int index, String uri, String localName, String qName, String type, String value) {
        this.qNames.remove(super.getQName(index));
        if (this.qNames.add(qName)) {
            super.setAttribute(index, uri, localName, qName, type, value);
        } else {
            this.handleDuplicate(qName, value);
        }
    }

    @Override
    public void removeAttribute(int index) {
        this.qNames.remove(super.getQName(index));
        super.removeAttribute(index);
    }

    @Override
    public void setQName(int index, String qName) {
        this.qNames.remove(super.getQName(index));
        super.setQName(index, qName);
    }

    private void handleDuplicate(String qName, String value) {
        if (this.pageDirective) {
            String v2;
            if (IMPORT.equalsIgnoreCase(qName)) {
                int i2 = super.getIndex(IMPORT);
                String v3 = super.getValue(i2);
                super.setValue(i2, v3 + "," + value);
                return;
            }
            if (!PAGE_ENCODING.equalsIgnoreCase(qName) && (v2 = super.getValue(qName)).equals(value)) {
                return;
            }
        }
        if (CUSTOMTAG_ALLOW_DUPLICATE && this.qNames.contains(qName)) {
            int i3 = super.getIndex(qName);
            String v4 = super.getValue(i3);
            if (v4.equals(value)) {
                return;
            }
            super.setValue(i3, value);
            return;
        }
        throw new IllegalArgumentException(Localizer.getMessage("jsp.error.duplicateqname", qName));
    }
}

