/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util;

import com.bes.enterprise.appserver.common.util.StringUtils;
import com.bes.enterprise.config.miniparser.DomTemplate;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.IntrospectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BeanInspectUtils {
    protected static Log log = LogFactory.getLog(BeanInspectUtils.class.getName());
    public static List<String> fakeAttributes = new ArrayList<String>();

    public static void transmitProperties(Object dest, DomTemplate domTemplate, boolean excludeFakeAttibute) {
        Map<String, String> allAttributes = domTemplate.getAllAttributes();
        for (String attributesName : allAttributes.keySet()) {
            String name = StringUtils.strikeToCamel((String)attributesName);
            String value = domTemplate.getAttribute(attributesName);
            if (value == null || fakeAttributes.contains(name) || IntrospectionUtils.setProperty(dest, name, value)) continue;
            log.trace("Setting property '" + name + "' to '" + value + "' for " + dest.getClass().getName() + " did not find a matching property.");
        }
    }

    public static void transmitProperties(Object dest, DomTemplate domTemplate) {
        BeanInspectUtils.transmitProperties(dest, domTemplate, true);
    }

    public static void transmitProperties(Object dest, Object src, boolean excludeFakeAttibute) {
        if (src instanceof DomTemplate) {
            DomTemplate proxy = (DomTemplate)src;
            BeanInspectUtils.transmitProperties(dest, proxy, excludeFakeAttibute);
        }
    }

    public static void transmitProperties(Object dest, Object src) {
        BeanInspectUtils.transmitProperties(dest, src, true);
    }

    public static void transmitProperty(Object dest, String name, String value) {
        BeanInspectUtils.transmitProperty(dest, name, value, true);
    }

    private static void transmitProperty(Object dest, String name, String value, boolean excludeFakeAttibute) {
        if (value == null) {
            return;
        }
        if (excludeFakeAttibute && fakeAttributes.contains(name)) {
            return;
        }
        IntrospectionUtils.setProperty(dest, name, value);
    }

    public static void transmitProperties(Object dest, List<DomTemplate> properties) {
        BeanInspectUtils.transmitProperties(dest, properties, true);
    }

    public static void transmitProperties(Object dest, List<DomTemplate> properties, boolean excludeFakeAttibute) {
        for (DomTemplate prop : properties) {
            String value;
            if (excludeFakeAttibute && fakeAttributes.contains(prop.getAttribute("name")) || (value = prop.getAttribute("value")) == null) continue;
            IntrospectionUtils.setProperty(dest, prop.getAttribute("name"), value);
        }
    }

    public static void transmitProperties(Object dest, Map<String, String> properties) {
        BeanInspectUtils.transmitProperties(dest, properties, true);
    }

    public static void transmitProperties(Object dest, Map<String, String> properties, boolean excludeFakeAttibute) {
        for (Map.Entry<String, String> obj : properties.entrySet()) {
            String value;
            if (excludeFakeAttibute && fakeAttributes.contains(obj.getKey()) || (value = obj.getValue()) == null) continue;
            IntrospectionUtils.setProperty(dest, obj.getKey(), value);
        }
    }

    static {
        fakeAttributes.add("className");
    }
}

