/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.bcel.classfile;

import com.bes.enterprise.web.util.bcel.classfile.Constant;
import com.bes.enterprise.web.util.bcel.classfile.ConstantClass;
import com.bes.enterprise.web.util.bcel.classfile.ConstantPool;
import com.bes.enterprise.web.util.bcel.classfile.ConstantUtf8;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;

final class Utility {
    private Utility() {
    }

    static String compactClassName(String str) {
        return str.replace('/', '.');
    }

    static String getClassName(ConstantPool constant_pool, int index) {
        Constant c2 = constant_pool.getConstant(index, (byte)7);
        int i2 = ((ConstantClass)c2).getNameIndex();
        c2 = constant_pool.getConstant(i2, (byte)1);
        String name = ((ConstantUtf8)c2).getBytes();
        return Utility.compactClassName(name);
    }

    static void skipFully(DataInput file, int length) throws IOException {
        int total = file.skipBytes(length);
        if (total != length) {
            throw new EOFException();
        }
    }

    static void swallowFieldOrMethod(DataInput file) throws IOException {
        Utility.skipFully(file, 6);
        int attributes_count = file.readUnsignedShort();
        for (int i2 = 0; i2 < attributes_count; ++i2) {
            Utility.swallowAttribute(file);
        }
    }

    static void swallowAttribute(DataInput file) throws IOException {
        Utility.skipFully(file, 2);
        int length = file.readInt();
        Utility.skipFully(file, length);
    }
}

