/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.buf;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.buf.B2CConverter;
import com.bes.enterprise.web.util.buf.ByteChunk;
import com.bes.enterprise.web.util.buf.CharChunk;
import com.bes.enterprise.web.util.buf.MessageBytes;
import com.bes.enterprise.web.util.res.StringManager;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class UDecoder {
    private static final StringManager sm = StringManager.getManager(UDecoder.class);
    private static final Log log = LogFactory.getLog(UDecoder.class);
    public static final boolean ALLOW_ENCODED_SLASH = Boolean.parseBoolean(System.getProperty("com.bes.enterprise.web.util.buf.UDecoder.ALLOW_ENCODED_SLASH", "false"));
    public static final boolean UDECODER_ILLEGAL_CHARACTERS = Boolean.getBoolean("com.bes.enterprise.web.util.UDECODER_ILLEGAL_CHARACTERS");
    private static final byte[] VAL = new byte[]{63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 63, 63, 63, 63, 63, 63, 63, 10, 11, 12, 13, 14, 15, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 10, 11, 12, 13, 14, 15, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63};
    private static final IOException EXCEPTION_EOF = new DecodeException(sm.getString("uDecoder.eof"));
    private static final IOException EXCEPTION_NOT_HEX_DIGIT = new DecodeException("isHexDigit");
    private static final IOException EXCEPTION_SLASH = new DecodeException("noSlash");

    public void convert(ByteChunk mb, boolean query) throws IOException {
        int start = mb.getOffset();
        byte[] buff = mb.getBytes();
        int end = mb.getEnd();
        int idx = ByteChunk.findByte(buff, start, end, (byte)37);
        int idx2 = -1;
        if (query) {
            idx2 = ByteChunk.findByte(buff, start, idx >= 0 ? idx : end, (byte)43);
        }
        if (idx < 0 && idx2 < 0) {
            return;
        }
        if (idx2 >= 0 && idx2 < idx || idx < 0) {
            idx = idx2;
        }
        boolean noSlash = !ALLOW_ENCODED_SLASH && !query;
        int j2 = idx;
        while (j2 < end) {
            if (buff[j2] == 43 && query) {
                buff[idx] = 32;
            } else if (buff[j2] != 37) {
                buff[idx] = buff[j2];
            } else {
                if (j2 + 2 >= end) {
                    throw EXCEPTION_EOF;
                }
                byte b1 = buff[j2 + 1];
                byte b2 = buff[j2 + 2];
                if (!UDecoder.isHexDigit(b1) || !UDecoder.isHexDigit(b2)) {
                    throw EXCEPTION_NOT_HEX_DIGIT;
                }
                j2 += 2;
                int res = UDecoder.x2c(b1, b2);
                if (noSlash && res == 47) {
                    throw EXCEPTION_SLASH;
                }
                buff[idx] = (byte)res;
            }
            ++j2;
            ++idx;
        }
        mb.setEnd(idx);
    }

    public void convert(ByteChunk mb, String charset) throws IOException {
        boolean query = true;
        int start = mb.getOffset();
        byte[] buff = mb.getBytes();
        int end = mb.getEnd();
        int idx = ByteChunk.findByte(buff, start, end, (byte)37);
        int idx2 = -1;
        if (query) {
            idx2 = ByteChunk.findByte(buff, start, idx >= 0 ? idx : end, (byte)43);
        }
        if (idx < 0 && idx2 < 0) {
            return;
        }
        if (idx2 >= 0 && idx2 < idx || idx < 0) {
            idx = idx2;
        }
        boolean noSlash = !ALLOW_ENCODED_SLASH && !query;
        int j2 = idx;
        while (j2 < end) {
            if (buff[j2] == 43 && query) {
                buff[idx] = 32;
            } else if (buff[j2] != 37) {
                buff[idx] = buff[j2];
            } else {
                byte b2;
                byte b1;
                if (j2 + 2 >= end) {
                    throw EXCEPTION_EOF;
                }
                if (buff[j2 + 1] == 117) {
                    if (j2 + 5 >= end) {
                        throw EXCEPTION_EOF;
                    }
                    b1 = buff[j2 + 2];
                    b2 = buff[j2 + 3];
                    byte b3 = buff[j2 + 4];
                    byte b4 = buff[j2 + 5];
                    if (!(UDecoder.isHexDigit(b1) && UDecoder.isHexDigit(b2) && UDecoder.isHexDigit(b3) && UDecoder.isHexDigit(b4))) {
                        throw EXCEPTION_NOT_HEX_DIGIT;
                    }
                    int cint = 0;
                    cint = cint << 4 | VAL[b1];
                    cint = cint << 4 | VAL[b2];
                    cint = cint << 4 | VAL[b3];
                    cint = cint << 4 | VAL[b4];
                    j2 += 5;
                    byte[] bs = new String(new char[]{(char)cint}).getBytes(charset);
                    for (int i2 = 0; i2 < bs.length; ++i2) {
                        buff[idx + i2] = bs[i2];
                    }
                    idx += bs.length - 1;
                } else {
                    int res;
                    b1 = buff[j2 + 1];
                    b2 = buff[j2 + 2];
                    if (!UDECODER_ILLEGAL_CHARACTERS) {
                        if (!UDecoder.isHexDigit(b1) || !UDecoder.isHexDigit(b2)) {
                            throw EXCEPTION_NOT_HEX_DIGIT;
                        }
                        j2 += 2;
                        res = UDecoder.x2c(b1, b2);
                        if (noSlash && res == 47) {
                            throw EXCEPTION_SLASH;
                        }
                        buff[idx] = (byte)res;
                    } else {
                        if (!UDecoder.isHexDigit(b1) || !UDecoder.isHexDigit(b2)) {
                            buff[idx] = 37;
                            buff[idx + 1] = buff[j2 + 1];
                            buff[idx + 2] = buff[j2 + 2] == 43 && query ? 32 : buff[j2 + 2];
                            idx += 2;
                        } else {
                            res = UDecoder.x2c(b1, b2);
                            if (noSlash && res == 47) {
                                throw EXCEPTION_SLASH;
                            }
                            buff[idx] = (byte)res;
                        }
                        j2 += 2;
                    }
                }
            }
            ++j2;
            ++idx;
        }
        mb.setEnd(idx);
    }

    public void convert(CharChunk mb, boolean query) throws IOException {
        int start = mb.getOffset();
        char[] buff = mb.getBuffer();
        int cend = mb.getEnd();
        int idx = CharChunk.indexOf(buff, start, cend, '%');
        int idx2 = -1;
        if (query) {
            idx2 = CharChunk.indexOf(buff, start, idx >= 0 ? idx : cend, '+');
        }
        if (idx < 0 && idx2 < 0) {
            return;
        }
        if (idx2 >= 0 && idx2 < idx || idx < 0) {
            idx = idx2;
        }
        boolean noSlash = !ALLOW_ENCODED_SLASH && !query;
        int j2 = idx;
        while (j2 < cend) {
            if (buff[j2] == '+' && query) {
                buff[idx] = 32;
            } else if (buff[j2] != '%') {
                buff[idx] = buff[j2];
            } else {
                if (j2 + 2 >= cend) {
                    throw EXCEPTION_EOF;
                }
                char b1 = buff[j2 + 1];
                char b2 = buff[j2 + 2];
                if (!UDecoder.isHexDigit(b1) || !UDecoder.isHexDigit(b2)) {
                    throw EXCEPTION_NOT_HEX_DIGIT;
                }
                j2 += 2;
                int res = UDecoder.x2c(b1, b2);
                if (noSlash && res == 47) {
                    throw EXCEPTION_SLASH;
                }
                buff[idx] = (char)res;
            }
            ++j2;
            ++idx;
        }
        mb.setEnd(idx);
    }

    public void convert(MessageBytes mb, boolean query) throws IOException {
        switch (mb.getType()) {
            case 1: {
                String strValue = mb.toString();
                if (strValue == null) {
                    return;
                }
                try {
                    mb.setString(this.convert(strValue, query));
                    break;
                }
                catch (RuntimeException ex) {
                    throw new DecodeException(ex.getMessage());
                }
            }
            case 3: {
                CharChunk charC = mb.getCharChunk();
                this.convert(charC, query);
                break;
            }
            case 2: {
                ByteChunk bytesC = mb.getByteChunk();
                this.convert(bytesC, query);
            }
        }
    }

    public final String convert(String str, boolean query) {
        if (str == null) {
            return null;
        }
        if (!(query && str.indexOf(43) >= 0 || str.indexOf(37) >= 0)) {
            return str;
        }
        boolean noSlash = !ALLOW_ENCODED_SLASH && !query;
        StringBuilder dec = new StringBuilder();
        int strPos = 0;
        int strLen = str.length();
        dec.ensureCapacity(str.length());
        while (strPos < strLen) {
            char laChar;
            int laPos;
            for (laPos = strPos; !(laPos >= strLen || (laChar = str.charAt(laPos)) == '+' && query || laChar == '%'); ++laPos) {
            }
            if (laPos > strPos) {
                dec.append(str.substring(strPos, laPos));
                strPos = laPos;
            }
            if (strPos >= strLen) break;
            char metaChar = str.charAt(strPos);
            if (metaChar == '+') {
                dec.append(' ');
                ++strPos;
                continue;
            }
            if (metaChar != '%') continue;
            char res = (char)Integer.parseInt(str.substring(strPos + 1, strPos + 3), 16);
            if (noSlash && res == '/') {
                throw new IllegalArgumentException(sm.getString("uDecoder.noSlash"));
            }
            dec.append(res);
            strPos += 3;
        }
        return dec.toString();
    }

    public static String URLDecode(String str) {
        return UDecoder.URLDecode(str, StandardCharsets.ISO_8859_1);
    }

    @Deprecated
    public static String URLDecode(String str, String enc) {
        return UDecoder.URLDecode(str, enc, false);
    }

    public static String URLDecode(String str, Charset charset) {
        return UDecoder.URLDecode(str, charset, false);
    }

    @Deprecated
    public static String URLDecode(String str, String enc, boolean isQuery) {
        Charset charset;
        block3: {
            charset = null;
            if (enc != null) {
                try {
                    charset = B2CConverter.getCharset(enc);
                }
                catch (UnsupportedEncodingException uee) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug(sm.getString("uDecoder.urlDecode.uee", enc), uee);
                }
            }
        }
        return UDecoder.URLDecode(str, charset, isQuery);
    }

    @Deprecated
    public static String URLDecode(byte[] bytes, String enc, boolean isQuery) {
        throw new IllegalArgumentException(sm.getString("udecoder.urlDecode.iae"));
    }

    private static String URLDecode(String str, Charset charset, boolean isQuery) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(37) == -1) {
            return str;
        }
        if (charset == null) {
            charset = StandardCharsets.ISO_8859_1;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(str.length() * 2);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, charset);
        char[] sourceChars = str.toCharArray();
        int len = sourceChars.length;
        int ix = 0;
        try {
            while (ix < len) {
                char c2;
                if ((c2 = sourceChars[ix++]) == '%') {
                    osw.flush();
                    if (ix + 2 > len) {
                        throw new IllegalArgumentException(sm.getString("uDecoder.urlDecode.missingDigit", str));
                    }
                    char c1 = sourceChars[ix++];
                    char c22 = sourceChars[ix++];
                    if (UDecoder.isHexDigit(c1) && UDecoder.isHexDigit(c22)) {
                        baos.write(UDecoder.x2c(c1, c22));
                        continue;
                    }
                    throw new IllegalArgumentException(sm.getString("uDecoder.urlDecode.missingDigit", str));
                }
                if (c2 == '+' && isQuery) {
                    osw.append(' ');
                    continue;
                }
                osw.append(c2);
            }
            osw.flush();
            return baos.toString(charset.name());
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(sm.getString("uDecoder.urlDecode.conversionError", str, charset.name()), ioe);
        }
    }

    private static boolean isHexDigit(int c2) {
        return c2 >= 48 && c2 <= 57 || c2 >= 97 && c2 <= 102 || c2 >= 65 && c2 <= 70;
    }

    private static int x2c(byte b1, byte b2) {
        int digit = b1 >= 65 ? (b1 & 0xDF) - 65 + 10 : b1 - 48;
        digit *= 16;
        return digit += b2 >= 65 ? (b2 & 0xDF) - 65 + 10 : b2 - 48;
    }

    private static int x2c(char b1, char b2) {
        int digit = b1 >= 'A' ? (b1 & 0xDF) - 65 + 10 : b1 - 48;
        digit *= 16;
        return digit += b2 >= 'A' ? (b2 & 0xDF) - 65 + 10 : b2 - 48;
    }

    private static class DecodeException
    extends CharConversionException {
        private static final long serialVersionUID = 1L;

        public DecodeException(String s2) {
            super(s2);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

