/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.collections;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public final class ConcurrentCache<K, V> {
    private final int size;
    private final Map<K, V> eden;
    private final Map<K, V> longterm;

    public ConcurrentCache(int size) {
        this.size = size;
        this.eden = new ConcurrentHashMap(size);
        this.longterm = new WeakHashMap(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K k2) {
        V v2 = this.eden.get(k2);
        if (v2 == null) {
            Map<K, V> map = this.longterm;
            synchronized (map) {
                v2 = this.longterm.get(k2);
            }
            if (v2 != null) {
                this.eden.put(k2, v2);
            }
        }
        return v2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K k2, V v2) {
        if (this.eden.size() >= this.size) {
            Map<K, V> map = this.longterm;
            synchronized (map) {
                this.longterm.putAll(this.eden);
            }
            this.eden.clear();
        }
        this.eden.put(k2, v2);
    }
}

