/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.http;

import com.bes.enterprise.web.util.res.StringManager;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HttpMessages {
    private static final Map<Locale, HttpMessages> instances = new ConcurrentHashMap<Locale, HttpMessages>();
    private static final HttpMessages DEFAULT = new HttpMessages(StringManager.getManager("com.bes.enterprise.web.util.http.res", Locale.getDefault()));
    private final StringManager sm;
    private String st_200 = null;
    private String st_302 = null;
    private String st_400 = null;
    private String st_404 = null;
    private String st_500 = null;

    private HttpMessages(StringManager sm) {
        this.sm = sm;
    }

    public String getMessage(int status) {
        switch (status) {
            case 200: {
                if (this.st_200 == null) {
                    this.st_200 = this.sm.getString("sc.200");
                }
                return this.st_200;
            }
            case 302: {
                if (this.st_302 == null) {
                    this.st_302 = this.sm.getString("sc.302");
                }
                return this.st_302;
            }
            case 400: {
                if (this.st_400 == null) {
                    this.st_400 = this.sm.getString("sc.400");
                }
                return this.st_400;
            }
            case 404: {
                if (this.st_404 == null) {
                    this.st_404 = this.sm.getString("sc.404");
                }
                return this.st_404;
            }
            case 500: {
                if (this.st_500 == null) {
                    this.st_500 = this.sm.getString("sc.500");
                }
                return this.st_500;
            }
        }
        return this.sm.getString("sc." + status);
    }

    public static HttpMessages getInstance(Locale locale) {
        HttpMessages result = instances.get(locale);
        if (result == null) {
            StringManager sm = StringManager.getManager("com.bes.enterprise.web.util.http.res", locale);
            result = Locale.getDefault().equals(sm.getLocale()) ? DEFAULT : new HttpMessages(sm);
            instances.put(locale, result);
        }
        return result;
    }

    public static boolean isSafeInHttpHeader(String msg) {
        if (msg == null) {
            return true;
        }
        int len = msg.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = msg.charAt(i2);
            if (' ' <= c2 && c2 <= '~' || '\u0080' <= c2 && c2 <= '\u00ff' || c2 == '\t') continue;
            return false;
        }
        return true;
    }
}

