/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.http;

import com.bes.enterprise.web.util.http.ServerCookie;
import com.bes.enterprise.web.util.res.StringManager;

public class ServerCookies {
    private static final StringManager sm = StringManager.getManager(ServerCookies.class);
    private ServerCookie[] serverCookies;
    private int cookieCount = 0;
    private int limit = 200;

    public ServerCookies(int initialSize) {
        this.serverCookies = new ServerCookie[initialSize];
    }

    public ServerCookie addCookie() {
        ServerCookie c2;
        if (this.limit > -1 && this.cookieCount >= this.limit) {
            throw new IllegalArgumentException(sm.getString("cookies.maxCountFail", this.limit));
        }
        if (this.cookieCount >= this.serverCookies.length) {
            int newSize = this.limit > -1 ? Math.min(2 * this.cookieCount, this.limit) : 2 * this.cookieCount;
            ServerCookie[] scookiesTmp = new ServerCookie[newSize];
            System.arraycopy(this.serverCookies, 0, scookiesTmp, 0, this.cookieCount);
            this.serverCookies = scookiesTmp;
        }
        if ((c2 = this.serverCookies[this.cookieCount]) == null) {
            this.serverCookies[this.cookieCount] = c2 = new ServerCookie();
        }
        ++this.cookieCount;
        return c2;
    }

    public ServerCookie getCookie(int idx) {
        return this.serverCookies[idx];
    }

    public int getCookieCount() {
        return this.cookieCount;
    }

    public void setLimit(int limit) {
        this.limit = limit;
        if (limit > -1 && this.serverCookies.length > limit && this.cookieCount <= limit) {
            ServerCookie[] scookiesTmp = new ServerCookie[limit];
            System.arraycopy(this.serverCookies, 0, scookiesTmp, 0, this.cookieCount);
            this.serverCookies = scookiesTmp;
        }
    }

    public void recycle() {
        for (int i2 = 0; i2 < this.cookieCount; ++i2) {
            this.serverCookies[i2].recycle();
        }
        this.cookieCount = 0;
    }
}

