/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.http.fileupload.impl;

import com.bes.enterprise.web.util.http.fileupload.FileItemHeaders;
import com.bes.enterprise.web.util.http.fileupload.FileItemStream;
import com.bes.enterprise.web.util.http.fileupload.FileUploadException;
import com.bes.enterprise.web.util.http.fileupload.MultipartStream;
import com.bes.enterprise.web.util.http.fileupload.impl.FileItemIteratorImpl;
import com.bes.enterprise.web.util.http.fileupload.impl.FileSizeLimitExceededException;
import com.bes.enterprise.web.util.http.fileupload.impl.FileUploadIOException;
import com.bes.enterprise.web.util.http.fileupload.util.Closeable;
import com.bes.enterprise.web.util.http.fileupload.util.LimitedInputStream;
import com.bes.enterprise.web.util.http.fileupload.util.Streams;
import java.io.IOException;
import java.io.InputStream;

public class FileItemStreamImpl
implements FileItemStream {
    private final FileItemIteratorImpl fileItemIteratorImpl;
    private final String contentType;
    private final String fieldName;
    final String name;
    private final boolean formField;
    private final InputStream stream;
    private FileItemHeaders headers;

    public FileItemStreamImpl(FileItemIteratorImpl pFileItemIterator, String pName, String pFieldName, String pContentType, boolean pFormField, long pContentLength) throws FileUploadException, IOException {
        MultipartStream.ItemInputStream itemStream;
        this.fileItemIteratorImpl = pFileItemIterator;
        this.name = pName;
        this.fieldName = pFieldName;
        this.contentType = pContentType;
        this.formField = pFormField;
        long fileSizeMax = this.fileItemIteratorImpl.getFileSizeMax();
        if (fileSizeMax != -1L && pContentLength != -1L && pContentLength > fileSizeMax) {
            FileSizeLimitExceededException e2 = new FileSizeLimitExceededException(String.format("The field %s exceeds its maximum permitted size of %s bytes.", this.fieldName, fileSizeMax), pContentLength, fileSizeMax);
            e2.setFileName(pName);
            e2.setFieldName(pFieldName);
            throw new FileUploadIOException(e2);
        }
        InputStream istream = itemStream = this.fileItemIteratorImpl.getMultiPartStream().newInputStream();
        if (fileSizeMax != -1L) {
            istream = new LimitedInputStream(istream, fileSizeMax){

                @Override
                protected void raiseError(long pSizeMax, long pCount) throws IOException {
                    itemStream.close(true);
                    FileSizeLimitExceededException e2 = new FileSizeLimitExceededException(String.format("The field %s exceeds its maximum permitted size of %s bytes.", FileItemStreamImpl.this.fieldName, pSizeMax), pCount, pSizeMax);
                    e2.setFieldName(FileItemStreamImpl.this.fieldName);
                    e2.setFileName(FileItemStreamImpl.this.name);
                    throw new FileUploadIOException(e2);
                }
            };
        }
        this.stream = istream;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getName() {
        return Streams.checkFileName(this.name);
    }

    @Override
    public boolean isFormField() {
        return this.formField;
    }

    @Override
    public InputStream openStream() throws IOException {
        if (((Closeable)((Object)this.stream)).isClosed()) {
            throw new FileItemStream.ItemSkippedException();
        }
        return this.stream;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public FileItemHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(FileItemHeaders pHeaders) {
        this.headers = pHeaders;
    }
}

