/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.http.parser;

import com.bes.enterprise.web.util.collections.ConcurrentCache;
import com.bes.enterprise.web.util.http.parser.MediaType;
import java.io.IOException;
import java.io.StringReader;

public class MediaTypeCache {
    private final ConcurrentCache<String, String[]> cache;

    public MediaTypeCache(int size) {
        this.cache = new ConcurrentCache(size);
    }

    public String[] parse(String input) {
        String[] result = this.cache.get(input);
        if (result != null) {
            return result;
        }
        MediaType m2 = null;
        try {
            m2 = MediaType.parseMediaType(new StringReader(input));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (m2 != null) {
            result = new String[]{m2.toStringNoCharset(), m2.getCharset()};
            this.cache.put(input, result);
        }
        return result;
    }
}

