/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.http.parser;

import com.bes.enterprise.web.util.http.parser.HttpParser;
import com.bes.enterprise.web.util.http.parser.SkipResult;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;

public class TokenList {
    private TokenList() {
    }

    public static boolean parseTokenList(Enumeration<String> inputs, Collection<String> collection) throws IOException {
        boolean result = true;
        while (inputs.hasMoreElements()) {
            String nextHeaderValue = inputs.nextElement();
            if (nextHeaderValue == null || TokenList.parseTokenList(new StringReader(nextHeaderValue), collection)) continue;
            result = false;
        }
        return result;
    }

    public static boolean parseTokenList(Reader input, Collection<String> collection) throws IOException {
        boolean invalid = false;
        boolean valid = false;
        while (true) {
            String fieldName;
            if ((fieldName = HttpParser.readToken(input)) == null) {
                invalid = true;
                HttpParser.skipUntil(input, 0, ',');
                continue;
            }
            if (fieldName.length() == 0) break;
            SkipResult skipResult = HttpParser.skipConstant(input, ",");
            if (skipResult == SkipResult.EOF) {
                valid = true;
                collection.add(fieldName.toLowerCase(Locale.ENGLISH));
                break;
            }
            if (skipResult == SkipResult.FOUND) {
                valid = true;
                collection.add(fieldName.toLowerCase(Locale.ENGLISH));
                continue;
            }
            invalid = true;
            HttpParser.skipUntil(input, 0, ',');
        }
        return valid && !invalid;
    }
}

