/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.modeler.modules;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.modeler.AttributeInfo;
import com.bes.enterprise.web.util.modeler.ManagedBean;
import com.bes.enterprise.web.util.modeler.OperationInfo;
import com.bes.enterprise.web.util.modeler.ParameterInfo;
import com.bes.enterprise.web.util.modeler.Registry;
import com.bes.enterprise.web.util.modeler.modules.ModelerSource;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;

public class MbeansDescriptorsIntrospectionSource
extends ModelerSource {
    private static final Log log = LogFactory.getLog(MbeansDescriptorsIntrospectionSource.class);
    private Registry registry;
    private String type;
    private final List<ObjectName> mbeans = new ArrayList<ObjectName>();
    private static final Hashtable<String, String> specialMethods = new Hashtable();
    private static final Class<?>[] supportedTypes;

    public void setRegistry(Registry reg) {
        this.registry = reg;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    @Override
    public List<ObjectName> loadDescriptors(Registry registry, String type, Object source) throws Exception {
        this.setRegistry(registry);
        this.setType(type);
        this.setSource(source);
        this.execute();
        return this.mbeans;
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry(null, null);
        }
        try {
            ManagedBean managed = this.createManagedBean(this.registry, null, (Class)this.source, this.type);
            if (managed == null) {
                return;
            }
            managed.setName(this.type);
            this.registry.addManagedBean(managed);
        }
        catch (Exception ex) {
            log.error(sm.getString("modules.readDescriptorsError"), ex);
        }
    }

    private boolean supportedType(Class<?> ret) {
        for (int i2 = 0; i2 < supportedTypes.length; ++i2) {
            if (ret != supportedTypes[i2]) continue;
            return true;
        }
        return this.isBeanCompatible(ret);
    }

    private boolean isBeanCompatible(Class<?> javaType) {
        if (javaType.isArray() || javaType.isPrimitive()) {
            return false;
        }
        if (javaType.getName().startsWith("java.") || javaType.getName().startsWith("javax.")) {
            return false;
        }
        try {
            javaType.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e2) {
            return false;
        }
        Class<?> superClass = javaType.getSuperclass();
        return superClass == null || superClass == Object.class || superClass == Exception.class || superClass == Throwable.class || this.isBeanCompatible(superClass);
    }

    private void initMethods(Class<?> realClass, Method[] methods, Hashtable<String, Method> attMap, Hashtable<String, Method> getAttMap, Hashtable<String, Method> setAttMap, Hashtable<String, Method> invokeAttMap) {
        for (int j2 = 0; j2 < methods.length; ++j2) {
            String name = methods[j2].getName();
            if (Modifier.isStatic(methods[j2].getModifiers())) continue;
            if (!Modifier.isPublic(methods[j2].getModifiers())) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Not public " + methods[j2]);
                continue;
            }
            if (methods[j2].getDeclaringClass() == Object.class) continue;
            Class<?>[] params = methods[j2].getParameterTypes();
            if (name.startsWith("get") && params.length == 0) {
                Class<?> ret = methods[j2].getReturnType();
                if (!this.supportedType(ret)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Unsupported type " + methods[j2]);
                    continue;
                }
                name = MbeansDescriptorsIntrospectionSource.unCapitalize(name.substring(3));
                getAttMap.put(name, methods[j2]);
                attMap.put(name, methods[j2]);
                continue;
            }
            if (name.startsWith("is") && params.length == 0) {
                Class<?> ret = methods[j2].getReturnType();
                if (Boolean.TYPE != ret) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Unsupported type " + methods[j2] + " " + ret);
                    continue;
                }
                name = MbeansDescriptorsIntrospectionSource.unCapitalize(name.substring(2));
                getAttMap.put(name, methods[j2]);
                attMap.put(name, methods[j2]);
                continue;
            }
            if (name.startsWith("set") && params.length == 1) {
                if (!this.supportedType(params[0])) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Unsupported type " + methods[j2] + " " + params[0]);
                    continue;
                }
                name = MbeansDescriptorsIntrospectionSource.unCapitalize(name.substring(3));
                setAttMap.put(name, methods[j2]);
                attMap.put(name, methods[j2]);
                continue;
            }
            if (params.length == 0) {
                if (specialMethods.get(methods[j2].getName()) != null) continue;
                invokeAttMap.put(name, methods[j2]);
                continue;
            }
            boolean supported = true;
            for (int i2 = 0; i2 < params.length; ++i2) {
                if (this.supportedType(params[i2])) continue;
                supported = false;
                break;
            }
            if (!supported) continue;
            invokeAttMap.put(name, methods[j2]);
        }
    }

    public ManagedBean createManagedBean(Registry registry, String domain, Class<?> realClass, String type) {
        ManagedBean mbean = new ManagedBean();
        Method[] methods = null;
        Hashtable<String, Method> attMap = new Hashtable<String, Method>();
        Hashtable<String, Method> getAttMap = new Hashtable<String, Method>();
        Hashtable<String, Method> setAttMap = new Hashtable<String, Method>();
        Hashtable<String, Method> invokeAttMap = new Hashtable<String, Method>();
        methods = realClass.getMethods();
        this.initMethods(realClass, methods, attMap, getAttMap, setAttMap, invokeAttMap);
        try {
            Enumeration<String> en = attMap.keys();
            while (en.hasMoreElements()) {
                Method sm;
                String name = en.nextElement();
                AttributeInfo ai = new AttributeInfo();
                ai.setName(name);
                Method gm = getAttMap.get(name);
                if (gm != null) {
                    ai.setGetMethod(gm.getName());
                    Class<?> t2 = gm.getReturnType();
                    if (t2 != null) {
                        ai.setType(t2.getName());
                    }
                }
                if ((sm = setAttMap.get(name)) != null) {
                    Class<?> t3 = sm.getParameterTypes()[0];
                    if (t3 != null) {
                        ai.setType(t3.getName());
                    }
                    ai.setSetMethod(sm.getName());
                }
                ai.setDescription("Introspected attribute " + name);
                if (log.isDebugEnabled()) {
                    log.debug("Introspected attribute " + name + " " + gm + " " + sm);
                }
                if (gm == null) {
                    ai.setReadable(false);
                }
                if (sm == null) {
                    ai.setWriteable(false);
                }
                if (sm == null && gm == null) continue;
                mbean.addAttribute(ai);
            }
            for (Map.Entry<String, Method> entry : invokeAttMap.entrySet()) {
                String name = entry.getKey();
                Method m2 = entry.getValue();
                OperationInfo op = new OperationInfo();
                op.setName(name);
                op.setReturnType(m2.getReturnType().getName());
                op.setDescription("Introspected operation " + name);
                Class<?>[] parms = m2.getParameterTypes();
                for (int i2 = 0; i2 < parms.length; ++i2) {
                    ParameterInfo pi = new ParameterInfo();
                    pi.setType(parms[i2].getName());
                    pi.setName(("param" + i2).intern());
                    pi.setDescription(("Introspected parameter param" + i2).intern());
                    op.addParameter(pi);
                }
                mbean.addOperation(op);
            }
            if (log.isDebugEnabled()) {
                log.debug("Setting name: " + type);
            }
            mbean.setName(type);
            return mbean;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static String unCapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    static {
        specialMethods.put("preDeregister", "");
        specialMethods.put("postDeregister", "");
        supportedTypes = new Class[]{Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, Character.class, Character.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, String.class, String[].class, BigDecimal.class, BigInteger.class, ObjectName.class, Object[].class, File.class};
    }
}

