/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.net;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.jni.Address;
import com.bes.enterprise.web.jni.Error;
import com.bes.enterprise.web.jni.File;
import com.bes.enterprise.web.jni.Library;
import com.bes.enterprise.web.jni.OS;
import com.bes.enterprise.web.jni.Poll;
import com.bes.enterprise.web.jni.Pool;
import com.bes.enterprise.web.jni.SSL;
import com.bes.enterprise.web.jni.SSLContext;
import com.bes.enterprise.web.jni.SSLSocket;
import com.bes.enterprise.web.jni.Sockaddr;
import com.bes.enterprise.web.jni.Socket;
import com.bes.enterprise.web.jni.Status;
import com.bes.enterprise.web.util.ExceptionUtils;
import com.bes.enterprise.web.util.buf.ByteBufferUtils;
import com.bes.enterprise.web.util.collections.SynchronizedStack;
import com.bes.enterprise.web.util.net.AbstractEndpoint;
import com.bes.enterprise.web.util.net.ApplicationBufferHandler;
import com.bes.enterprise.web.util.net.NativeSSLSupport;
import com.bes.enterprise.web.util.net.SSLHostConfig;
import com.bes.enterprise.web.util.net.SSLHostConfigCertificate;
import com.bes.enterprise.web.util.net.SSLSupport;
import com.bes.enterprise.web.util.net.SendfileDataBase;
import com.bes.enterprise.web.util.net.SendfileState;
import com.bes.enterprise.web.util.net.SocketBufferHandler;
import com.bes.enterprise.web.util.net.SocketEvent;
import com.bes.enterprise.web.util.net.SocketProcessorBase;
import com.bes.enterprise.web.util.net.SocketWrapperBase;
import com.bes.enterprise.web.util.net.openssl.OpenSSLContext;
import com.bes.enterprise.web.util.net.openssl.OpenSSLUtil;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.KeyManager;

public class NativeEndpoint
extends AbstractEndpoint<Long>
implements SSLContext.SNICallBack {
    private static final Log log = LogFactory.getLog(NativeEndpoint.class);
    protected long rootPool = 0L;
    protected volatile long serverSock = 0L;
    protected long serverSockPool = 0L;
    protected long sslContext = 0L;
    private final Map<Long, NativeSocketWrapper> connections = new ConcurrentHashMap<Long, NativeSocketWrapper>();
    protected boolean deferAccept = true;
    private boolean ipv6v6only = false;
    protected int sendfileSize = 1024;
    protected int pollTime = 2000;
    private boolean useSendFileSet = false;
    protected Poller poller = null;
    protected Sendfile sendfile = null;

    public NativeEndpoint() {
        this.setUseAsyncIO(false);
        this.setMaxConnections(8192);
    }

    public void setDeferAccept(boolean deferAccept) {
        this.deferAccept = deferAccept;
    }

    @Override
    public boolean getDeferAccept() {
        return this.deferAccept;
    }

    public void setIpv6v6only(boolean ipv6v6only) {
        this.ipv6v6only = ipv6v6only;
    }

    public boolean getIpv6v6only() {
        return this.ipv6v6only;
    }

    public void setSendfileSize(int sendfileSize) {
        this.sendfileSize = sendfileSize;
    }

    public int getSendfileSize() {
        return this.sendfileSize;
    }

    public int getPollTime() {
        return this.pollTime;
    }

    public void setPollTime(int pollTime) {
        if (pollTime > 0) {
            this.pollTime = pollTime;
        }
    }

    @Override
    public void setUseSendfile(boolean useSendfile) {
        this.useSendFileSet = true;
        super.setUseSendfile(useSendfile);
    }

    private void setUseSendfileInternal(boolean useSendfile) {
        super.setUseSendfile(useSendfile);
    }

    public Poller getPoller() {
        return this.poller;
    }

    public Sendfile getSendfile() {
        return this.sendfile;
    }

    @Override
    public InetSocketAddress getLocalAddress() throws IOException {
        long sa;
        long s2 = this.serverSock;
        if (s2 == 0L) {
            return null;
        }
        try {
            sa = Address.get(0, s2);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e2) {
            throw new IOException(e2);
        }
        Sockaddr addr = Address.getInfo(sa);
        if (addr.hostname == null) {
            if (addr.family == 2) {
                return new InetSocketAddress("::", addr.port);
            }
            return new InetSocketAddress("0.0.0.0", addr.port);
        }
        return new InetSocketAddress(addr.hostname, addr.port);
    }

    @Override
    public void setMaxConnections(int maxConnections) {
        if (maxConnections == -1) {
            log.warn(sm.getString("endpoint.apr.maxConnections.unlimited", this.getMaxConnections()));
            return;
        }
        if (this.running) {
            log.warn(sm.getString("endpoint.apr.maxConnections.running", this.getMaxConnections()));
            return;
        }
        super.setMaxConnections(maxConnections);
    }

    public int getKeepAliveCount() {
        if (this.poller == null) {
            return 0;
        }
        return this.poller.getConnectionCount();
    }

    public int getSendfileCount() {
        if (this.sendfile == null) {
            return 0;
        }
        return this.sendfile.getSendfileCount();
    }

    @Override
    public void bind() throws Exception {
        try {
            this.rootPool = Pool.create(0L);
        }
        catch (UnsatisfiedLinkError e2) {
            throw new Exception(sm.getString("endpoint.init.notavail"));
        }
        this.serverSockPool = Pool.create(this.rootPool);
        String addressStr = null;
        if (this.getAddress() != null) {
            addressStr = this.getAddress().getHostAddress();
        }
        int family = 1;
        if (Library.APR_HAVE_IPV6) {
            if (addressStr == null) {
                if (!OS.IS_BSD) {
                    family = 0;
                }
            } else if (addressStr.indexOf(58) >= 0) {
                family = 0;
            }
        }
        long inetAddress = Address.info(addressStr, family, this.getPort(), 0, this.rootPool);
        this.serverSock = Socket.create(Address.getInfo((long)inetAddress).family, 0, 6, this.rootPool);
        if (OS.IS_UNIX) {
            Socket.optSet(this.serverSock, 16, 1);
        }
        if (Library.APR_HAVE_IPV6) {
            if (this.getIpv6v6only()) {
                Socket.optSet(this.serverSock, 16384, 1);
            } else {
                Socket.optSet(this.serverSock, 16384, 0);
            }
        }
        Socket.optSet(this.serverSock, 2, 1);
        int ret = Socket.bind(this.serverSock, inetAddress);
        if (ret != 0) {
            throw new Exception(sm.getString("endpoint.init.bind", "" + ret, Error.strerror(ret)));
        }
        ret = Socket.listen(this.serverSock, this.getAcceptCount());
        if (ret != 0) {
            throw new Exception(sm.getString("endpoint.init.listen", "" + ret, Error.strerror(ret)));
        }
        if (OS.IS_WIN32 || OS.IS_WIN64) {
            Socket.optSet(this.serverSock, 16, 1);
        }
        if (!this.useSendFileSet) {
            this.setUseSendfileInternal(Library.APR_HAS_SENDFILE);
        } else if (this.getUseSendfile() && !Library.APR_HAS_SENDFILE) {
            this.setUseSendfileInternal(false);
        }
        if (this.acceptorThreadCount == 0) {
            this.acceptorThreadCount = 1;
        }
        if (this.deferAccept && Socket.optSet(this.serverSock, 32768, 1) == 70023) {
            this.deferAccept = false;
        }
        if (this.isSSLEnabled()) {
            for (SSLHostConfig sslHostConfig : this.sslHostConfigs.values()) {
                this.createSSLContext(sslHostConfig);
            }
            SSLHostConfig defaultSSLHostConfig = (SSLHostConfig)this.sslHostConfigs.get(this.getDefaultSSLHostConfigName());
            if (defaultSSLHostConfig == null) {
                throw new IllegalArgumentException(sm.getString("endpoint.noSslHostConfig", this.getDefaultSSLHostConfigName(), this.getName()));
            }
            Long defaultSSLContext = defaultSSLHostConfig.getOpenSslContext();
            this.sslContext = defaultSSLContext;
            SSLContext.registerDefault(defaultSSLContext, this);
            if (this.getUseSendfile()) {
                this.setUseSendfileInternal(false);
                if (this.useSendFileSet) {
                    log.warn(sm.getString("endpoint.apr.noSendfileWithSSL"));
                }
            }
        }
    }

    @Override
    protected void createSSLContext(SSLHostConfig sslHostConfig) throws Exception {
        OpenSSLContext sslContext = null;
        Set<SSLHostConfigCertificate> certificates = sslHostConfig.getCertificates(true);
        for (SSLHostConfigCertificate certificate : certificates) {
            OpenSSLUtil sslUtil;
            if (sslContext == null) {
                sslUtil = new OpenSSLUtil(certificate);
                sslHostConfig.setEnabledProtocols(sslUtil.getEnabledProtocols());
                sslHostConfig.setEnabledCiphers(sslUtil.getEnabledCiphers());
                try {
                    sslContext = (OpenSSLContext)sslUtil.createSSLContext(this.negotiableProtocols);
                }
                catch (Exception e2) {
                    throw new IllegalArgumentException(e2.getMessage(), e2);
                }
            } else {
                sslUtil = new OpenSSLUtil(certificate);
                KeyManager[] kms = sslUtil.getKeyManagers();
                certificate.setCertificateKeyManager(OpenSSLUtil.chooseKeyManager(kms));
                sslContext.addCertificate(certificate);
            }
            certificate.setSslContext(sslContext);
        }
        if (certificates.size() > 2) {
            throw new Exception(sm.getString("endpoint.apr.tooManyCertFiles"));
        }
    }

    @Override
    public long getSslContext(String sniHostName) {
        SSLHostConfig sslHostConfig = this.getSSLHostConfig(sniHostName);
        Long ctx = sslHostConfig.getOpenSslContext();
        if (ctx != null) {
            return ctx;
        }
        return 0L;
    }

    @Override
    public boolean isAlpnSupported() {
        return this.isSSLEnabled();
    }

    @Override
    public void startInternal() throws Exception {
        if (!this.running) {
            this.running = true;
            this.paused = false;
            this.processorCache = new SynchronizedStack(128, this.socketProperties.getProcessorCache());
            if (this.getExecutor() == null) {
                this.createExecutor();
            }
            this.initializeConnectionLatch();
            this.poller = new Poller();
            this.poller.init();
            Thread pollerThread = new Thread((Runnable)this.poller, this.getName() + "-Poller");
            pollerThread.setPriority(this.threadPriority);
            pollerThread.setDaemon(true);
            pollerThread.start();
            if (this.getUseSendfile()) {
                this.sendfile = new Sendfile();
                this.sendfile.init();
                Thread sendfileThread = new Thread((Runnable)this.sendfile, this.getName() + "-Sendfile");
                sendfileThread.setPriority(this.threadPriority);
                sendfileThread.setDaemon(true);
                sendfileThread.start();
            }
            this.startAcceptorThreads();
        }
    }

    @Override
    public void stopInternal() {
        this.releaseConnectionLatch();
        if (!this.paused) {
            this.pause();
        }
        if (this.running) {
            this.running = false;
            this.poller.stop();
            for (SocketWrapperBase socketWrapperBase : this.connections.values()) {
                try {
                    socketWrapperBase.close();
                }
                catch (IOException iOException) {}
            }
            for (AbstractEndpoint.Acceptor acceptor : this.acceptors) {
                long waitLeft;
                for (waitLeft = 10000L; waitLeft > 0L && acceptor.getState() != AbstractEndpoint.Acceptor.AcceptorState.ENDED && this.serverSock != 0L; waitLeft -= 50L) {
                    try {
                        Thread.sleep(50L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (waitLeft != 0L) continue;
                log.warn(sm.getString("endpoint.warn.unlockAcceptorFailed", acceptor.getThreadName()));
                if (this.serverSock == 0L) continue;
                Socket.shutdown(this.serverSock, 0);
                this.serverSock = 0L;
            }
            for (Long l2 : this.connections.keySet()) {
                Socket.shutdown(l2, 2);
            }
            try {
                this.poller.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.poller = null;
            this.connections.clear();
            if (this.getUseSendfile()) {
                try {
                    this.sendfile.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sendfile = null;
            }
            this.processorCache.clear();
        }
        this.shutdownExecutor();
    }

    @Override
    public void unbind() throws Exception {
        if (this.running) {
            this.stop();
        }
        if (this.serverSockPool != 0L) {
            Pool.destroy(this.serverSockPool);
            this.serverSockPool = 0L;
        }
        this.doCloseServerSocket();
        this.destroySsl();
        if (this.rootPool != 0L) {
            Pool.destroy(this.rootPool);
            this.rootPool = 0L;
        }
        this.getHandler().recycle();
    }

    @Override
    protected void doCloseServerSocket() {
        if (this.serverSock != 0L) {
            Socket.close(this.serverSock);
            this.serverSock = 0L;
        }
    }

    @Override
    protected AbstractEndpoint.Acceptor createAcceptor() {
        return new Acceptor();
    }

    protected boolean setSocketOptions(SocketWrapperBase<Long> socketWrapper) {
        long socket = socketWrapper.getSocket();
        int step = 1;
        try {
            if (this.socketProperties.getSoLingerOn() && this.socketProperties.getSoLingerTime() >= 0) {
                Socket.optSet(socket, 1, this.socketProperties.getSoLingerTime());
            }
            if (this.socketProperties.getTcpNoDelay()) {
                Socket.optSet(socket, 512, this.socketProperties.getTcpNoDelay() ? 1 : 0);
            }
            Socket.timeoutSet(socket, this.socketProperties.getSoTimeout() * 1000);
            step = 2;
            if (this.sslContext != 0L) {
                int len;
                byte[] negotiated;
                String negotiatedProtocol;
                SSLSocket.attach(this.sslContext, socket);
                if (SSLSocket.handshake(socket) != 0) {
                    if (log.isDebugEnabled()) {
                        log.debug(sm.getString("endpoint.err.handshake") + ": " + SSL.getLastError());
                    }
                    return false;
                }
                if (this.negotiableProtocols.size() > 0 && (negotiatedProtocol = new String(negotiated = new byte[256], 0, len = SSLSocket.getALPN(socket, negotiated), StandardCharsets.UTF_8)).length() > 0) {
                    socketWrapper.setNegotiatedProtocol(negotiatedProtocol);
                    if (log.isDebugEnabled()) {
                        log.debug(sm.getString("endpoint.alpn.negotiated", negotiatedProtocol));
                    }
                }
            }
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
            if (log.isDebugEnabled()) {
                if (step == 2) {
                    log.debug(sm.getString("endpoint.err.handshake"), t2);
                } else {
                    log.debug(sm.getString("endpoint.err.unexpected"), t2);
                }
            }
            return false;
        }
        return true;
    }

    protected long allocatePoller(int size, long pool, int timeout) {
        try {
            return Poll.create(size, pool, 0, timeout * 1000);
        }
        catch (Error e2) {
            if (Status.APR_STATUS_IS_EINVAL(e2.getError())) {
                log.info(sm.getString("endpoint.poll.limitedpollsize", "" + size));
                return 0L;
            }
            log.error(sm.getString("endpoint.poll.initfail"), e2);
            return -1L;
        }
    }

    protected boolean processSocketWithOptions(long socket) {
        try {
            if (this.running) {
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("endpoint.debug.socket", socket));
                }
                NativeSocketWrapper wrapper = new NativeSocketWrapper(socket, this);
                wrapper.setKeepAliveLeft(this.getMaxKeepAliveRequests());
                wrapper.setSecure(this.isSSLEnabled());
                wrapper.setReadTimeout(this.getConnectionTimeout());
                wrapper.setWriteTimeout(this.getConnectionTimeout());
                this.connections.put(socket, wrapper);
                this.getExecutor().execute(new SocketWithOptionsProcessor(wrapper));
            }
        }
        catch (RejectedExecutionException x2) {
            log.warn("Socket processing request was rejected for:" + socket, x2);
            return false;
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
            log.error(sm.getString("endpoint.process.fail"), t2);
            return false;
        }
        return true;
    }

    protected boolean processSocket(long socket, SocketEvent event) {
        SocketWrapperBase socketWrapper = this.connections.get(socket);
        return this.processSocket(socketWrapper, event, true);
    }

    @Override
    protected SocketProcessorBase<Long> createSocketProcessor(SocketWrapperBase<Long> socketWrapper, SocketEvent event) {
        return new SocketProcessor(socketWrapper, event);
    }

    private void closeSocket(long socket) {
        SocketWrapperBase wrapper = this.connections.remove(socket);
        if (wrapper != null) {
            ((NativeSocketWrapper)wrapper).close();
        }
    }

    private void destroySocket(long socket) {
        this.connections.remove(socket);
        if (log.isDebugEnabled()) {
            String msg = sm.getString("endpoint.debug.destroySocket", socket);
            if (log.isTraceEnabled()) {
                log.trace(msg, new Exception());
            } else {
                log.debug(msg);
            }
        }
        if (socket != 0L) {
            Socket.destroy(socket);
            this.countDownConnection();
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    public boolean isParseHeadersBySelectorThread() {
        return false;
    }

    public static class NativeSocketWrapper
    extends SocketWrapperBase<Long> {
        private static final int SSL_OUTPUT_BUFFER_SIZE = 8192;
        private final ByteBuffer sslOutputBuffer;
        private final Object closedLock = new Object();
        private volatile boolean closed = false;
        private int pollerFlags = 0;
        private volatile boolean blockingStatus = true;
        private final Lock blockingStatusReadLock;
        private final ReentrantReadWriteLock.WriteLock blockingStatusWriteLock;

        public NativeSocketWrapper(Long socket, NativeEndpoint endpoint) {
            super(socket, endpoint);
            ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
            this.blockingStatusReadLock = lock.readLock();
            this.blockingStatusWriteLock = lock.writeLock();
            if (endpoint.isSSLEnabled()) {
                this.sslOutputBuffer = ByteBuffer.allocateDirect(8192);
                this.sslOutputBuffer.position(8192);
            } else {
                this.sslOutputBuffer = null;
            }
            this.socketBufferHandler = new SocketBufferHandler(9000, 9000, true);
        }

        public boolean getBlockingStatus() {
            return this.blockingStatus;
        }

        public void setBlockingStatus(boolean blockingStatus) {
            this.blockingStatus = blockingStatus;
        }

        public Lock getBlockingStatusReadLock() {
            return this.blockingStatusReadLock;
        }

        public ReentrantReadWriteLock.WriteLock getBlockingStatusWriteLock() {
            return this.blockingStatusWriteLock;
        }

        @Override
        public int read(boolean block, byte[] b2, int off, int len) throws IOException {
            int nRead = this.populateReadBuffer(b2, off, len);
            if (nRead > 0) {
                return nRead;
            }
            nRead = this.fillReadBuffer(block);
            if (nRead > 0) {
                this.socketBufferHandler.configureReadBufferForRead();
                nRead = Math.min(nRead, len);
                this.socketBufferHandler.getReadBuffer().get(b2, off, nRead);
            }
            return nRead;
        }

        @Override
        public int read(boolean block, ByteBuffer to) throws IOException {
            int nRead = this.populateReadBuffer(to);
            if (nRead > 0) {
                return nRead;
            }
            int limit = this.socketBufferHandler.getReadBuffer().capacity();
            if (to.isDirect() && to.remaining() >= limit) {
                to.limit(to.position() + limit);
                nRead = this.fillReadBuffer(block, to);
                if (log.isDebugEnabled()) {
                    log.debug("Socket: [" + this + "], Read direct from socket: [" + nRead + "]");
                }
            } else {
                nRead = this.fillReadBuffer(block);
                if (log.isDebugEnabled()) {
                    log.debug("Socket: [" + this + "], Read into buffer: [" + nRead + "]");
                }
                if (nRead > 0) {
                    nRead = this.populateReadBuffer(to);
                }
            }
            return nRead;
        }

        private int fillReadBuffer(boolean block) throws IOException {
            this.socketBufferHandler.configureReadBufferForWrite();
            return this.fillReadBuffer(block, this.socketBufferHandler.getReadBuffer());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int fillReadBuffer(boolean block, ByteBuffer to) throws IOException {
            if (this.closed) {
                throw new IOException(sm.getString("socket.apr.closed", this.getSocket()));
            }
            Lock readLock = this.getBlockingStatusReadLock();
            ReentrantReadWriteLock.WriteLock writeLock = this.getBlockingStatusWriteLock();
            boolean readDone = false;
            int result = 0;
            readLock.lock();
            try {
                if (this.getBlockingStatus() == block) {
                    if (block) {
                        Socket.timeoutSet((Long)this.getSocket(), this.getReadTimeout() * 1000L);
                    }
                    result = Socket.recvb((Long)this.getSocket(), to, to.position(), to.remaining());
                    readDone = true;
                }
            }
            finally {
                readLock.unlock();
            }
            if (!readDone) {
                writeLock.lock();
                try {
                    this.setBlockingStatus(block);
                    if (block) {
                        Socket.timeoutSet((Long)this.getSocket(), this.getReadTimeout() * 1000L);
                    } else {
                        Socket.timeoutSet((Long)this.getSocket(), 0L);
                    }
                    readLock.lock();
                    try {
                        writeLock.unlock();
                        result = Socket.recvb((Long)this.getSocket(), to, to.position(), to.remaining());
                    }
                    finally {
                        readLock.unlock();
                    }
                }
                finally {
                    if (writeLock.isHeldByCurrentThread()) {
                        writeLock.unlock();
                    }
                }
            }
            if (result > 0) {
                to.position(to.position() + result);
                return result;
            }
            if (result == 0 || -result == 120002) {
                return 0;
            }
            if (-result == 120005 || -result == 120001) {
                if (block) {
                    throw new SocketTimeoutException(sm.getString("iib.readtimeout"));
                }
                return 0;
            }
            if (-result == 70014) {
                return -1;
            }
            if ((OS.IS_WIN32 || OS.IS_WIN64) && -result == 730053) {
                throw new EOFException(sm.getString("socket.apr.clientAbort"));
            }
            throw new IOException(sm.getString("socket.apr.read.error", -result, this.getSocket(), this));
        }

        @Override
        public boolean isReadyForRead() throws IOException {
            this.socketBufferHandler.configureReadBufferForRead();
            if (this.socketBufferHandler.getReadBuffer().remaining() > 0) {
                return true;
            }
            int read = this.fillReadBuffer(false);
            boolean isReady = this.socketBufferHandler.getReadBuffer().position() > 0 || read == -1;
            return isReady;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            this.getEndpoint().getHandler().release(this);
            Object object = this.closedLock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                if (this.sslOutputBuffer != null) {
                    ByteBufferUtils.cleanDirectBuffer(this.sslOutputBuffer);
                }
                ((NativeEndpoint)this.getEndpoint()).getPoller().close((Long)this.getSocket());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isClosed() {
            Object object = this.closedLock;
            synchronized (object) {
                return this.closed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(boolean block, ByteBuffer from) throws IOException {
            if (this.closed) {
                throw new IOException(sm.getString("socket.apr.closed", this.getSocket()));
            }
            Lock readLock = this.getBlockingStatusReadLock();
            ReentrantReadWriteLock.WriteLock writeLock = this.getBlockingStatusWriteLock();
            readLock.lock();
            try {
                if (this.getBlockingStatus() == block) {
                    if (block) {
                        Socket.timeoutSet((Long)this.getSocket(), this.getWriteTimeout() * 1000L);
                    }
                    this.doWriteInternal(from);
                    return;
                }
            }
            finally {
                readLock.unlock();
            }
            writeLock.lock();
            try {
                this.setBlockingStatus(block);
                if (block) {
                    Socket.timeoutSet((Long)this.getSocket(), this.getWriteTimeout() * 1000L);
                } else {
                    Socket.timeoutSet((Long)this.getSocket(), 0L);
                }
                readLock.lock();
                try {
                    writeLock.unlock();
                    this.doWriteInternal(from);
                }
                finally {
                    readLock.unlock();
                }
            }
            finally {
                if (writeLock.isHeldByCurrentThread()) {
                    writeLock.unlock();
                }
            }
        }

        private void doWriteInternal(ByteBuffer from) throws IOException {
            int thisTime;
            do {
                thisTime = 0;
                if (this.getEndpoint().isSSLEnabled()) {
                    if (this.sslOutputBuffer.remaining() == 0) {
                        this.sslOutputBuffer.clear();
                        NativeSocketWrapper.transfer(from, this.sslOutputBuffer);
                        this.sslOutputBuffer.flip();
                    }
                    if ((thisTime = Socket.sendb((Long)this.getSocket(), this.sslOutputBuffer, this.sslOutputBuffer.position(), this.sslOutputBuffer.limit())) > 0) {
                        this.sslOutputBuffer.position(this.sslOutputBuffer.position() + thisTime);
                    }
                } else {
                    thisTime = Socket.sendb((Long)this.getSocket(), from, from.position(), from.remaining());
                    if (thisTime > 0) {
                        from.position(from.position() + thisTime);
                    }
                }
                if (Status.APR_STATUS_IS_EAGAIN(-thisTime)) {
                    thisTime = 0;
                    continue;
                }
                if (-thisTime == 70014) {
                    throw new EOFException(sm.getString("socket.apr.clientAbort"));
                }
                if ((OS.IS_WIN32 || OS.IS_WIN64) && -thisTime == 730053) {
                    throw new EOFException(sm.getString("socket.apr.clientAbort"));
                }
                if (thisTime >= 0) continue;
                throw new IOException(sm.getString("socket.apr.write.error", -thisTime, this.getSocket(), this));
            } while ((thisTime > 0 || this.getBlockingStatus()) && from.hasRemaining());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerReadInterest() {
            Object object = this.closedLock;
            synchronized (object) {
                Poller p2;
                if (this.closed) {
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("endpoint.debug.registerRead", this));
                }
                if ((p2 = ((NativeEndpoint)this.getEndpoint()).getPoller()) != null) {
                    p2.add((Long)this.getSocket(), this.getReadTimeout(), 1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerWriteInterest() {
            Object object = this.closedLock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("endpoint.debug.registerWrite", this));
                }
                ((NativeEndpoint)this.getEndpoint()).getPoller().add((Long)this.getSocket(), this.getWriteTimeout(), 4);
            }
        }

        @Override
        public SendfileDataBase createSendfileData(String filename, long pos, long length) {
            return new SendfileData(filename, pos, length);
        }

        @Override
        public SendfileState processSendfile(SendfileDataBase sendfileData) {
            ((SendfileData)sendfileData).socket = (Long)this.getSocket();
            return ((NativeEndpoint)this.getEndpoint()).getSendfile().add((SendfileData)sendfileData);
        }

        @Override
        protected void populateRemoteAddr() {
            if (this.closed) {
                return;
            }
            try {
                long socket = (Long)this.getSocket();
                long sa = Address.get(1, socket);
                this.remoteAddr = Address.getip(sa);
            }
            catch (Exception e2) {
                log.warn(sm.getString("endpoint.warn.noRemoteAddr", this.getSocket()), e2);
            }
        }

        @Override
        protected void populateRemoteHost() {
            if (this.closed) {
                return;
            }
            try {
                long socket = (Long)this.getSocket();
                long sa = Address.get(1, socket);
                this.remoteHost = Address.getnameinfo(sa, 0);
                if (this.remoteAddr == null) {
                    this.remoteAddr = Address.getip(sa);
                }
            }
            catch (Exception e2) {
                log.warn(sm.getString("endpoint.warn.noRemoteHost", this.getSocket()), e2);
            }
        }

        @Override
        protected void populateRemotePort() {
            if (this.closed) {
                return;
            }
            try {
                long socket = (Long)this.getSocket();
                long sa = Address.get(1, socket);
                Sockaddr addr = Address.getInfo(sa);
                this.remotePort = addr.port;
            }
            catch (Exception e2) {
                log.warn(sm.getString("endpoint.warn.noRemotePort", this.getSocket()), e2);
            }
        }

        @Override
        protected void populateLocalName() {
            if (this.closed) {
                return;
            }
            try {
                long socket = (Long)this.getSocket();
                long sa = Address.get(0, socket);
                this.localName = Address.getnameinfo(sa, 0);
            }
            catch (Exception e2) {
                log.warn(sm.getString("endpoint.warn.noLocalName"), e2);
            }
        }

        @Override
        protected void populateLocalAddr() {
            if (this.closed) {
                return;
            }
            try {
                long socket = (Long)this.getSocket();
                long sa = Address.get(0, socket);
                this.localAddr = Address.getip(sa);
            }
            catch (Exception e2) {
                log.warn(sm.getString("endpoint.warn.noLocalAddr"), e2);
            }
        }

        @Override
        protected void populateLocalPort() {
            if (this.closed) {
                return;
            }
            try {
                long socket = (Long)this.getSocket();
                long sa = Address.get(0, socket);
                Sockaddr addr = Address.getInfo(sa);
                this.localPort = addr.port;
            }
            catch (Exception e2) {
                log.warn(sm.getString("endpoint.warn.noLocalPort"), e2);
            }
        }

        @Override
        public SSLSupport getSslSupport(String clientCertProvider) {
            if (this.getEndpoint().isSSLEnabled()) {
                return new NativeSSLSupport(this, clientCertProvider);
            }
            return null;
        }

        @Override
        public void doClientAuth(SSLSupport sslSupport) throws IOException {
            long socket = (Long)this.getSocket();
            try {
                SSLSocket.setVerify(socket, 2, -1);
                SSLSocket.renegotiate(socket);
            }
            catch (Throwable t2) {
                ExceptionUtils.handleThrowable(t2);
                throw new IOException(sm.getString("socket.sslreneg"), t2);
            }
        }

        @Override
        public void setAppReadBufHandler(ApplicationBufferHandler handler) {
        }

        String getSSLInfoS(int id) {
            Object object = this.closedLock;
            synchronized (object) {
                if (this.closed) {
                    return null;
                }
                try {
                    return SSLSocket.getInfoS((Long)this.getSocket(), id);
                }
                catch (Exception e2) {
                    throw new IllegalStateException(e2);
                }
            }
        }

        int getSSLInfoI(int id) {
            Object object = this.closedLock;
            synchronized (object) {
                if (this.closed) {
                    return 0;
                }
                try {
                    return SSLSocket.getInfoI((Long)this.getSocket(), id);
                }
                catch (Exception e2) {
                    throw new IllegalStateException(e2);
                }
            }
        }

        byte[] getSSLInfoB(int id) {
            Object object = this.closedLock;
            synchronized (object) {
                if (this.closed) {
                    return null;
                }
                try {
                    return SSLSocket.getInfoB((Long)this.getSocket(), id);
                }
                catch (Exception e2) {
                    throw new IllegalStateException(e2);
                }
            }
        }

        @Override
        protected <A> SocketWrapperBase.OperationState<A> newOperationState(boolean read, ByteBuffer[] buffers, int offset, int length, SocketWrapperBase.BlockingMode block, long timeout, TimeUnit unit, A attachment, SocketWrapperBase.CompletionCheck check, CompletionHandler<Long, ? super A> handler, Semaphore semaphore, SocketWrapperBase.VectoredIOCompletionHandler<A> completion) {
            return new NativeOperationState(read, buffers, offset, length, block, timeout, unit, attachment, check, handler, semaphore, completion);
        }

        private class NativeOperationState<A>
        extends SocketWrapperBase.OperationState<A> {
            private volatile boolean inline;
            private volatile long flushBytes;

            private NativeOperationState(boolean read, ByteBuffer[] buffers, int offset, int length, SocketWrapperBase.BlockingMode block, long timeout, TimeUnit unit, A attachment, SocketWrapperBase.CompletionCheck check, CompletionHandler<Long, ? super A> handler, Semaphore semaphore, SocketWrapperBase.VectoredIOCompletionHandler<A> completion) {
                super(NativeSocketWrapper.this, read, buffers, offset, length, block, timeout, unit, attachment, check, handler, semaphore, completion);
                this.inline = true;
                this.flushBytes = 0L;
            }

            @Override
            protected boolean isInline() {
                return this.inline;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long nBytes = 0L;
                if (NativeSocketWrapper.this.getError() == null) {
                    try {
                        NativeOperationState nativeOperationState = this;
                        synchronized (nativeOperationState) {
                            if (!this.completionDone) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Skip concurrent " + (this.read ? "read" : "write") + " notification");
                                }
                                return;
                            }
                            ByteBuffer buffer = null;
                            for (int i2 = 0; i2 < this.length; ++i2) {
                                if (!this.buffers[i2 + this.offset].hasRemaining()) continue;
                                buffer = this.buffers[i2 + this.offset];
                                break;
                            }
                            if (buffer == null && this.flushBytes == 0L) {
                                return;
                            }
                            if (this.read) {
                                nBytes = NativeSocketWrapper.this.read(false, buffer);
                            } else if (!NativeSocketWrapper.this.flush(this.block == SocketWrapperBase.BlockingMode.BLOCK)) {
                                if (this.flushBytes > 0L) {
                                    nBytes = this.flushBytes;
                                    this.flushBytes = 0L;
                                } else {
                                    int remaining = buffer.remaining();
                                    NativeSocketWrapper.this.write(this.block == SocketWrapperBase.BlockingMode.BLOCK, buffer);
                                    nBytes = remaining - buffer.remaining();
                                    if (nBytes > 0L && NativeSocketWrapper.this.flush(this.block == SocketWrapperBase.BlockingMode.BLOCK)) {
                                        this.inline = false;
                                        NativeSocketWrapper.this.registerWriteInterest();
                                        this.flushBytes = nBytes;
                                        return;
                                    }
                                }
                            } else {
                                this.inline = false;
                                NativeSocketWrapper.this.registerWriteInterest();
                                return;
                            }
                            if (nBytes != 0L) {
                                this.completionDone = false;
                            }
                        }
                    }
                    catch (IOException e2) {
                        NativeSocketWrapper.this.setError(e2);
                    }
                }
                if (nBytes > 0L) {
                    this.completion.completed(nBytes, this);
                } else if (nBytes < 0L || NativeSocketWrapper.this.getError() != null) {
                    IOException error = NativeSocketWrapper.this.getError();
                    if (error == null) {
                        error = new EOFException();
                    }
                    this.completion.failed((Throwable)error, this);
                } else {
                    this.inline = false;
                    if (this.read) {
                        NativeSocketWrapper.this.registerReadInterest();
                    } else {
                        NativeSocketWrapper.this.registerWriteInterest();
                    }
                }
            }
        }
    }

    protected class SocketProcessor
    extends SocketProcessorBase<Long> {
        public SocketProcessor(SocketWrapperBase<Long> socketWrapper, SocketEvent event) {
            super(socketWrapper, event);
        }

        @Override
        protected AbstractEndpoint.Handler.SocketState doRun() {
            try {
                AbstractEndpoint.Handler.SocketState state = NativeEndpoint.this.getHandler().process(this.socketWrapper, this.event);
                if (state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                    NativeEndpoint.this.closeSocket((Long)this.socketWrapper.getSocket());
                }
                AbstractEndpoint.Handler.SocketState socketState = null;
                return socketState;
            }
            finally {
                this.socketWrapper = null;
                this.event = null;
                if (NativeEndpoint.this.running && !NativeEndpoint.this.paused) {
                    NativeEndpoint.this.processorCache.push(this);
                }
            }
        }
    }

    protected class SocketWithOptionsProcessor
    implements Runnable {
        protected SocketWrapperBase<Long> socket = null;

        public SocketWithOptionsProcessor(SocketWrapperBase<Long> socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SocketWrapperBase<Long> socketWrapperBase = this.socket;
            synchronized (socketWrapperBase) {
                if (!NativeEndpoint.this.deferAccept) {
                    if (NativeEndpoint.this.setSocketOptions(this.socket)) {
                        NativeEndpoint.this.getPoller().add(this.socket.getSocket(), NativeEndpoint.this.getConnectionTimeout(), 1);
                    } else {
                        NativeEndpoint.this.getHandler().process(this.socket, SocketEvent.CONNECT_FAIL);
                        NativeEndpoint.this.closeSocket(this.socket.getSocket());
                        this.socket = null;
                    }
                } else {
                    if (!NativeEndpoint.this.setSocketOptions(this.socket)) {
                        NativeEndpoint.this.getHandler().process(this.socket, SocketEvent.CONNECT_FAIL);
                        NativeEndpoint.this.closeSocket(this.socket.getSocket());
                        this.socket = null;
                        return;
                    }
                    AbstractEndpoint.Handler.SocketState state = NativeEndpoint.this.getHandler().process(this.socket, SocketEvent.OPEN_READ);
                    if (state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        NativeEndpoint.this.closeSocket(this.socket.getSocket());
                        this.socket = null;
                    }
                }
            }
        }
    }

    public class Sendfile
    implements Runnable {
        protected long sendfilePollset = 0L;
        protected long pool = 0L;
        protected long[] desc;
        protected HashMap<Long, SendfileData> sendfileData;
        protected int sendfileCount;
        protected ArrayList<SendfileData> addS;
        private volatile boolean sendfileRunning = true;

        public int getSendfileCount() {
            return this.sendfileCount;
        }

        protected void init() {
            this.pool = Pool.create(NativeEndpoint.this.serverSockPool);
            int size = NativeEndpoint.this.sendfileSize;
            if (size <= 0) {
                size = 16384;
            }
            this.sendfilePollset = NativeEndpoint.this.allocatePoller(size, this.pool, NativeEndpoint.this.getConnectionTimeout());
            this.desc = new long[size * 2];
            this.sendfileData = new HashMap(size);
            this.addS = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroy() {
            this.sendfileRunning = false;
            try {
                Sendfile sendfile = this;
                synchronized (sendfile) {
                    this.notify();
                    this.wait(NativeEndpoint.this.pollTime / 1000);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (int i2 = this.addS.size() - 1; i2 >= 0; --i2) {
                SendfileData data = this.addS.get(i2);
                NativeEndpoint.this.closeSocket(data.socket);
            }
            int rv = Poll.pollset(this.sendfilePollset, this.desc);
            if (rv > 0) {
                for (int n2 = 0; n2 < rv; ++n2) {
                    NativeEndpoint.this.closeSocket(this.desc[n2 * 2 + 1]);
                }
            }
            Pool.destroy(this.pool);
            this.sendfileData.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SendfileState add(SendfileData data) {
            try {
                data.fdpool = Socket.pool(data.socket);
                data.fd = File.open(data.fileName, 4129, 0, data.fdpool);
                Socket.timeoutSet(data.socket, 0L);
                while (this.sendfileRunning) {
                    long nw = Socket.sendfilen(data.socket, data.fd, data.pos, data.length, 0);
                    if (nw < 0L) {
                        if (-nw == 120002L) break;
                        Pool.destroy(data.fdpool);
                        data.socket = 0L;
                        return SendfileState.ERROR;
                    }
                    data.pos += nw;
                    data.length -= nw;
                    if (data.length != 0L) continue;
                    Pool.destroy(data.fdpool);
                    Socket.timeoutSet(data.socket, NativeEndpoint.this.getConnectionTimeout() * 1000);
                    return SendfileState.DONE;
                }
            }
            catch (Exception e2) {
                log.warn(AbstractEndpoint.sm.getString("endpoint.sendfile.error"), e2);
                return SendfileState.ERROR;
            }
            Sendfile sendfile = this;
            synchronized (sendfile) {
                this.addS.add(data);
                this.notify();
            }
            return SendfileState.PENDING;
        }

        protected void remove(SendfileData data) {
            int rv = Poll.remove(this.sendfilePollset, data.socket);
            if (rv == 0) {
                --this.sendfileCount;
            }
            this.sendfileData.remove(data.socket);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long maintainTime = 0L;
            while (this.sendfileRunning) {
                Sendfile sendfile;
                while (this.sendfileRunning && NativeEndpoint.this.paused) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                while (this.sendfileRunning && this.sendfileCount < 1 && this.addS.size() < 1) {
                    maintainTime = 0L;
                    try {
                        sendfile = this;
                        synchronized (sendfile) {
                            if (this.sendfileRunning && this.sendfileCount < 1 && this.addS.size() < 1) {
                                this.wait();
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                if (!this.sendfileRunning) break;
                try {
                    int errn;
                    Object state;
                    int n2;
                    if (this.addS.size() > 0) {
                        sendfile = this;
                        synchronized (sendfile) {
                            for (int i2 = this.addS.size() - 1; i2 >= 0; --i2) {
                                SendfileData data = this.addS.get(i2);
                                int rv = Poll.add(this.sendfilePollset, data.socket, 4);
                                if (rv == 0) {
                                    this.sendfileData.put(data.socket, data);
                                    ++this.sendfileCount;
                                    continue;
                                }
                                NativeEndpoint.this.getLog().warn(AbstractEndpoint.sm.getString("endpoint.sendfile.addfail", rv, Error.strerror(rv)));
                                NativeEndpoint.this.closeSocket(data.socket);
                            }
                            this.addS.clear();
                        }
                    }
                    maintainTime += (long)NativeEndpoint.this.pollTime;
                    int rv = Poll.poll(this.sendfilePollset, NativeEndpoint.this.pollTime, this.desc, false);
                    if (rv > 0) {
                        block27: for (n2 = 0; n2 < rv; ++n2) {
                            state = this.sendfileData.get(this.desc[n2 * 2 + 1]);
                            if ((this.desc[n2 * 2] & 0x20L) == 32L || (this.desc[n2 * 2] & 0x10L) == 16L) {
                                this.remove((SendfileData)state);
                                NativeEndpoint.this.closeSocket(((SendfileData)state).socket);
                                continue;
                            }
                            long nw = Socket.sendfilen(((SendfileData)state).socket, ((SendfileData)state).fd, ((SendfileData)state).pos, ((SendfileData)state).length, 0);
                            if (nw < 0L) {
                                this.remove((SendfileData)state);
                                NativeEndpoint.this.closeSocket(((SendfileData)state).socket);
                                continue;
                            }
                            ((SendfileData)state).pos += nw;
                            ((SendfileData)state).length -= nw;
                            if (((SendfileData)state).length != 0L) continue;
                            this.remove((SendfileData)state);
                            switch (((SendfileData)state).keepAliveState) {
                                case NONE: {
                                    NativeEndpoint.this.closeSocket(((SendfileData)state).socket);
                                    continue block27;
                                }
                                case PIPELINED: {
                                    Pool.destroy(((SendfileData)state).fdpool);
                                    Socket.timeoutSet(((SendfileData)state).socket, NativeEndpoint.this.getConnectionTimeout() * 1000);
                                    if (NativeEndpoint.this.processSocket(((SendfileData)state).socket, SocketEvent.OPEN_READ)) continue block27;
                                    NativeEndpoint.this.closeSocket(((SendfileData)state).socket);
                                    continue block27;
                                }
                                case OPEN: {
                                    Pool.destroy(((SendfileData)state).fdpool);
                                    Socket.timeoutSet(((SendfileData)state).socket, NativeEndpoint.this.getConnectionTimeout() * 1000);
                                    NativeEndpoint.this.getPoller().add(((SendfileData)state).socket, NativeEndpoint.this.getKeepAliveTimeout(), 1);
                                }
                            }
                        }
                    } else if (rv < 0 && (errn = -rv) != 120001 && errn != 120003) {
                        if (errn > 120000) {
                            errn -= 120000;
                        }
                        NativeEndpoint.this.getLog().error(AbstractEndpoint.sm.getString("endpoint.apr.pollError", errn, Error.strerror(errn)));
                        state = this;
                        synchronized (state) {
                            this.destroy();
                            this.init();
                            continue;
                        }
                    }
                    if (NativeEndpoint.this.getConnectionTimeout() <= 0 || maintainTime <= 1000000L || !this.sendfileRunning) continue;
                    rv = Poll.maintain(this.sendfilePollset, this.desc, false);
                    maintainTime = 0L;
                    if (rv <= 0) continue;
                    for (n2 = 0; n2 < rv; ++n2) {
                        state = this.sendfileData.get(this.desc[n2]);
                        this.remove((SendfileData)state);
                        NativeEndpoint.this.closeSocket(((SendfileData)state).socket);
                    }
                }
                catch (Throwable t2) {
                    ExceptionUtils.handleThrowable(t2);
                    NativeEndpoint.this.getLog().error(AbstractEndpoint.sm.getString("endpoint.poll.error"), t2);
                }
            }
            Sendfile sendfile = this;
            synchronized (sendfile) {
                this.notifyAll();
            }
        }
    }

    public static class SendfileData
    extends SendfileDataBase {
        protected long fd;
        protected long fdpool;
        protected long socket;

        public SendfileData(String filename, long pos, long length) {
            super(filename, pos, length);
        }
    }

    public class Poller
    implements Runnable {
        private long aprPoller;
        private int pollerSize = 0;
        private long pool = 0L;
        private long[] desc;
        private SocketList addList = null;
        private SocketList closeList = null;
        private SocketTimeouts timeouts = null;
        private long lastMaintain = System.currentTimeMillis();
        private AtomicInteger connectionCount = new AtomicInteger(0);
        private volatile boolean pollerRunning = true;

        public int getConnectionCount() {
            return this.connectionCount.get();
        }

        protected synchronized void init() {
            this.pool = Pool.create(NativeEndpoint.this.serverSockPool);
            this.pollerSize = NativeEndpoint.this.getMaxConnections();
            this.timeouts = new SocketTimeouts(this.pollerSize);
            this.aprPoller = NativeEndpoint.this.allocatePoller(this.pollerSize, this.pool, -1);
            this.desc = new long[this.pollerSize * 4];
            this.connectionCount.set(0);
            this.addList = new SocketList(this.pollerSize);
            this.closeList = new SocketList(this.pollerSize);
        }

        protected synchronized void stop() {
            this.pollerRunning = false;
        }

        protected synchronized void destroy() {
            try {
                this.notify();
                this.wait(NativeEndpoint.this.pollTime / 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SocketInfo info = this.closeList.get();
            while (info != null) {
                this.addList.remove(info.socket);
                this.removeFromPoller(info.socket);
                NativeEndpoint.this.destroySocket(info.socket);
                info = this.closeList.get();
            }
            this.closeList.clear();
            info = this.addList.get();
            while (info != null) {
                this.removeFromPoller(info.socket);
                NativeEndpoint.this.destroySocket(info.socket);
                info = this.addList.get();
            }
            this.addList.clear();
            int rv = Poll.pollset(this.aprPoller, this.desc);
            if (rv > 0) {
                for (int n2 = 0; n2 < rv; ++n2) {
                    NativeEndpoint.this.destroySocket(this.desc[n2 * 2 + 1]);
                }
            }
            Pool.destroy(this.pool);
            this.connectionCount.set(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(long socket, long timeout, int flags) {
            if (log.isDebugEnabled()) {
                String msg = AbstractEndpoint.sm.getString("endpoint.debug.pollerAdd", socket, timeout, flags);
                if (log.isTraceEnabled()) {
                    log.trace(msg, new Exception());
                } else {
                    log.debug(msg);
                }
            }
            if (timeout <= 0L) {
                timeout = Integer.MAX_VALUE;
            }
            Poller poller = this;
            synchronized (poller) {
                if (this.addList.add(socket, timeout, flags)) {
                    this.notify();
                }
            }
        }

        private boolean addToPoller(long socket, int events) {
            int rv = Poll.add(this.aprPoller, socket, events);
            if (rv == 0) {
                this.connectionCount.incrementAndGet();
                return true;
            }
            return false;
        }

        private synchronized void close(long socket) {
            this.closeList.add(socket, 0L, 0);
            this.notify();
        }

        private void removeFromPoller(long socket) {
            int rv;
            if (log.isDebugEnabled()) {
                log.debug(AbstractEndpoint.sm.getString("endpoint.debug.pollerRemove", socket));
            }
            if ((rv = Poll.remove(this.aprPoller, socket)) != 70015) {
                this.connectionCount.decrementAndGet();
                if (log.isDebugEnabled()) {
                    log.debug(AbstractEndpoint.sm.getString("endpoint.debug.pollerRemoved", socket));
                }
            }
            this.timeouts.remove(socket);
        }

        private synchronized void maintain() {
            long date = System.currentTimeMillis();
            if (date - this.lastMaintain < 1000L) {
                return;
            }
            this.lastMaintain = date;
            long socket = this.timeouts.check(date);
            while (socket != 0L) {
                if (log.isDebugEnabled()) {
                    log.debug(AbstractEndpoint.sm.getString("endpoint.debug.socketTimeout", socket));
                }
                SocketWrapperBase socketWrapper = (SocketWrapperBase)NativeEndpoint.this.connections.get(socket);
                socketWrapper.setError(new SocketTimeoutException());
                NativeEndpoint.this.processSocket(socketWrapper, SocketEvent.ERROR, true);
                socket = this.timeouts.check(date);
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Poller");
            long[] res = new long[this.pollerSize * 2];
            int count = Poll.pollset(this.aprPoller, res);
            buf.append(" [ ");
            for (int j2 = 0; j2 < count; ++j2) {
                buf.append(this.desc[2 * j2 + 1]).append(' ');
            }
            buf.append(']');
            return buf.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SocketList localAddList = new SocketList(NativeEndpoint.this.getMaxConnections());
            SocketList localCloseList = new SocketList(NativeEndpoint.this.getMaxConnections());
            while (this.pollerRunning) {
                while (this.pollerRunning && this.connectionCount.get() < 1 && this.addList.size() < 1 && this.closeList.size() < 1) {
                    try {
                        if (NativeEndpoint.this.getConnectionTimeout() > 0 && this.pollerRunning) {
                            this.maintain();
                        }
                        Poller poller = this;
                        synchronized (poller) {
                            if (this.addList.size() < 1 && this.closeList.size() < 1) {
                                this.wait(10000L);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Throwable t2) {
                        ExceptionUtils.handleThrowable(t2);
                        NativeEndpoint.this.getLog().warn(AbstractEndpoint.sm.getString("endpoint.timeout.err"));
                    }
                }
                if (!this.pollerRunning) break;
                try {
                    int errn;
                    SocketInfo info;
                    Poller t2 = this;
                    synchronized (t2) {
                        if (this.closeList.size() > 0) {
                            this.closeList.duplicate(localCloseList);
                            this.closeList.clear();
                        } else {
                            localCloseList.clear();
                        }
                    }
                    t2 = this;
                    synchronized (t2) {
                        if (this.addList.size() > 0) {
                            this.addList.duplicate(localAddList);
                            this.addList.clear();
                        } else {
                            localAddList.clear();
                        }
                    }
                    if (localCloseList.size() > 0) {
                        info = localCloseList.get();
                        while (info != null) {
                            localAddList.remove(info.socket);
                            this.removeFromPoller(info.socket);
                            NativeEndpoint.this.destroySocket(info.socket);
                            info = localCloseList.get();
                        }
                    }
                    if (localAddList.size() > 0) {
                        info = localAddList.get();
                        while (info != null) {
                            if (log.isDebugEnabled()) {
                                log.debug(AbstractEndpoint.sm.getString("endpoint.debug.pollerAddDo", info.socket));
                            }
                            this.timeouts.remove(info.socket);
                            NativeSocketWrapper wrapper = (NativeSocketWrapper)NativeEndpoint.this.connections.get(info.socket);
                            if (wrapper != null) {
                                if (info.read() || info.write()) {
                                    wrapper.pollerFlags = wrapper.pollerFlags | (info.read() ? 1 : 0) | (info.write() ? 4 : 0);
                                    this.removeFromPoller(info.socket);
                                    if (!this.addToPoller(info.socket, wrapper.pollerFlags)) {
                                        NativeEndpoint.this.closeSocket(info.socket);
                                    } else {
                                        this.timeouts.add(info.socket, System.currentTimeMillis() + info.timeout);
                                    }
                                } else {
                                    NativeEndpoint.this.closeSocket(info.socket);
                                    NativeEndpoint.this.getLog().warn(AbstractEndpoint.sm.getString("endpoint.apr.pollAddInvalid", info));
                                }
                            }
                            info = localAddList.get();
                        }
                    }
                    boolean reset = false;
                    int rv = Poll.poll(this.aprPoller, NativeEndpoint.this.pollTime, this.desc, true);
                    if (rv > 0) {
                        rv = this.mergeDescriptors(this.desc, rv);
                        this.connectionCount.addAndGet(-rv);
                        for (int n2 = 0; n2 < rv; ++n2) {
                            if (NativeEndpoint.this.getLog().isDebugEnabled()) {
                                log.debug(AbstractEndpoint.sm.getString("endpoint.debug.pollerProcess", this.desc[n2 * 2 + 1], this.desc[n2 * 2]));
                            }
                            long timeout = this.timeouts.remove(this.desc[n2 * 2 + 1]);
                            NativeSocketWrapper wrapper = (NativeSocketWrapper)NativeEndpoint.this.connections.get(this.desc[n2 * 2 + 1]);
                            if (wrapper == null) continue;
                            wrapper.pollerFlags = wrapper.pollerFlags & ~((int)this.desc[n2 * 2]);
                            if ((this.desc[n2 * 2] & 0x20L) == 32L || (this.desc[n2 * 2] & 0x10L) == 16L || (this.desc[n2 * 2] & 0x40L) == 64L) {
                                if ((this.desc[n2 * 2] & 1L) == 1L) {
                                    if (NativeEndpoint.this.processSocket(this.desc[n2 * 2 + 1], SocketEvent.OPEN_READ)) continue;
                                    NativeEndpoint.this.closeSocket(this.desc[n2 * 2 + 1]);
                                    continue;
                                }
                                if ((this.desc[n2 * 2] & 4L) == 4L) {
                                    if (NativeEndpoint.this.processSocket(this.desc[n2 * 2 + 1], SocketEvent.OPEN_WRITE)) continue;
                                    NativeEndpoint.this.closeSocket(this.desc[n2 * 2 + 1]);
                                    continue;
                                }
                                if ((wrapper.pollerFlags & 1) == 1) {
                                    if (NativeEndpoint.this.processSocket(this.desc[n2 * 2 + 1], SocketEvent.OPEN_READ)) continue;
                                    NativeEndpoint.this.closeSocket(this.desc[n2 * 2 + 1]);
                                    continue;
                                }
                                if ((wrapper.pollerFlags & 4) == 4) {
                                    if (NativeEndpoint.this.processSocket(this.desc[n2 * 2 + 1], SocketEvent.OPEN_WRITE)) continue;
                                    NativeEndpoint.this.closeSocket(this.desc[n2 * 2 + 1]);
                                    continue;
                                }
                                NativeEndpoint.this.closeSocket(this.desc[n2 * 2 + 1]);
                                continue;
                            }
                            if ((this.desc[n2 * 2] & 1L) == 1L || (this.desc[n2 * 2] & 4L) == 4L) {
                                boolean error = false;
                                if ((this.desc[n2 * 2] & 1L) == 1L && !NativeEndpoint.this.processSocket(this.desc[n2 * 2 + 1], SocketEvent.OPEN_READ)) {
                                    error = true;
                                    NativeEndpoint.this.closeSocket(this.desc[n2 * 2 + 1]);
                                }
                                if (!error && (this.desc[n2 * 2] & 4L) == 4L && !NativeEndpoint.this.processSocket(this.desc[n2 * 2 + 1], SocketEvent.OPEN_WRITE)) {
                                    error = true;
                                    NativeEndpoint.this.closeSocket(this.desc[n2 * 2 + 1]);
                                }
                                if (error || wrapper.pollerFlags == 0) continue;
                                if (timeout > 0L) {
                                    timeout -= System.currentTimeMillis();
                                }
                                if (timeout <= 0L) {
                                    timeout = 1L;
                                }
                                if (timeout > Integer.MAX_VALUE) {
                                    timeout = Integer.MAX_VALUE;
                                }
                                this.add(this.desc[n2 * 2 + 1], (int)timeout, wrapper.pollerFlags);
                                continue;
                            }
                            NativeEndpoint.this.getLog().warn(AbstractEndpoint.sm.getString("endpoint.apr.pollUnknownEvent", this.desc[n2 * 2]));
                            NativeEndpoint.this.closeSocket(this.desc[n2 * 2 + 1]);
                        }
                    } else if (rv < 0 && (errn = -rv) != 120001 && errn != 120003) {
                        if (errn > 120000) {
                            errn -= 120000;
                        }
                        NativeEndpoint.this.getLog().error(AbstractEndpoint.sm.getString("endpoint.apr.pollError", errn, Error.strerror(errn)));
                        reset = true;
                    }
                    if (reset && this.pollerRunning) {
                        int count = Poll.pollset(this.aprPoller, this.desc);
                        long newPoller = NativeEndpoint.this.allocatePoller(this.pollerSize, this.pool, -1);
                        this.connectionCount.addAndGet(-count);
                        Poll.destroy(this.aprPoller);
                        this.aprPoller = newPoller;
                    }
                }
                catch (Throwable t3) {
                    ExceptionUtils.handleThrowable(t3);
                    NativeEndpoint.this.getLog().warn(AbstractEndpoint.sm.getString("endpoint.poll.error"), t3);
                }
                try {
                    if (NativeEndpoint.this.getConnectionTimeout() <= 0 || !this.pollerRunning) continue;
                    this.maintain();
                }
                catch (Throwable t4) {
                    ExceptionUtils.handleThrowable(t4);
                    NativeEndpoint.this.getLog().warn(AbstractEndpoint.sm.getString("endpoint.timeout.err"), t4);
                }
            }
            Poller poller = this;
            synchronized (poller) {
                this.notifyAll();
            }
        }

        private int mergeDescriptors(long[] desc, int startCount) {
            HashMap<Long, Long> merged = new HashMap<Long, Long>(startCount);
            for (int n2 = 0; n2 < startCount; ++n2) {
                Long old = merged.put(desc[2 * n2 + 1], desc[2 * n2]);
                if (old == null) continue;
                merged.put(desc[2 * n2 + 1], desc[2 * n2] | old);
                if (!log.isDebugEnabled()) continue;
                log.debug(AbstractEndpoint.sm.getString("endpoint.apr.pollMergeEvents", desc[2 * n2 + 1], desc[2 * n2], old));
            }
            int i2 = 0;
            for (Map.Entry entry : merged.entrySet()) {
                desc[i2++] = (Long)entry.getValue();
                desc[i2++] = (Long)entry.getKey();
            }
            return merged.size();
        }
    }

    public static class SocketList {
        protected volatile int size = 0;
        protected int pos = 0;
        protected long[] sockets;
        protected long[] timeouts;
        protected int[] flags;
        protected SocketInfo info = new SocketInfo();

        public SocketList(int size) {
            this.sockets = new long[size];
            this.timeouts = new long[size];
            this.flags = new int[size];
        }

        public int size() {
            return this.size;
        }

        public SocketInfo get() {
            if (this.pos == this.size) {
                return null;
            }
            this.info.socket = this.sockets[this.pos];
            this.info.timeout = this.timeouts[this.pos];
            this.info.flags = this.flags[this.pos];
            ++this.pos;
            return this.info;
        }

        public void clear() {
            this.size = 0;
            this.pos = 0;
        }

        public boolean add(long socket, long timeout, int flag) {
            if (this.size == this.sockets.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (this.sockets[i2] != socket) continue;
                this.flags[i2] = SocketInfo.merge(this.flags[i2], flag);
                return true;
            }
            this.sockets[this.size] = socket;
            this.timeouts[this.size] = timeout;
            this.flags[this.size] = flag;
            ++this.size;
            return true;
        }

        public boolean remove(long socket) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (this.sockets[i2] != socket) continue;
                this.sockets[i2] = this.sockets[this.size - 1];
                this.timeouts[i2] = this.timeouts[this.size - 1];
                this.flags[this.size] = this.flags[this.size - 1];
                --this.size;
                return true;
            }
            return false;
        }

        public void duplicate(SocketList copy) {
            copy.size = this.size;
            copy.pos = this.pos;
            System.arraycopy(this.sockets, 0, copy.sockets, 0, this.size);
            System.arraycopy(this.timeouts, 0, copy.timeouts, 0, this.size);
            System.arraycopy(this.flags, 0, copy.flags, 0, this.size);
        }
    }

    public static class SocketTimeouts {
        protected int size = 0;
        protected long[] sockets;
        protected long[] timeouts;
        protected int pos = 0;

        public SocketTimeouts(int size) {
            this.sockets = new long[size];
            this.timeouts = new long[size];
        }

        public void add(long socket, long timeout) {
            this.sockets[this.size] = socket;
            this.timeouts[this.size] = timeout;
            ++this.size;
        }

        public long remove(long socket) {
            long result = 0L;
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (this.sockets[i2] != socket) continue;
                result = this.timeouts[i2];
                this.sockets[i2] = this.sockets[this.size - 1];
                this.timeouts[i2] = this.timeouts[this.size - 1];
                --this.size;
                break;
            }
            return result;
        }

        public long check(long date) {
            while (this.pos < this.size) {
                if (date >= this.timeouts[this.pos]) {
                    long result = this.sockets[this.pos];
                    this.sockets[this.pos] = this.sockets[this.size - 1];
                    this.timeouts[this.pos] = this.timeouts[this.size - 1];
                    --this.size;
                    return result;
                }
                ++this.pos;
            }
            this.pos = 0;
            return 0L;
        }
    }

    public static class SocketInfo {
        public long socket;
        public long timeout;
        public int flags;

        public boolean read() {
            return (this.flags & 1) == 1;
        }

        public boolean write() {
            return (this.flags & 4) == 4;
        }

        public static int merge(int flag1, int flag2) {
            return flag1 & 1 | flag2 & 1 | (flag1 & 4 | flag2 & 4);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Socket: [");
            sb.append(this.socket);
            sb.append("], timeout: [");
            sb.append(this.timeout);
            sb.append("], flags: [");
            sb.append(this.flags);
            return sb.toString();
        }
    }

    protected class Acceptor
    extends AbstractEndpoint.Acceptor {
        private final Log log = LogFactory.getLog(Acceptor.class);

        protected Acceptor() {
        }

        @Override
        public void run() {
            NativeEndpoint.this.waitPortBound();
            int errorDelay = 0;
            while (NativeEndpoint.this.running) {
                while (NativeEndpoint.this.paused && NativeEndpoint.this.running) {
                    this.state = AbstractEndpoint.Acceptor.AcceptorState.PAUSED;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!NativeEndpoint.this.running) break;
                this.state = AbstractEndpoint.Acceptor.AcceptorState.RUNNING;
                try {
                    NativeEndpoint.this.countUpOrAwaitConnection();
                    long socket = 0L;
                    try {
                        socket = Socket.accept(NativeEndpoint.this.serverSock);
                        NativeEndpoint.this.connectionCounter.getAndIncrement();
                        if (this.log.isDebugEnabled()) {
                            long sa = Address.get(1, socket);
                            Sockaddr addr = Address.getInfo(sa);
                            this.log.debug(AbstractEndpoint.sm.getString("endpoint.apr.remoteport", socket, addr.port));
                        }
                    }
                    catch (Exception e2) {
                        NativeEndpoint.this.countDownConnection();
                        if (!NativeEndpoint.this.running) break;
                        errorDelay = NativeEndpoint.this.handleExceptionWithDelay(errorDelay);
                        throw e2;
                    }
                    errorDelay = 0;
                    if (NativeEndpoint.this.running && !NativeEndpoint.this.paused) {
                        if (NativeEndpoint.this.processSocketWithOptions(socket)) continue;
                        NativeEndpoint.this.closeSocket(socket);
                        continue;
                    }
                    NativeEndpoint.this.destroySocket(socket);
                }
                catch (Throwable t2) {
                    ExceptionUtils.handleThrowable(t2);
                    String msg = AbstractEndpoint.sm.getString("endpoint.accept.fail");
                    if (t2 instanceof Error) {
                        Error e3 = (Error)t2;
                        if (e3.getError() == 233) {
                            this.log.warn(msg, t2);
                            continue;
                        }
                        this.log.error(msg, t2);
                        continue;
                    }
                    this.log.error(msg, t2);
                }
            }
            this.state = AbstractEndpoint.Acceptor.AcceptorState.ENDED;
        }
    }
}

