/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.net;

import com.bes.enterprise.web.util.net.NativeEndpoint;
import com.bes.enterprise.web.util.net.SSLSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class NativeSSLSupport
implements SSLSupport {
    private final NativeEndpoint.NativeSocketWrapper socketWrapper;
    private final String clientCertProvider;

    public NativeSSLSupport(NativeEndpoint.NativeSocketWrapper socketWrapper, String clientCertProvider) {
        this.socketWrapper = socketWrapper;
        this.clientCertProvider = clientCertProvider;
    }

    @Override
    public String getCipherSuite() throws IOException {
        try {
            return this.socketWrapper.getSSLInfoS(2);
        }
        catch (Exception e2) {
            throw new IOException(e2);
        }
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws IOException {
        try {
            int certLength = this.socketWrapper.getSSLInfoI(1024);
            byte[] clientCert = this.socketWrapper.getSSLInfoB(263);
            X509Certificate[] certs = null;
            if (clientCert != null) {
                if (certLength < 0) {
                    certLength = 0;
                }
                certs = new X509Certificate[certLength + 1];
                CertificateFactory cf = this.clientCertProvider == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", this.clientCertProvider);
                certs[0] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(clientCert));
                for (int i2 = 0; i2 < certLength; ++i2) {
                    byte[] data = this.socketWrapper.getSSLInfoB(1024 + i2);
                    certs[i2 + 1] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(data));
                }
            }
            return certs;
        }
        catch (Exception e2) {
            throw new IOException(e2);
        }
    }

    @Override
    public Integer getKeySize() throws IOException {
        try {
            return this.socketWrapper.getSSLInfoI(3);
        }
        catch (Exception e2) {
            throw new IOException(e2);
        }
    }

    @Override
    public String getSessionId() throws IOException {
        try {
            return this.socketWrapper.getSSLInfoS(1);
        }
        catch (Exception e2) {
            throw new IOException(e2);
        }
    }

    @Override
    public String getProtocol() throws IOException {
        try {
            return this.socketWrapper.getSSLInfoS(7);
        }
        catch (Exception e2) {
            throw new IOException(e2);
        }
    }
}

