/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.net;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.net.NioBlockingSelector;
import com.bes.enterprise.web.util.net.NioChannel;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class SafeSelectorPool {
    private static final Log log = LogFactory.getLog(SafeSelectorPool.class);
    protected static final boolean SHARED = Boolean.parseBoolean(System.getProperty("com.bes.enterprise.web.selectorShared", "true"));
    private static final int spinCountTreshhold = Integer.getInteger("com.bes.enterprise.web.spinCountTreshhold", 500);
    private static final long spinRateTreshhold = Long.getLong("com.bes.enterprise.web.spinRateTreshhold", 1000L);
    static final boolean isLinux = System.getProperty("os.name").equalsIgnoreCase("linux");
    protected NioBlockingSelector blockingSelector;
    protected volatile Selector SHARED_SELECTOR;
    protected int maxSelectors = 200;
    protected long sharedSelectorTimeout = 30000L;
    protected int maxSpareSelectors = -1;
    protected boolean enabled = true;
    protected AtomicInteger active = new AtomicInteger(0);
    protected AtomicInteger spare = new AtomicInteger(0);
    protected ConcurrentLinkedQueue<Selector> selectors = new ConcurrentLinkedQueue();

    private Selector workaroundSelectorSpin(Selector selector) throws IOException {
        Selector newSelector = null;
        try {
            newSelector = Selector.open();
        }
        catch (IOException ioE) {
            log.info("Unexpected problem occurred when opening a new selector to resolve spinning select.", ioE);
            throw ioE;
        }
        if (log.isDebugEnabled()) {
            log.info("Open a new selector to resolve spinning select.");
        }
        try {
            selector.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Selector getSharedSelector() throws IOException {
        if (!SHARED || this.SHARED_SELECTOR != null) return this.SHARED_SELECTOR;
        Class<SafeSelectorPool> clazz = SafeSelectorPool.class;
        synchronized (SafeSelectorPool.class) {
            if (this.SHARED_SELECTOR != null) return this.SHARED_SELECTOR;
            this.SHARED_SELECTOR = Selector.open();
            log.info("Using a shared selector for servlet write/read");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.SHARED_SELECTOR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Selector get() throws IOException {
        if (SHARED) {
            return this.getSharedSelector();
        }
        if (!this.enabled || this.active.incrementAndGet() >= this.maxSelectors) {
            if (this.enabled) {
                this.active.decrementAndGet();
            }
            return null;
        }
        Selector s2 = null;
        try {
            Selector selector = s2 = !this.selectors.isEmpty() ? this.selectors.poll() : null;
            if (s2 == null) {
                s2 = Selector.open();
            } else {
                this.spare.decrementAndGet();
            }
        }
        catch (NoSuchElementException x2) {
            try {
                s2 = Selector.open();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            if (s2 == null) {
                this.active.decrementAndGet();
            }
        }
        return s2;
    }

    public void put(Selector s2) throws IOException {
        if (SHARED) {
            return;
        }
        if (this.enabled) {
            this.active.decrementAndGet();
        }
        if (this.enabled && (this.maxSpareSelectors == -1 || this.spare.get() < Math.min(this.maxSpareSelectors, this.maxSelectors))) {
            this.spare.incrementAndGet();
            this.selectors.offer(s2);
        } else {
            s2.close();
        }
    }

    public void close() throws IOException {
        Selector s2;
        this.enabled = false;
        while ((s2 = this.selectors.poll()) != null) {
            s2.close();
        }
        this.spare.set(0);
        this.active.set(0);
        if (this.blockingSelector != null) {
            this.blockingSelector.close();
        }
        if (SHARED && this.getSharedSelector() != null) {
            this.getSharedSelector().close();
            this.SHARED_SELECTOR = null;
        }
    }

    public void open() throws IOException {
        this.enabled = true;
        this.getSharedSelector();
        if (SHARED) {
            this.blockingSelector = new NioBlockingSelector();
            this.blockingSelector.open(this.getSharedSelector());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer buf, NioChannel socket, long writeTimeout, boolean block) throws IOException {
        if (SHARED && block) {
            return this.blockingSelector.write(buf, socket, writeTimeout);
        }
        SelectionKey key = null;
        int written = 0;
        boolean timedout = false;
        int keycount = 1;
        long time = System.currentTimeMillis();
        int emptySpinCounter = 0;
        long lastSpinTimestamp = 0L;
        Selector selector = null;
        try {
            while (!timedout && buf.hasRemaining()) {
                int cnt = 0;
                if (keycount > 0) {
                    cnt = socket.write(buf);
                    if (cnt == -1) {
                        throw new EOFException();
                    }
                    written += cnt;
                    if (cnt > 0) {
                        time = System.currentTimeMillis();
                        continue;
                    }
                    if (cnt == 0 && !block) break;
                }
                if (selector == null) {
                    selector = this.get();
                }
                if (selector != null) {
                    if (key == null || !key.isValid()) {
                        key = socket.getIOChannel().register(selector, 4);
                    } else {
                        key.interestOps(4);
                    }
                    if (writeTimeout == 0L) {
                        timedout = buf.hasRemaining();
                    } else {
                        keycount = writeTimeout < 0L ? selector.select() : selector.select(writeTimeout);
                    }
                    if (keycount > 0 && isLinux) {
                        emptySpinCounter = 0;
                    } else if (isLinux) {
                        long sr = 0L;
                        if (emptySpinCounter++ == 0) {
                            lastSpinTimestamp = System.nanoTime();
                        } else if (emptySpinCounter == spinCountTreshhold) {
                            long deltatime = System.nanoTime() - lastSpinTimestamp;
                            int contspinspersec = (int)(1000000000000L / deltatime);
                            emptySpinCounter = 0;
                            sr = contspinspersec;
                        }
                        if (sr > spinRateTreshhold) {
                            if (key.isValid()) {
                                key.cancel();
                                key = null;
                            }
                            selector = this.workaroundSelectorSpin(selector);
                        }
                    }
                }
                if (writeTimeout <= 0L || selector != null && keycount != 0) continue;
                timedout = System.currentTimeMillis() - time >= writeTimeout;
            }
            if (timedout) {
                throw new SocketTimeoutException();
            }
        }
        finally {
            if (key != null) {
                key.cancel();
                if (selector != null) {
                    selector.selectNow();
                    this.put(selector);
                }
            }
        }
        return written;
    }

    public int read(ByteBuffer buf, NioChannel socket, long readTimeout) throws IOException {
        return this.read(buf, socket, readTimeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer buf, NioChannel socket, long readTimeout, boolean block) throws IOException {
        if (SHARED && block) {
            return this.blockingSelector.read(buf, socket, readTimeout);
        }
        SelectionKey key = null;
        int read = 0;
        boolean timedout = false;
        int keycount = 1;
        long time = System.currentTimeMillis();
        int emptySpinCounter = 0;
        long lastSpinTimestamp = 0L;
        Selector selector = null;
        try {
            while (!(timedout || keycount > 0 && (read = socket.read(buf)) != 0)) {
                if (selector == null) {
                    selector = this.get();
                }
                if (selector != null) {
                    if (key == null || !key.isValid()) {
                        key = socket.getIOChannel().register(selector, 1);
                    } else {
                        key.interestOps(1);
                    }
                    if (readTimeout == 0L) {
                        timedout = read == 0;
                    } else {
                        keycount = readTimeout < 0L ? selector.select() : selector.select(readTimeout);
                    }
                    if (keycount > 0 && isLinux) {
                        emptySpinCounter = 0;
                    } else if (isLinux) {
                        long sr = 0L;
                        if (emptySpinCounter++ == 0) {
                            lastSpinTimestamp = System.nanoTime();
                        } else if (emptySpinCounter == spinCountTreshhold) {
                            long deltatime = System.nanoTime() - lastSpinTimestamp;
                            int contspinspersec = (int)(1000000000000L / deltatime);
                            emptySpinCounter = 0;
                            sr = contspinspersec;
                        }
                        if (sr > spinRateTreshhold) {
                            if (key.isValid()) {
                                key.cancel();
                                key = null;
                            }
                            selector = this.workaroundSelectorSpin(selector);
                        }
                    }
                }
                if (readTimeout <= 0L || selector != null && keycount != 0) continue;
                timedout = System.currentTimeMillis() - time >= readTimeout;
            }
            if (timedout) {
                throw new SocketTimeoutException();
            }
        }
        finally {
            if (key != null) {
                key.cancel();
                if (selector != null) {
                    selector.selectNow();
                    this.put(selector);
                }
            }
        }
        return read;
    }

    public void setMaxSelectors(int maxSelectors) {
        this.maxSelectors = maxSelectors;
    }

    public void setMaxSpareSelectors(int maxSpareSelectors) {
        this.maxSpareSelectors = maxSpareSelectors;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setSharedSelectorTimeout(long sharedSelectorTimeout) {
        this.sharedSelectorTimeout = sharedSelectorTimeout;
    }

    public int getMaxSelectors() {
        return this.maxSelectors;
    }

    public int getMaxSpareSelectors() {
        return this.maxSpareSelectors;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getSharedSelectorTimeout() {
        return this.sharedSelectorTimeout;
    }

    public ConcurrentLinkedQueue<Selector> getSelectors() {
        return this.selectors;
    }

    public AtomicInteger getSpare() {
        return this.spare;
    }
}

