/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.net.openssl;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.net.SSLContext;
import com.bes.enterprise.web.util.net.SSLHostConfigCertificate;
import com.bes.enterprise.web.util.net.SSLUtilBase;
import com.bes.enterprise.web.util.net.jsse.JSSEKeyManager;
import com.bes.enterprise.web.util.net.openssl.OpenSSLContext;
import com.bes.enterprise.web.util.net.openssl.OpenSSLEngine;
import com.bes.enterprise.web.util.res.StringManager;
import java.io.IOException;
import java.security.KeyStoreException;
import java.util.List;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.X509KeyManager;

public class OpenSSLUtil
extends SSLUtilBase {
    private static final Log log = LogFactory.getLog(OpenSSLUtil.class);
    private static final StringManager sm = StringManager.getManager(OpenSSLContext.class);

    public OpenSSLUtil(SSLHostConfigCertificate certificate) {
        super(certificate);
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected Set<String> getImplementedProtocols() {
        return OpenSSLEngine.IMPLEMENTED_PROTOCOLS_SET;
    }

    @Override
    protected Set<String> getImplementedCiphers() {
        return OpenSSLEngine.AVAILABLE_CIPHER_SUITES;
    }

    @Override
    protected boolean isTls13RenegAuthAvailable() {
        return true;
    }

    @Override
    public SSLContext createSSLContextInternal(List<String> negotiableProtocols) throws Exception {
        return new OpenSSLContext(this.certificate, negotiableProtocols);
    }

    public static X509KeyManager chooseKeyManager(KeyManager[] managers) throws Exception {
        if (managers == null) {
            return null;
        }
        for (KeyManager manager : managers) {
            if (!(manager instanceof JSSEKeyManager)) continue;
            return (JSSEKeyManager)manager;
        }
        for (KeyManager manager : managers) {
            if (!(manager instanceof X509KeyManager)) continue;
            return (X509KeyManager)manager;
        }
        throw new IllegalStateException(sm.getString("openssl.keyManagerMissing"));
    }

    @Override
    public KeyManager[] getKeyManagers() throws Exception {
        try {
            return super.getKeyManagers();
        }
        catch (IllegalArgumentException e2) {
            String msg = sm.getString("openssl.nonJsseChain", this.certificate.getCertificateChainFile());
            if (log.isDebugEnabled()) {
                log.info(msg, e2);
            } else {
                log.info(msg);
            }
            return null;
        }
        catch (IOException | KeyStoreException e3) {
            if (this.certificate.getCertificateFile() != null) {
                String msg = sm.getString("openssl.nonJsseCertficate", this.certificate.getCertificateFile(), this.certificate.getCertificateKeyFile());
                if (log.isDebugEnabled()) {
                    log.info(msg, e3);
                } else {
                    log.info(msg);
                }
                return null;
            }
            throw e3;
        }
    }
}

