/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.scan;

import com.bes.enterprise.web.Jar;
import com.bes.enterprise.web.util.buf.UriUtil;
import com.bes.enterprise.web.util.scan.JarFileUrlJar;
import com.bes.enterprise.web.util.scan.JarFileUrlNestedJar;
import com.bes.enterprise.web.util.scan.UrlJar;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;

public class JarFactory {
    private JarFactory() {
    }

    public static Jar newInstance(URL url) throws IOException {
        String urlString = url.toString();
        if (urlString.startsWith("jar:file:")) {
            if (urlString.endsWith("!/")) {
                return new JarFileUrlJar(url, true);
            }
            return new JarFileUrlNestedJar(url);
        }
        if (urlString.startsWith("war:file:")) {
            URL jarUrl = UriUtil.warToJar(url);
            return new JarFileUrlNestedJar(jarUrl);
        }
        if (urlString.startsWith("file:")) {
            return new JarFileUrlJar(url, false);
        }
        return new UrlJar(url);
    }

    public static URL getJarEntryURL(URL baseUrl, String entryName) throws MalformedURLException {
        String baseExternal = baseUrl.toExternalForm();
        if (baseExternal.startsWith("jar")) {
            baseExternal = baseExternal.replaceFirst("^jar:", "war:");
            baseExternal = baseExternal.replaceFirst("!/", Matcher.quoteReplacement(UriUtil.getWarSeparator()));
        }
        return new URL("jar:" + baseExternal + "!/" + entryName);
    }
}

