/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.scan;

import com.bes.enterprise.web.Jar;
import com.bes.enterprise.web.util.scan.JarFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Manifest;

public class ReferenceCountedJar
implements Jar {
    private final URL url;
    private Jar wrappedJar;
    private int referenceCount = 0;

    public ReferenceCountedJar(URL url) throws IOException {
        this.url = url;
        this.open();
    }

    private synchronized ReferenceCountedJar open() throws IOException {
        if (this.wrappedJar == null) {
            this.wrappedJar = JarFactory.newInstance(this.url);
        }
        ++this.referenceCount;
        return this;
    }

    @Override
    public synchronized void close() {
        --this.referenceCount;
        if (this.referenceCount == 0) {
            this.wrappedJar.close();
            this.wrappedJar = null;
        }
    }

    @Override
    public URL getJarFileURL() {
        return this.url;
    }

    @Override
    public InputStream getInputStream(String name) throws IOException {
        try (ReferenceCountedJar jar = this.open();){
            InputStream inputStream = jar.wrappedJar.getInputStream(name);
            return inputStream;
        }
    }

    @Override
    public long getLastModified(String name) throws IOException {
        try (ReferenceCountedJar jar = this.open();){
            long l2 = jar.wrappedJar.getLastModified(name);
            return l2;
        }
    }

    @Override
    public boolean exists(String name) throws IOException {
        try (ReferenceCountedJar jar = this.open();){
            boolean bl = jar.wrappedJar.exists(name);
            return bl;
        }
    }

    @Override
    public void nextEntry() {
        try (ReferenceCountedJar jar = this.open();){
            jar.wrappedJar.nextEntry();
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getEntryName() {
        try (ReferenceCountedJar jar = this.open();){
            String string = jar.wrappedJar.getEntryName();
            return string;
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    @Override
    public InputStream getEntryInputStream() throws IOException {
        try (ReferenceCountedJar jar = this.open();){
            InputStream inputStream = jar.wrappedJar.getEntryInputStream();
            return inputStream;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getURL(String entry) {
        try (ReferenceCountedJar jar = this.open();){
            String string = jar.wrappedJar.getURL(entry);
            return string;
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    @Override
    public Manifest getManifest() throws IOException {
        try (ReferenceCountedJar jar = this.open();){
            Manifest manifest = jar.wrappedJar.getManifest();
            return manifest;
        }
    }

    @Override
    public void reset() throws IOException {
        try (ReferenceCountedJar jar = this.open();){
            jar.wrappedJar.reset();
        }
    }

    @Override
    @Deprecated
    public boolean entryExists(String name) throws IOException {
        try (ReferenceCountedJar jar = this.open();){
            boolean bl = jar.wrappedJar.entryExists(name);
            return bl;
        }
    }
}

