/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.threads;

import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.web.util.threads.StopPooledThreadException;
import com.bes.enterprise.web.util.threads.WorkQueue;
import com.bes.enterprise.web.util.threads.WorkThread;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadPoolExecutor
extends java.util.concurrent.ThreadPoolExecutor {
    protected static final StringManager sm = StringManager.getManager("com.bes.enterprise.web.util.threads.res");
    private final AtomicInteger submittedCount = new AtomicInteger(0);
    private final AtomicLong lastContextStoppedTime = new AtomicLong(0L);
    private final AtomicLong lastTimeThreadKilledItself = new AtomicLong(0L);
    private long threadRenewalDelay = 1000L;

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
        this.prestartAllCoreThreads();
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.prestartAllCoreThreads();
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, new RejectHandler());
        this.prestartAllCoreThreads();
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new RejectHandler());
        this.prestartAllCoreThreads();
    }

    public long getThreadRenewalDelay() {
        return this.threadRenewalDelay;
    }

    public void setThreadRenewalDelay(long threadRenewalDelay) {
        this.threadRenewalDelay = threadRenewalDelay;
    }

    @Override
    protected void afterExecute(Runnable r2, Throwable t2) {
        this.submittedCount.decrementAndGet();
        if (t2 == null) {
            this.stopCurrentThreadIfNeeded();
        }
    }

    protected void stopCurrentThreadIfNeeded() {
        long lastTime;
        if (this.currentThreadShouldBeStopped() && (lastTime = this.lastTimeThreadKilledItself.longValue()) + this.threadRenewalDelay < System.currentTimeMillis() && this.lastTimeThreadKilledItself.compareAndSet(lastTime, System.currentTimeMillis() + 1L)) {
            String msg = sm.getString("threadPoolExecutor.threadStoppedToAvoidPotentialLeak", Thread.currentThread().getName());
            throw new StopPooledThreadException(msg);
        }
    }

    protected boolean currentThreadShouldBeStopped() {
        WorkThread currentWorkThread;
        return this.threadRenewalDelay >= 0L && Thread.currentThread() instanceof WorkThread && (currentWorkThread = (WorkThread)Thread.currentThread()).getCreationTime() < this.lastContextStoppedTime.longValue();
    }

    public int getSubmittedCount() {
        return this.submittedCount.get();
    }

    @Override
    public void execute(Runnable command) {
        this.execute(command, 0L, TimeUnit.MILLISECONDS);
    }

    public void execute(Runnable command, long timeout, TimeUnit unit) {
        this.submittedCount.incrementAndGet();
        try {
            super.execute(command);
        }
        catch (RejectedExecutionException rx) {
            if (super.getQueue() instanceof WorkQueue) {
                WorkQueue queue = (WorkQueue)super.getQueue();
                try {
                    if (!queue.force(command, timeout, unit)) {
                        this.submittedCount.decrementAndGet();
                        throw new RejectedExecutionException("Queue capacity is full.");
                    }
                }
                catch (InterruptedException x2) {
                    this.submittedCount.decrementAndGet();
                    throw new RejectedExecutionException(x2);
                }
            }
            this.submittedCount.decrementAndGet();
            throw rx;
        }
    }

    public void contextStopping() {
        WorkQueue taskQueue;
        this.lastContextStoppedTime.set(System.currentTimeMillis());
        int savedCorePoolSize = this.getCorePoolSize();
        WorkQueue workQueue = taskQueue = this.getQueue() instanceof WorkQueue ? (WorkQueue)this.getQueue() : null;
        if (taskQueue != null) {
            taskQueue.setForcedRemainingCapacity(0);
        }
        this.setCorePoolSize(0);
        if (taskQueue != null) {
            taskQueue.setForcedRemainingCapacity(null);
        }
        this.setCorePoolSize(savedCorePoolSize);
    }

    private static class RejectHandler
    implements RejectedExecutionHandler {
        private RejectHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r2, java.util.concurrent.ThreadPoolExecutor executor) {
            throw new RejectedExecutionException();
        }
    }
}

