/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.util.threads;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.threads.StopPooledThreadException;

public class WorkThread
extends Thread {
    private static final Log log = LogFactory.getLog(WorkThread.class);
    private final long creationTime = System.currentTimeMillis();

    public WorkThread(ThreadGroup group, Runnable target, String name) {
        super(group, new WrappingRunnable(target), name);
    }

    public WorkThread(ThreadGroup group, Runnable target, String name, long stackSize) {
        super(group, new WrappingRunnable(target), name, stackSize);
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    private static class WrappingRunnable
    implements Runnable {
        private Runnable wrappedRunnable;

        WrappingRunnable(Runnable wrappedRunnable) {
            this.wrappedRunnable = wrappedRunnable;
        }

        @Override
        public void run() {
            try {
                this.wrappedRunnable.run();
            }
            catch (StopPooledThreadException exc) {
                log.debug("Thread exiting on purpose", exc);
            }
        }
    }
}

