/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.websocket;

import com.bes.enterprise.web.websocket.Authenticator;
import com.bes.enterprise.web.websocket.BasicAuthenticator;
import com.bes.enterprise.web.websocket.DigestAuthenticator;
import java.util.ServiceLoader;

public class AuthenticatorFactory {
    public static Authenticator getAuthenticator(String authScheme) {
        Authenticator auth = null;
        switch (authScheme.toLowerCase()) {
            case "basic": {
                auth = new BasicAuthenticator();
                break;
            }
            case "digest": {
                auth = new DigestAuthenticator();
                break;
            }
            default: {
                auth = AuthenticatorFactory.loadAuthenticators(authScheme);
            }
        }
        return auth;
    }

    private static Authenticator loadAuthenticators(String authScheme) {
        ServiceLoader<Authenticator> serviceLoader = ServiceLoader.load(Authenticator.class);
        for (Authenticator auth : serviceLoader) {
            if (!auth.getSchemeName().equalsIgnoreCase(authScheme)) continue;
            return auth;
        }
        return null;
    }
}

