/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.websocket.pojo;

import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.web.websocket.pojo.PojoMessageHandlerWholeBase;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;

public class PojoMessageHandlerWholeBinary
extends PojoMessageHandlerWholeBase<ByteBuffer> {
    private static final StringManager sm = StringManager.getManager(PojoMessageHandlerWholeBinary.class);
    private final List<Decoder> decoders = new ArrayList<Decoder>();
    private final boolean isForInputStream;

    public PojoMessageHandlerWholeBinary(Object pojo, Method method, Session session, EndpointConfig config, List<Class<? extends Decoder>> decoderClazzes, Object[] params, int indexPayload, boolean convert, int indexSession, boolean isForInputStream, long maxMessageSize) {
        super(pojo, method, session, params, indexPayload, convert, indexSession, maxMessageSize);
        if (maxMessageSize > -1L && maxMessageSize > (long)session.getMaxBinaryMessageBufferSize()) {
            if (maxMessageSize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(sm.getString("pojoMessageHandlerWhole.maxBufferSize"));
            }
            session.setMaxBinaryMessageBufferSize((int)maxMessageSize);
        }
        try {
            if (decoderClazzes != null) {
                for (Class<? extends Decoder> decoderClazz : decoderClazzes) {
                    Decoder decoder;
                    if (Decoder.Binary.class.isAssignableFrom(decoderClazz)) {
                        decoder = (Decoder.Binary)decoderClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                        decoder.init(config);
                        this.decoders.add(decoder);
                        continue;
                    }
                    if (!Decoder.BinaryStream.class.isAssignableFrom(decoderClazz)) continue;
                    decoder = (Decoder.BinaryStream)decoderClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    decoder.init(config);
                    this.decoders.add(decoder);
                }
            }
        }
        catch (ReflectiveOperationException e2) {
            throw new IllegalArgumentException(e2);
        }
        this.isForInputStream = isForInputStream;
    }

    @Override
    protected Object decode(ByteBuffer message) throws DecodeException {
        for (Decoder decoder : this.decoders) {
            if (decoder instanceof Decoder.Binary) {
                if (!((Decoder.Binary)decoder).willDecode(message)) continue;
                return ((Decoder.Binary)decoder).decode(message);
            }
            byte[] array = new byte[message.limit() - message.position()];
            message.get(array);
            ByteArrayInputStream bais = new ByteArrayInputStream(array);
            try {
                return ((Decoder.BinaryStream)decoder).decode(bais);
            }
            catch (IOException ioe) {
                throw new DecodeException(message, sm.getString("pojoMessageHandlerWhole.decodeIoFail"), (Throwable)ioe);
            }
        }
        return null;
    }

    @Override
    protected Object convert(ByteBuffer message) {
        byte[] array = new byte[message.remaining()];
        message.get(array);
        if (this.isForInputStream) {
            return new ByteArrayInputStream(array);
        }
        return array;
    }

    @Override
    protected void onClose() {
        for (Decoder decoder : this.decoders) {
            decoder.destroy();
        }
    }
}

