/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.websocket.pojo;

import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.web.websocket.Util;
import com.bes.enterprise.web.websocket.pojo.PojoMessageHandlerWholeBase;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;

public class PojoMessageHandlerWholeText
extends PojoMessageHandlerWholeBase<String> {
    private static final StringManager sm = StringManager.getManager(PojoMessageHandlerWholeText.class);
    private final List<Decoder> decoders = new ArrayList<Decoder>();
    private final Class<?> primitiveType;

    public PojoMessageHandlerWholeText(Object pojo, Method method, Session session, EndpointConfig config, List<Class<? extends Decoder>> decoderClazzes, Object[] params, int indexPayload, boolean convert, int indexSession, long maxMessageSize) {
        super(pojo, method, session, params, indexPayload, convert, indexSession, maxMessageSize);
        Class<?> type;
        if (maxMessageSize > -1L && maxMessageSize > (long)session.getMaxTextMessageBufferSize()) {
            if (maxMessageSize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(sm.getString("pojoMessageHandlerWhole.maxBufferSize"));
            }
            session.setMaxTextMessageBufferSize((int)maxMessageSize);
        }
        if (Util.isPrimitive(type = method.getParameterTypes()[indexPayload])) {
            this.primitiveType = type;
            return;
        }
        this.primitiveType = null;
        try {
            if (decoderClazzes != null) {
                for (Class<? extends Decoder> decoderClazz : decoderClazzes) {
                    Decoder decoder;
                    if (Decoder.Text.class.isAssignableFrom(decoderClazz)) {
                        decoder = (Decoder.Text)decoderClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                        decoder.init(config);
                        this.decoders.add(decoder);
                        continue;
                    }
                    if (!Decoder.TextStream.class.isAssignableFrom(decoderClazz)) continue;
                    decoder = (Decoder.TextStream)decoderClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    decoder.init(config);
                    this.decoders.add(decoder);
                }
            }
        }
        catch (ReflectiveOperationException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    @Override
    protected Object decode(String message) throws DecodeException {
        if (this.primitiveType != null) {
            return Util.coerceToType(this.primitiveType, message);
        }
        for (Decoder decoder : this.decoders) {
            if (decoder instanceof Decoder.Text) {
                if (!((Decoder.Text)decoder).willDecode(message)) continue;
                return ((Decoder.Text)decoder).decode(message);
            }
            StringReader r2 = new StringReader(message);
            try {
                return ((Decoder.TextStream)decoder).decode(r2);
            }
            catch (IOException ioe) {
                throw new DecodeException(message, sm.getString("pojoMessageHandlerWhole.decodeIoFail"), (Throwable)ioe);
            }
        }
        return null;
    }

    @Override
    protected Object convert(String message) {
        return new StringReader(message);
    }

    @Override
    protected void onClose() {
        for (Decoder decoder : this.decoders) {
            decoder.destroy();
        }
    }
}

