/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.websocket.server;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.net.AbstractEndpoint;
import com.bes.enterprise.web.util.net.SocketWrapperBase;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.web.websocket.Transformation;
import com.bes.enterprise.web.websocket.WsRemoteEndpointImplBase;
import com.bes.enterprise.web.websocket.server.WsServerContainer;
import com.bes.enterprise.web.websocket.server.WsWriteTimeout;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;

public class WsRemoteEndpointImplServer
extends WsRemoteEndpointImplBase {
    private static final StringManager sm = StringManager.getManager(WsRemoteEndpointImplServer.class);
    private final Log log = LogFactory.getLog(WsRemoteEndpointImplServer.class);
    private final SocketWrapperBase<?> socketWrapper;
    private final WsWriteTimeout wsWriteTimeout;
    private volatile SendHandler handler = null;
    private volatile ByteBuffer[] buffers = null;
    private volatile long timeoutExpiry = -1L;

    public WsRemoteEndpointImplServer(SocketWrapperBase<?> socketWrapper, WsServerContainer serverContainer) {
        this.socketWrapper = socketWrapper;
        this.wsWriteTimeout = serverContainer.getTimeout();
    }

    @Override
    protected final boolean isMasked() {
        return false;
    }

    @Override
    protected void doWrite(SendHandler handler, long blockingWriteTimeoutExpiry, ByteBuffer ... buffers) {
        if (blockingWriteTimeoutExpiry == -1L) {
            this.handler = handler;
            this.buffers = buffers;
            this.onWritePossible(true);
        } else {
            try {
                for (ByteBuffer buffer : buffers) {
                    long timeout = blockingWriteTimeoutExpiry - System.currentTimeMillis();
                    if (timeout <= 0L) {
                        SendResult sr = new SendResult(new SocketTimeoutException());
                        handler.onResult(sr);
                        return;
                    }
                    this.socketWrapper.setWriteTimeout(timeout);
                    this.socketWrapper.write(true, buffer);
                }
                long timeout = blockingWriteTimeoutExpiry - System.currentTimeMillis();
                if (timeout <= 0L) {
                    SendResult sr = new SendResult(new SocketTimeoutException());
                    handler.onResult(sr);
                    return;
                }
                this.socketWrapper.setWriteTimeout(timeout);
                this.socketWrapper.flush(true);
                handler.onResult(SENDRESULT_OK);
            }
            catch (IOException e2) {
                SendResult sr = new SendResult(e2);
                handler.onResult(sr);
            }
        }
    }

    public void onWritePossible(boolean useDispatch) {
        long timeout;
        ByteBuffer[] buffers = this.buffers;
        if (buffers == null) {
            return;
        }
        boolean complete = false;
        try {
            this.socketWrapper.flush(false);
            while (this.socketWrapper.isReadyForWrite()) {
                complete = true;
                for (ByteBuffer buffer : buffers) {
                    if (!buffer.hasRemaining()) continue;
                    complete = false;
                    this.socketWrapper.write(false, buffer);
                    break;
                }
                if (!complete) continue;
                this.socketWrapper.flush(false);
                complete = this.socketWrapper.isReadyForWrite();
                if (complete) {
                    this.wsWriteTimeout.unregister(this);
                    this.clearHandler(null, useDispatch);
                }
                break;
            }
        }
        catch (IOException | IllegalStateException e2) {
            this.wsWriteTimeout.unregister(this);
            this.clearHandler(e2, useDispatch);
            this.close();
        }
        if (!complete && (timeout = this.getSendTimeout()) > 0L) {
            this.timeoutExpiry = timeout + System.currentTimeMillis();
            this.wsWriteTimeout.register(this);
        }
    }

    @Override
    protected void doClose() {
        block3: {
            if (this.handler != null) {
                this.clearHandler(new EOFException(), true);
            }
            try {
                this.socketWrapper.close();
            }
            catch (Exception e2) {
                if (!this.log.isInfoEnabled()) break block3;
                this.log.info(sm.getString("wsRemoteEndpointServer.closeFailed"), e2);
            }
        }
        this.wsWriteTimeout.unregister(this);
    }

    protected long getTimeoutExpiry() {
        return this.timeoutExpiry;
    }

    protected void onTimeout(boolean useDispatch) {
        if (this.handler != null) {
            this.clearHandler(new SocketTimeoutException(), useDispatch);
        }
        this.close();
    }

    @Override
    protected void setTransformation(Transformation transformation) {
        super.setTransformation(transformation);
    }

    private void clearHandler(Throwable t2, boolean useDispatch) {
        SendHandler sh = this.handler;
        this.handler = null;
        this.buffers = null;
        if (sh != null) {
            if (useDispatch) {
                OnResultRunnable r2 = new OnResultRunnable(sh, t2);
                AbstractEndpoint<?> endpoint = this.socketWrapper.getEndpoint();
                Executor containerExecutor = endpoint.getExecutor();
                if (endpoint.isRunning() && containerExecutor != null) {
                    containerExecutor.execute(r2);
                } else {
                    r2.run();
                }
            } else if (t2 == null) {
                sh.onResult(new SendResult());
            } else {
                sh.onResult(new SendResult(t2));
            }
        }
    }

    private static class OnResultRunnable
    implements Runnable {
        private final SendHandler sh;
        private final Throwable t;

        private OnResultRunnable(SendHandler sh, Throwable t2) {
            this.sh = sh;
            this.t = t2;
        }

        @Override
        public void run() {
            if (this.t == null) {
                this.sh.onResult(new SendResult());
            } else {
                this.sh.onResult(new SendResult(this.t));
            }
        }
    }
}

