/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.authenticator;

import com.bes.enterprise.webtier.Authenticator;
import com.bes.enterprise.webtier.Context;
import com.bes.enterprise.webtier.Manager;
import com.bes.enterprise.webtier.Session;
import com.bes.enterprise.webtier.SessionEvent;
import com.bes.enterprise.webtier.SessionListener;
import com.bes.enterprise.webtier.authenticator.AuthenticatorBase;
import com.bes.enterprise.webtier.authenticator.SingleSignOn;
import java.io.Serializable;

public class SingleSignOnListener
implements SessionListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String ssoId;

    public SingleSignOnListener(String ssoId) {
        this.ssoId = ssoId;
    }

    @Override
    public void sessionEvent(SessionEvent event) {
        if (!"destroySession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        Manager manager = session.getManager();
        if (manager == null) {
            return;
        }
        Context context = manager.getContext();
        Authenticator authenticator = context.getAuthenticator();
        if (!(authenticator instanceof AuthenticatorBase)) {
            return;
        }
        SingleSignOn sso = ((AuthenticatorBase)authenticator).sso;
        if (sso == null) {
            return;
        }
        sso.sessionDestroyed(this.ssoId, session);
    }
}

