/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.authenticator.jaspic;

import com.bes.enterprise.web.util.res.StringManager;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.message.MessageInfo;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MessageInfoImpl
implements MessageInfo {
    protected static final StringManager sm = StringManager.getManager(MessageInfoImpl.class);
    public static final String IS_MANDATORY = "javax.security.auth.message.MessagePolicy.isMandatory";
    private final Map<String, Object> map = new HashMap<String, Object>();
    private HttpServletRequest request;
    private HttpServletResponse response;

    public MessageInfoImpl() {
    }

    public MessageInfoImpl(HttpServletRequest request, HttpServletResponse response, boolean authMandatory) {
        this.request = request;
        this.response = response;
        this.map.put(IS_MANDATORY, Boolean.toString(authMandatory));
    }

    @Override
    public Map getMap() {
        return this.map;
    }

    @Override
    public Object getRequestMessage() {
        return this.request;
    }

    @Override
    public Object getResponseMessage() {
        return this.response;
    }

    @Override
    public void setRequestMessage(Object request) {
        if (!(request instanceof HttpServletRequest)) {
            throw new IllegalArgumentException(sm.getString("authenticator.jaspic.badRequestType", request.getClass().getName()));
        }
        this.request = (HttpServletRequest)request;
    }

    @Override
    public void setResponseMessage(Object response) {
        if (!(response instanceof HttpServletResponse)) {
            throw new IllegalArgumentException(sm.getString("authenticator.jaspic.badResponseType", response.getClass().getName()));
        }
        this.response = (HttpServletResponse)response;
    }
}

