/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.connector;

import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.connector.InputBuffer;
import com.bes.enterprise.webtier.security.SecurityUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;

public class CoyoteInputStream
extends ServletInputStream {
    protected static final StringManager sm = StringManager.getManager(CoyoteInputStream.class);
    protected InputBuffer ib;

    protected CoyoteInputStream(InputBuffer ib) {
        this.ib = ib;
    }

    void clear() {
        this.ib = null;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public int read() throws IOException {
        this.checkNonBlockingRead();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer result = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer integer = CoyoteInputStream.this.ib.readByte();
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e2 = pae.getException();
                if (e2 instanceof IOException) {
                    throw (IOException)e2;
                }
                throw new RuntimeException(e2.getMessage(), e2);
            }
        }
        return this.ib.readByte();
    }

    @Override
    public int available() throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer result = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer integer = CoyoteInputStream.this.ib.available();
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e2 = pae.getException();
                if (e2 instanceof IOException) {
                    throw (IOException)e2;
                }
                throw new RuntimeException(e2.getMessage(), e2);
            }
        }
        return this.ib.available();
    }

    @Override
    public int read(final byte[] b2) throws IOException {
        this.checkNonBlockingRead();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer result = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer integer = CoyoteInputStream.this.ib.read(b2, 0, b2.length);
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e2 = pae.getException();
                if (e2 instanceof IOException) {
                    throw (IOException)e2;
                }
                throw new RuntimeException(e2.getMessage(), e2);
            }
        }
        return this.ib.read(b2, 0, b2.length);
    }

    @Override
    public int read(final byte[] b2, final int off, final int len) throws IOException {
        this.checkNonBlockingRead();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer result = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer integer = CoyoteInputStream.this.ib.read(b2, off, len);
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e2 = pae.getException();
                if (e2 instanceof IOException) {
                    throw (IOException)e2;
                }
                throw new RuntimeException(e2.getMessage(), e2);
            }
        }
        return this.ib.read(b2, off, len);
    }

    public int read(final ByteBuffer b2) throws IOException {
        this.checkNonBlockingRead();
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                Integer result = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws IOException {
                        Integer integer = CoyoteInputStream.this.ib.read(b2);
                        return integer;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException pae) {
                Exception e2 = pae.getException();
                if (e2 instanceof IOException) {
                    throw (IOException)e2;
                }
                throw new RuntimeException(e2.getMessage(), e2);
            }
        }
        return this.ib.read(b2);
    }

    @Override
    public int readLine(byte[] b2, int off, int len) throws IOException {
        return super.readLine(b2, off, len);
    }

    @Override
    public void close() throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        CoyoteInputStream.this.ib.close();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Exception e2 = pae.getException();
                if (e2 instanceof IOException) {
                    throw (IOException)e2;
                }
                throw new RuntimeException(e2.getMessage(), e2);
            }
        } else {
            this.ib.close();
        }
    }

    @Override
    public boolean isFinished() {
        return this.ib.isFinished();
    }

    @Override
    public boolean isReady() {
        return this.ib.isReady();
    }

    @Override
    public void setReadListener(ReadListener listener) {
        this.ib.setReadListener(listener);
    }

    private void checkNonBlockingRead() {
        if (!this.ib.isBlocking() && !this.ib.isReady()) {
            throw new IllegalStateException(sm.getString("coyoteInputStream.nbNotready"));
        }
    }
}

