/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.connector;

import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.connector.OutputBuffer;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;

public class CoyoteOutputStream
extends ServletOutputStream {
    protected static final StringManager sm = StringManager.getManager(CoyoteOutputStream.class);
    protected OutputBuffer ob;

    protected CoyoteOutputStream(OutputBuffer ob) {
        this.ob = ob;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    void clear() {
        this.ob = null;
    }

    @Override
    public void write(int i2) throws IOException {
        boolean nonBlocking = this.checkNonBlockingWrite();
        this.ob.writeByte(i2);
        if (nonBlocking) {
            this.checkRegisterForWrite();
        }
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        boolean nonBlocking = this.checkNonBlockingWrite();
        this.ob.write(b2, off, len);
        if (nonBlocking) {
            this.checkRegisterForWrite();
        }
    }

    @Override
    public void flush() throws IOException {
        boolean nonBlocking = this.checkNonBlockingWrite();
        this.ob.flush();
        if (nonBlocking) {
            this.checkRegisterForWrite();
        }
    }

    private boolean checkNonBlockingWrite() {
        boolean nonBlocking;
        boolean bl = nonBlocking = !this.ob.isBlocking();
        if (nonBlocking && !this.ob.isReady()) {
            throw new IllegalStateException(sm.getString("coyoteOutputStream.nbNotready"));
        }
        return nonBlocking;
    }

    private void checkRegisterForWrite() {
        this.ob.checkRegisterForWrite();
    }

    @Override
    public void close() throws IOException {
        this.ob.close();
    }

    @Override
    public boolean isReady() {
        return this.ob.isReady();
    }

    @Override
    public void setWriteListener(WriteListener listener) {
        this.ob.setWriteListener(listener);
    }
}

