/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.connector;

import com.bes.enterprise.web.crane.ActionCode;
import com.bes.enterprise.web.crane.CloseNowException;
import com.bes.enterprise.web.crane.Response;
import com.bes.enterprise.web.util.buf.B2CConverter;
import com.bes.enterprise.web.util.buf.ByteChunk;
import com.bes.enterprise.web.util.buf.C2BConverter;
import com.bes.enterprise.web.util.buf.CharChunk;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.Globals;
import com.bes.enterprise.webtier.connector.ClientAbortException;
import com.bes.enterprise.webtier.connector.Request;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.WriteListener;

public class OutputBuffer
extends Writer
implements ByteChunk.ByteOutputChannel,
CharChunk.CharOutputChannel {
    private static final StringManager sm = StringManager.getManager(OutputBuffer.class);
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private final Map<Charset, C2BConverter> encoders = new HashMap<Charset, C2BConverter>();
    private final ByteChunk bb;
    private final CharChunk cb;
    private boolean initial = true;
    private long bytesWritten = 0L;
    private long charsWritten = 0L;
    private volatile boolean closed = false;
    private boolean doFlush = false;
    private final ByteChunk outputChunk = new ByteChunk();
    private CharChunk outputCharChunk = new CharChunk();
    private String enc;
    protected C2BConverter conv;
    private Response coyoteResponse;
    private volatile boolean suspended = false;

    public OutputBuffer() {
        this(8192);
    }

    public OutputBuffer(int size) {
        this.bb = new ByteChunk(size);
        this.bb.setLimit(size);
        this.bb.setByteOutputChannel(this);
        this.cb = new CharChunk(size);
        this.cb.setLimit(size);
        this.cb.setOptimizedWrite(false);
        this.cb.setCharOutputChannel(this);
    }

    public void setResponse(Response coyoteResponse) {
        this.coyoteResponse = coyoteResponse;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void recycle() {
        this.initial = true;
        this.bytesWritten = 0L;
        this.charsWritten = 0L;
        this.bb.recycle();
        this.cb.recycle();
        this.outputCharChunk.setChars(null, 0, 0);
        this.closed = false;
        this.suspended = false;
        this.doFlush = false;
        if (this.conv != null) {
            this.conv.recycle();
            this.conv = null;
        }
        this.enc = null;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.suspended) {
            return;
        }
        if (this.cb.getLength() > 0) {
            this.cb.flushBuffer();
        }
        if (!(this.coyoteResponse.isCommitted() || this.coyoteResponse.getContentLengthLong() != -1L || this.coyoteResponse.getRequest().method().equals("HEAD") || this.coyoteResponse.isCommitted())) {
            this.coyoteResponse.setContentLength(this.bb.getLength());
        }
        if (this.coyoteResponse.getStatus() == 101) {
            this.doFlush(true);
        } else {
            this.doFlush(false);
        }
        this.closed = true;
        Request req = (Request)this.coyoteResponse.getRequest().getNote(1);
        req.inputBuffer.close();
        this.coyoteResponse.action(ActionCode.CLOSE, null);
    }

    @Override
    public void flush() throws IOException {
        this.doFlush(true);
    }

    protected void doFlush(boolean realFlush) throws IOException {
        if (this.suspended) {
            return;
        }
        try {
            this.doFlush = true;
            if (this.initial) {
                this.coyoteResponse.sendHeaders();
                this.initial = false;
            }
            if (this.cb.getLength() > 0) {
                this.cb.flushBuffer();
            }
            if (this.bb.getLength() > 0) {
                this.bb.flushBuffer();
            }
        }
        finally {
            this.doFlush = false;
        }
        if (realFlush) {
            this.coyoteResponse.action(ActionCode.CLIENT_FLUSH, null);
            if (this.coyoteResponse.isExceptionPresent()) {
                throw new ClientAbortException(this.coyoteResponse.getErrorException());
            }
        }
    }

    @Override
    public void realWriteBytes(byte[] buf, int off, int cnt) throws IOException {
        if (this.closed) {
            return;
        }
        if (this.coyoteResponse == null) {
            return;
        }
        if (cnt > 0) {
            this.outputChunk.setBytes(buf, off, cnt);
            try {
                this.coyoteResponse.doWrite(this.outputChunk);
            }
            catch (CloseNowException e2) {
                this.closed = true;
                throw e2;
            }
            catch (IOException e3) {
                throw new ClientAbortException(e3);
            }
        }
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        this.writeBytes(b2, off, len);
    }

    private void writeBytes(byte[] b2, int off, int len) throws IOException {
        if (this.closed) {
            return;
        }
        this.bb.append(b2, off, len);
        this.bytesWritten += (long)len;
        if (this.doFlush) {
            this.bb.flushBuffer();
        }
    }

    public void writeByte(int b2) throws IOException {
        if (this.suspended) {
            return;
        }
        this.bb.append((byte)b2);
        ++this.bytesWritten;
    }

    @Override
    public void realWriteChars(char[] buf, int off, int len) throws IOException {
        this.outputCharChunk.setChars(buf, off, len);
        while (this.outputCharChunk.getLength() > 0) {
            this.conv.convert(this.outputCharChunk, this.bb);
            if (this.bb.getLength() == 0) break;
            if (this.outputCharChunk.getLength() > 0) {
                if (this.bb.getBuffer().length == this.bb.getEnd() && this.bb.getLength() < this.bb.getLimit()) {
                    this.bb.makeSpace(this.outputCharChunk.getLength());
                    continue;
                }
                this.bb.flushBuffer();
                continue;
            }
            if (!this.conv.isUndeflow() || this.bb.getEnd() <= this.bb.getBuffer().length - 4) continue;
            this.bb.flushBuffer();
        }
    }

    @Override
    public void write(int c2) throws IOException {
        if (this.suspended) {
            return;
        }
        this.cb.append((char)c2);
        ++this.charsWritten;
    }

    @Override
    public void write(char[] c2) throws IOException {
        if (this.suspended) {
            return;
        }
        this.write(c2, 0, c2.length);
    }

    @Override
    public void write(char[] c2, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        this.cb.append(c2, off, len);
        this.charsWritten += (long)len;
    }

    @Override
    public void write(String s2, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        if (s2 == null) {
            throw new NullPointerException(sm.getString("outputBuffer.writeNull"));
        }
        this.cb.append(s2, off, len);
        this.charsWritten += (long)len;
    }

    @Override
    public void write(String s2) throws IOException {
        if (this.suspended) {
            return;
        }
        if (s2 == null) {
            s2 = "null";
        }
        this.cb.append(s2);
        this.charsWritten += (long)s2.length();
    }

    public void setEncoding(String s2) {
        this.enc = s2;
    }

    public void checkConverter() throws IOException {
        if (this.conv == null) {
            this.setConverter();
        }
    }

    private void setConverter() throws IOException {
        if (this.coyoteResponse != null) {
            this.enc = this.coyoteResponse.getCharacterEncoding();
        }
        if (this.enc == null) {
            this.enc = "ISO-8859-1";
        }
        Charset charset = OutputBuffer.getCharset(this.enc);
        this.conv = this.encoders.get(charset);
        if (this.conv == null) {
            this.conv = OutputBuffer.createConverter(charset);
            this.encoders.put(charset, this.conv);
        }
    }

    private static Charset getCharset(final String encoding) throws IOException {
        if (Globals.IS_SECURITY_ENABLED) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Charset>(){

                    @Override
                    public Charset run() throws IOException {
                        return B2CConverter.getCharset(encoding);
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                Exception e2 = ex.getException();
                if (e2 instanceof IOException) {
                    throw (IOException)e2;
                }
                throw new IOException(ex);
            }
        }
        return B2CConverter.getCharset(encoding);
    }

    private static C2BConverter createConverter(final Charset charset) throws IOException {
        if (Globals.IS_SECURITY_ENABLED) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<C2BConverter>(){

                    @Override
                    public C2BConverter run() throws IOException {
                        return new C2BConverter(charset);
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                Exception e2 = ex.getException();
                if (e2 instanceof IOException) {
                    throw (IOException)e2;
                }
                throw new IOException(ex);
            }
        }
        return new C2BConverter(charset);
    }

    public long getContentWritten() {
        return this.bytesWritten + this.charsWritten;
    }

    public boolean isNew() {
        return this.bytesWritten == 0L && this.charsWritten == 0L;
    }

    public void setBufferSize(int size) {
        if (size > this.bb.getLimit()) {
            this.bb.setLimit(size);
        }
    }

    public void reset() {
        this.reset(false);
    }

    public void reset(boolean resetWriterStreamFlags) {
        this.bb.recycle();
        this.cb.recycle();
        this.bytesWritten = 0L;
        this.charsWritten = 0L;
        if (resetWriterStreamFlags) {
            if (this.conv != null) {
                this.conv.recycle();
            }
            this.conv = null;
            this.enc = null;
        }
        this.initial = true;
    }

    public int getBufferSize() {
        return this.bb.getLimit();
    }

    public boolean isReady() {
        return this.coyoteResponse.isReady();
    }

    public void setWriteListener(WriteListener listener) {
        this.coyoteResponse.setWriteListener(listener);
    }

    public boolean isBlocking() {
        return this.coyoteResponse.getWriteListener() == null;
    }

    public void checkRegisterForWrite() {
        this.coyoteResponse.checkRegisterForWrite();
    }
}

