/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.core;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.ExceptionUtils;
import com.bes.enterprise.web.util.buf.StringCache;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.Context;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.LifecycleState;
import com.bes.enterprise.webtier.Server;
import com.bes.enterprise.webtier.Service;
import com.bes.enterprise.webtier.core.DefaultService;
import com.bes.enterprise.webtier.core.NamingContextListener;
import com.bes.enterprise.webtier.deploy.NamingResourcesImpl;
import com.bes.enterprise.webtier.mbeans.MBeanFactory;
import com.bes.enterprise.webtier.startup.Heaven;
import com.bes.enterprise.webtier.util.ExtensionValidator;
import com.bes.enterprise.webtier.util.LifecycleMBeanBase;
import com.bes.enterprise.webtier.util.ServerInfo;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Random;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;

public final class ApplicationServer
extends LifecycleMBeanBase
implements Server {
    private static final Log log = LogFactory.getLog(ApplicationServer.class);
    private javax.naming.Context globalNamingContext = null;
    private NamingResourcesImpl globalNamingResources = null;
    private final NamingContextListener namingContextListener;
    private int port = 8005;
    private String address = "localhost";
    private Random random = null;
    private Service[] services = new Service[0];
    private final Object servicesLock = new Object();
    private String shutdown = "SHUTDOWN";
    private static final StringManager sm = StringManager.getManager("com.bes.enterprise.webtier.core");
    final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private volatile boolean stopAwait = false;
    private Heaven heaven = null;
    private ClassLoader parentClassLoader = null;
    private volatile Thread awaitThread = null;
    private volatile ServerSocket awaitSocket = null;
    private File heavenHome = null;
    private File heavenBase = null;
    private final Object namingToken = new Object();
    private ObjectName onameStringCache;
    private ObjectName onameMBeanFactory;

    public ApplicationServer() {
        this.globalNamingResources = new NamingResourcesImpl();
        this.globalNamingResources.setContainer(this);
        if (this.isUseNaming()) {
            this.namingContextListener = new NamingContextListener();
            this.addLifecycleListener(this.namingContextListener);
        } else {
            this.namingContextListener = null;
        }
    }

    @Override
    public Object getNamingToken() {
        return this.namingToken;
    }

    @Override
    public javax.naming.Context getGlobalNamingContext() {
        return this.globalNamingContext;
    }

    public void setGlobalNamingContext(javax.naming.Context globalNamingContext) {
        this.globalNamingContext = globalNamingContext;
    }

    @Override
    public NamingResourcesImpl getGlobalNamingResources() {
        return this.globalNamingResources;
    }

    @Override
    public void setGlobalNamingResources(NamingResourcesImpl globalNamingResources) {
        NamingResourcesImpl oldGlobalNamingResources = this.globalNamingResources;
        this.globalNamingResources = globalNamingResources;
        this.globalNamingResources.setContainer(this);
        this.support.firePropertyChange("globalNamingResources", oldGlobalNamingResources, this.globalNamingResources);
    }

    public String getServerInfo() {
        return ServerInfo.getServerInfo();
    }

    public String getServerBuilt() {
        return ServerInfo.getServerBuilt();
    }

    public String getServerNumber() {
        return ServerInfo.getServerNumber();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public String getShutdown() {
        return this.shutdown;
    }

    @Override
    public void setShutdown(String shutdown) {
        this.shutdown = shutdown;
    }

    @Override
    public Heaven getHeaven() {
        return this.heaven;
    }

    @Override
    public void setHeaven(Heaven heaven) {
        this.heaven = heaven;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addService(Service service) {
        service.setServer(this);
        Object object = this.servicesLock;
        synchronized (object) {
            Service[] results = new Service[this.services.length + 1];
            System.arraycopy(this.services, 0, results, 0, this.services.length);
            results[this.services.length] = service;
            this.services = results;
            if (this.getState().isAvailable()) {
                try {
                    service.start();
                }
                catch (LifecycleException lifecycleException) {
                    // empty catch block
                }
            }
            this.support.firePropertyChange("service", null, service);
        }
    }

    public void stopAwait() {
        this.stopAwait = true;
        Thread t2 = this.awaitThread;
        if (t2 != null) {
            ServerSocket s2 = this.awaitSocket;
            if (s2 != null) {
                this.awaitSocket = null;
                try {
                    s2.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            t2.interrupt();
            try {
                t2.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void await() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Service findService(String name) {
        if (name == null) {
            return null;
        }
        Object object = this.servicesLock;
        synchronized (object) {
            for (int i2 = 0; i2 < this.services.length; ++i2) {
                if (!name.equals(this.services[i2].getName())) continue;
                return this.services[i2];
            }
        }
        return null;
    }

    @Override
    public Service[] findServices() {
        return this.services;
    }

    public ObjectName[] getServiceNames() {
        ObjectName[] onames = new ObjectName[this.services.length];
        for (int i2 = 0; i2 < this.services.length; ++i2) {
            onames[i2] = ((DefaultService)this.services[i2]).getObjectName();
        }
        return onames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeService(Service service) {
        Object object = this.servicesLock;
        synchronized (object) {
            int j2 = -1;
            for (int i2 = 0; i2 < this.services.length; ++i2) {
                if (service != this.services[i2]) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            try {
                this.services[j2].stop();
            }
            catch (LifecycleException i2) {
                // empty catch block
            }
            int k2 = 0;
            Service[] results = new Service[this.services.length - 1];
            for (int i3 = 0; i3 < this.services.length; ++i3) {
                if (i3 == j2) continue;
                results[k2++] = this.services[i3];
            }
            this.services = results;
            this.support.firePropertyChange("service", service, null);
        }
    }

    @Override
    public File getHeavenBase() {
        if (this.heavenBase != null) {
            return this.heavenBase;
        }
        this.heavenBase = this.getHeavenHome();
        return this.heavenBase;
    }

    @Override
    public void setHeavenBase(File heavenBase) {
        this.heavenBase = heavenBase;
    }

    @Override
    public File getHeavenHome() {
        return this.heavenHome;
    }

    @Override
    public void setHeavenHome(File heavenHome) {
        this.heavenHome = heavenHome;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ApplicationServer[");
        sb.append(this.getPort());
        sb.append(']');
        return sb.toString();
    }

    public synchronized void storeConfig() throws InstanceNotFoundException, MBeanException {
        try {
            ObjectName sname = new ObjectName("Heaven:type=StoreConfig");
            if (this.mserver.isRegistered(sname)) {
                this.mserver.invoke(sname, "storeConfig", null, null);
            } else {
                log.error(sm.getString("standardServer.storeConfig.notAvailable", sname));
            }
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
            log.error(sm.getString("standardServer.storeConfig.error"), t2);
        }
    }

    public synchronized void storeContext(Context context) throws InstanceNotFoundException, MBeanException {
        try {
            ObjectName sname = new ObjectName("Heaven:type=StoreConfig");
            if (this.mserver.isRegistered(sname)) {
                this.mserver.invoke(sname, "store", new Object[]{context}, new String[]{"java.lang.String"});
            } else {
                log.error(sm.getString("standardServer.storeConfig.notAvailable", sname));
            }
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
            log.error(sm.getString("standardServer.storeConfig.contextError", context.getName()), t2);
        }
    }

    private boolean isUseNaming() {
        boolean useNaming = true;
        String useNamingProperty = System.getProperty("bes.useNaming");
        if (useNamingProperty != null && useNamingProperty.equals("false")) {
            useNaming = false;
        }
        return useNaming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startInternal() throws LifecycleException {
        this.fireLifecycleEvent("configure_start", null);
        this.setState(LifecycleState.STARTING);
        this.globalNamingResources.start();
        Object object = this.servicesLock;
        synchronized (object) {
            for (int i2 = 0; i2 < this.services.length; ++i2) {
                this.services[i2].start();
            }
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        this.fireLifecycleEvent("configure_stop", null);
        for (int i2 = 0; i2 < this.services.length; ++i2) {
            this.services[i2].stop();
        }
        this.globalNamingResources.stop();
        this.stopAwait();
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.onameStringCache = this.register(new StringCache(), "type=StringCache");
        MBeanFactory factory = new MBeanFactory();
        factory.setContainer(this);
        this.onameMBeanFactory = this.register(factory, "type=MBeanFactory");
        this.globalNamingResources.init();
        if (this.getHeaven() != null) {
            for (ClassLoader cl = this.getHeaven().getParentClassLoader(); cl != null && cl != ClassLoader.getSystemClassLoader(); cl = cl.getParent()) {
                URL[] urls;
                if (!(cl instanceof URLClassLoader)) continue;
                for (URL url : urls = ((URLClassLoader)cl).getURLs()) {
                    if (!url.getProtocol().equals("file")) continue;
                    try {
                        File f2 = new File(url.toURI());
                        if (!f2.isFile() || !f2.getName().endsWith(".jar")) continue;
                        ExtensionValidator.addSystemResource(f2);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        for (int i2 = 0; i2 < this.services.length; ++i2) {
            this.services[i2].init();
        }
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        for (int i2 = 0; i2 < this.services.length; ++i2) {
            this.services[i2].destroy();
        }
        this.globalNamingResources.destroy();
        this.unregister(this.onameMBeanFactory);
        this.unregister(this.onameStringCache);
        super.destroyInternal();
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.heaven != null) {
            return this.heaven.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public void setParentClassLoader(ClassLoader parent) {
        ClassLoader oldParentClassLoader = this.parentClassLoader;
        this.parentClassLoader = parent;
        this.support.firePropertyChange("parentClassLoader", oldParentClassLoader, this.parentClassLoader);
    }

    @Override
    protected String getDomainInternal() {
        Service service;
        String domain = null;
        Service[] services = this.findServices();
        if (services.length > 0 && (service = services[0]) != null) {
            domain = service.getDomain();
        }
        return domain;
    }

    @Override
    protected final String getObjectNameKeyProperties() {
        return "type=Server";
    }
}

