/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.core;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.Engine;
import com.bes.enterprise.webtier.Executor;
import com.bes.enterprise.webtier.JmxEnabled;
import com.bes.enterprise.webtier.Lifecycle;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.LifecycleState;
import com.bes.enterprise.webtier.Realm;
import com.bes.enterprise.webtier.Server;
import com.bes.enterprise.webtier.Service;
import com.bes.enterprise.webtier.connector.Connector;
import com.bes.enterprise.webtier.util.LifecycleMBeanBase;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.ObjectName;

public class DefaultService
extends LifecycleMBeanBase
implements Service {
    private static final Log log = LogFactory.getLog(DefaultService.class);
    private final Map<String, Realm> loadedRealms = new HashMap<String, Realm>();
    private final ReadWriteLock realmLock = new ReentrantReadWriteLock();
    private String name = null;
    private static final StringManager sm = StringManager.getManager("com.bes.enterprise.webtier.core");
    private Server server = null;
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected Connector[] connectors = new Connector[0];
    private final Object connectorsLock = new Object();
    protected final ArrayList<Executor> executors = new ArrayList();
    private Engine engine = null;
    private ClassLoader parentClassLoader = null;

    @Override
    public Engine getContainer() {
        return this.engine;
    }

    @Override
    public void setContainer(Engine engine) {
        Engine oldEngine = this.engine;
        if (oldEngine != null) {
            oldEngine.setService(null);
        }
        this.engine = engine;
        if (this.engine != null) {
            this.engine.setService(this);
        }
        if (this.getState().isAvailable()) {
            if (this.engine != null) {
                try {
                    this.engine.start();
                }
                catch (LifecycleException e2) {
                    log.error(sm.getString("standardService.engine.startFailed"), e2);
                }
            }
            if (oldEngine != null) {
                try {
                    oldEngine.stop();
                }
                catch (LifecycleException e3) {
                    log.error(sm.getString("standardService.engine.stopFailed"), e3);
                }
            }
        }
        this.support.firePropertyChange("container", oldEngine, this.engine);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public void setServer(Server server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnector(Connector connector) {
        Object object = this.connectorsLock;
        synchronized (object) {
            connector.setService(this);
            Connector[] results = new Connector[this.connectors.length + 1];
            System.arraycopy(this.connectors, 0, results, 0, this.connectors.length);
            results[this.connectors.length] = connector;
            this.connectors = results;
            if (this.getState().isAvailable()) {
                try {
                    connector.start();
                }
                catch (LifecycleException e2) {
                    log.error(sm.getString("standardService.connector.startFailed", connector), e2);
                }
            }
            this.support.firePropertyChange("connector", null, connector);
        }
    }

    public ObjectName[] getConnectorNames() {
        ObjectName[] results = new ObjectName[this.connectors.length];
        for (int i2 = 0; i2 < results.length; ++i2) {
            results[i2] = this.connectors[i2].getObjectName();
        }
        return results;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public Connector[] findConnectors() {
        return this.connectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnector(Connector connector) {
        Object object = this.connectorsLock;
        synchronized (object) {
            int j2 = -1;
            for (int i2 = 0; i2 < this.connectors.length; ++i2) {
                if (connector != this.connectors[i2]) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (this.connectors[j2].getState().isAvailable()) {
                try {
                    this.connectors[j2].stop();
                }
                catch (LifecycleException e2) {
                    log.error(sm.getString("standardService.connector.stopFailed", this.connectors[j2]), e2);
                }
            }
            connector.setService(null);
            int k2 = 0;
            Connector[] results = new Connector[this.connectors.length - 1];
            for (int i3 = 0; i3 < this.connectors.length; ++i3) {
                if (i3 == j2) continue;
                results[k2++] = this.connectors[i3];
            }
            this.connectors = results;
            this.support.firePropertyChange("connector", connector, null);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultService[");
        sb.append(this.getName());
        sb.append(']');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExecutor(Executor ex) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            if (!this.executors.contains(ex)) {
                this.executors.add(ex);
                if (this.getState().isAvailable()) {
                    try {
                        ex.start();
                    }
                    catch (LifecycleException x2) {
                        log.error("Executor.start", x2);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Executor[] findExecutors() {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            Executor[] arr = new Executor[this.executors.size()];
            this.executors.toArray(arr);
            return arr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Executor getExecutor(String executorName) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            for (Executor executor : this.executors) {
                if (!executorName.equals(executor.getName())) continue;
                return executor;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExecutor(Executor ex) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            if (this.executors.remove(ex) && this.getState().isAvailable()) {
                try {
                    ex.stop();
                }
                catch (LifecycleException e2) {
                    log.error("Executor.stop", e2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startInternal() throws LifecycleException {
        if (log.isInfoEnabled()) {
            log.info(sm.getString("standardService.start.name", this.name));
        }
        this.setState(LifecycleState.STARTING);
        if (this.engine != null) {
            Engine engine = this.engine;
            synchronized (engine) {
                this.engine.start();
            }
        }
        Map<String, Realm> realms = this.getRealms();
        for (Realm realm : realms.values()) {
            if (realm == null || !(realm instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)realm)).start();
        }
        Object object = this.executors;
        synchronized (object) {
            for (Executor executor : this.executors) {
                executor.start();
            }
        }
        object = this.connectorsLock;
        synchronized (object) {
            for (Connector connector : this.connectors) {
                try {
                    if (connector.getState() == LifecycleState.FAILED) continue;
                    connector.start();
                }
                catch (Exception e2) {
                    log.error(sm.getString("standardService.connector.startFailed", connector), e2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stopInternal() throws LifecycleException {
        ArrayList<Executor> arrayList = this.connectorsLock;
        synchronized (arrayList) {
            for (Connector connector : this.connectors) {
                try {
                    connector.pause();
                }
                catch (Exception e2) {
                    log.error(sm.getString("standardService.connector.pauseFailed", connector), e2);
                }
                connector.getProtocolHandler().closeServerSocketGraceful();
            }
        }
        if (log.isInfoEnabled()) {
            log.info(sm.getString("standardService.stop.name", this.name));
        }
        this.setState(LifecycleState.STOPPING);
        if (this.engine != null) {
            arrayList = this.engine;
            synchronized (arrayList) {
                this.engine.stop();
            }
        }
        arrayList = this.connectorsLock;
        synchronized (arrayList) {
            for (Connector connector : this.connectors) {
                if (!LifecycleState.STARTED.equals((Object)connector.getState())) continue;
                try {
                    connector.stop();
                }
                catch (Exception e3) {
                    log.error(sm.getString("standardService.connector.stopFailed", connector), e3);
                }
            }
        }
        arrayList = this.executors;
        synchronized (arrayList) {
            for (Executor executor : this.executors) {
                executor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (this.engine != null) {
            this.engine.init();
        }
        for (Executor executor : this.findExecutors()) {
            if (executor instanceof JmxEnabled) {
                ((JmxEnabled)((Object)executor)).setDomain(this.getDomain());
            }
            executor.init();
        }
        Object object = this.connectorsLock;
        synchronized (object) {
            for (Connector connector : this.connectors) {
                try {
                    connector.init();
                }
                catch (Exception e2) {
                    String message = sm.getString("standardService.connector.initFailed", connector);
                    log.error(message, e2);
                    if (!Boolean.getBoolean("com.bes.enterprise.startup.ExitOnInitFailure")) continue;
                    throw new LifecycleException(message);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroyInternal() throws LifecycleException {
        Executor[] executorArray = this.connectorsLock;
        synchronized (this.connectorsLock) {
            Connector[] connectorArray = this.connectors;
            int n2 = connectorArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Connector connector = connectorArray[i2];
                try {
                    connector.destroy();
                    continue;
                }
                catch (Exception e2) {
                    log.error(sm.getString("standardService.connector.destroyFailed", connector), e2);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (Executor executor : this.findExecutors()) {
                executor.destroy();
            }
            if (this.engine != null) {
                this.engine.destroy();
            }
            super.destroyInternal();
            return;
        }
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.server != null) {
            return this.server.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public void setParentClassLoader(ClassLoader parent) {
        ClassLoader oldParentClassLoader = this.parentClassLoader;
        this.parentClassLoader = parent;
        this.support.firePropertyChange("parentClassLoader", oldParentClassLoader, this.parentClassLoader);
    }

    @Override
    protected String getDomainInternal() {
        String domain = null;
        Engine engine = this.getContainer();
        if (engine != null) {
            domain = engine.getName();
        }
        if (domain == null) {
            domain = this.getName();
        }
        return domain;
    }

    @Override
    public final String getObjectNameKeyProperties() {
        return "type=Service";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putIntoLoadedRealms(String realmName, Realm realm) {
        Lock l2 = this.realmLock.writeLock();
        l2.lock();
        try {
            Realm oldRealm = this.loadedRealms.get(realmName);
            if (oldRealm == realm) {
                return;
            }
            this.loadedRealms.put(realmName, realm);
            if (oldRealm != null && this.getState().isAvailable() && oldRealm != null && oldRealm instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)oldRealm)).stop();
                }
                catch (LifecycleException e2) {
                    log.error("ContainerBase.setRealm: stop: ", e2);
                }
            }
            if (realm != null) {
                realm.setContainer(this.engine);
            }
            if (this.getState().isAvailable() && realm != null && realm instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)realm)).start();
                }
                catch (LifecycleException e3) {
                    log.error("ContainerBase.setRealm: start: ", e3);
                }
            }
        }
        finally {
            l2.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Realm removeFromLoadedRealms(String realmName) {
        Realm oldRealm = null;
        Lock l2 = this.realmLock.writeLock();
        l2.lock();
        try {
            oldRealm = this.loadedRealms.remove(realmName);
            if (oldRealm != null && this.getState().isAvailable() && oldRealm != null && oldRealm instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)oldRealm)).stop();
                }
                catch (LifecycleException e2) {
                    log.error("ContainerBase.setRealm: stop: ", e2);
                }
            }
        }
        finally {
            l2.unlock();
        }
        return oldRealm;
    }

    public Map<String, Realm> getRealms() {
        Lock l2 = this.realmLock.readLock();
        l2.lock();
        try {
            Map<String, Realm> map = this.loadedRealms;
            return map;
        }
        finally {
            l2.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Realm getRealm(String realmName) {
        Lock l2 = this.realmLock.readLock();
        l2.lock();
        try {
            Realm realm = this.loadedRealms.get(realmName);
            return realm;
        }
        finally {
            l2.unlock();
        }
    }
}

