/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.core;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.webtier.LifecycleEvent;
import com.bes.enterprise.webtier.LifecycleListener;

public class JniLifecycleListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(JniLifecycleListener.class);
    private String libraryName = "";
    private String libraryPath = "";

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("before_start".equals(event.getType())) {
            if (!this.libraryName.isEmpty()) {
                System.loadLibrary(this.libraryName);
                log.info("Loaded native library " + this.libraryName);
            } else if (!this.libraryPath.isEmpty()) {
                System.load(this.libraryPath);
                log.info("Loaded native library from " + this.libraryPath);
            } else {
                throw new IllegalArgumentException("Either libraryName or libraryPath must be set");
            }
        }
    }

    public void setLibraryName(String libraryName) {
        if (!this.libraryPath.isEmpty()) {
            throw new IllegalArgumentException("Either libraryName or libraryPath may be set, not both.");
        }
        this.libraryName = libraryName;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public void setLibraryPath(String libraryPath) {
        if (!this.libraryName.isEmpty()) {
            throw new IllegalArgumentException("Either libraryName or libraryPath may be set, not both.");
        }
        this.libraryPath = libraryPath;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }
}

