/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.core;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.jni.Library;
import com.bes.enterprise.web.jni.LibraryNotFoundError;
import com.bes.enterprise.web.jni.SSL;
import com.bes.enterprise.web.util.ExceptionUtils;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.LifecycleEvent;
import com.bes.enterprise.webtier.LifecycleListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class NativeLifecycleListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(NativeLifecycleListener.class);
    private static boolean instanceCreated = false;
    private static final List<String> initInfoLogMessages = new ArrayList<String>(3);
    protected static final StringManager sm = StringManager.getManager("com.bes.enterprise.webtier.core");
    protected static final int TCN_REQUIRED_MAJOR = 1;
    protected static final int TCN_REQUIRED_MINOR = 2;
    protected static final int TCN_REQUIRED_PATCH = 14;
    protected static final int TCN_RECOMMENDED_MINOR = 2;
    protected static final int TCN_RECOMMENDED_PV = 23;
    protected static String SSLEngine = "on";
    protected static String FIPSMode = "off";
    protected static String SSLRandomSeed = "builtin";
    protected static boolean sslInitialized = false;
    protected static boolean nativeInitialized = false;
    protected static boolean nativeAvailable = false;
    protected static boolean useNativeConnector = false;
    protected static boolean useOpenSSL = true;
    protected static boolean fipsModeActive = false;
    private static final int FIPS_ON = 1;
    private static final int FIPS_OFF = 0;
    protected static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNativeAvailable() {
        if (instanceCreated) {
            Object object = lock;
            synchronized (object) {
                NativeLifecycleListener.init();
            }
        }
        return nativeAvailable;
    }

    public NativeLifecycleListener() {
        instanceCreated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("before_init".equals(event.getType())) {
            Object object = lock;
            synchronized (object) {
                NativeLifecycleListener.init();
                for (String msg : initInfoLogMessages) {
                    log.info(msg);
                }
                initInfoLogMessages.clear();
                if (nativeAvailable) {
                    try {
                        NativeLifecycleListener.initializeSSL();
                    }
                    catch (Throwable t2) {
                        t2 = ExceptionUtils.unwrapInvocationTargetException(t2);
                        ExceptionUtils.handleThrowable(t2);
                        log.error(sm.getString("aprListener.sslInit"), t2);
                    }
                }
                if (null != FIPSMode && !"off".equalsIgnoreCase(FIPSMode) && !this.isFIPSModeActive()) {
                    String errorMessage = sm.getString("aprListener.initializeFIPSFailed");
                    Error e2 = new Error(errorMessage);
                    log.fatal(errorMessage, e2);
                    throw e2;
                }
            }
        }
        if ("after_destroy".equals(event.getType())) {
            Object object = lock;
            synchronized (object) {
                if (!nativeAvailable) {
                    return;
                }
                try {
                    NativeLifecycleListener.terminateNative();
                }
                catch (Throwable t3) {
                    t3 = ExceptionUtils.unwrapInvocationTargetException(t3);
                    ExceptionUtils.handleThrowable(t3);
                    log.info(sm.getString("aprListener.nativeDestroy"));
                }
            }
        }
    }

    private static void terminateNative() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String methodName = "terminate";
        Method method = Class.forName("com.bes.enterprise.web.jni.Library").getMethod(methodName, null);
        method.invoke(null, (Object[])null);
        nativeAvailable = false;
        nativeInitialized = false;
        sslInitialized = false;
        fipsModeActive = false;
    }

    private static void init() {
        int major = 0;
        int minor = 0;
        int patch = 0;
        int apver = 0;
        int rqver = 1214;
        int rcver = 1223;
        if (nativeInitialized) {
            return;
        }
        nativeInitialized = true;
        try {
            Library.initialize(null);
            major = Library.TCN_MAJOR_VERSION;
            minor = Library.TCN_MINOR_VERSION;
            patch = Library.TCN_PATCH_VERSION;
            apver = major * 1000 + minor * 100 + patch;
        }
        catch (LibraryNotFoundError lnfe) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("aprListener.nativeInitDebug", lnfe.getLibraryNames(), System.getProperty("java.library.path"), lnfe.getMessage()), lnfe);
            }
            initInfoLogMessages.add(sm.getString("aprListener.nativeInit", System.getProperty("java.library.path")));
            return;
        }
        catch (Throwable t2) {
            t2 = ExceptionUtils.unwrapInvocationTargetException(t2);
            ExceptionUtils.handleThrowable(t2);
            log.warn(sm.getString("aprListener.nativeInitError", t2.getMessage()), t2);
            return;
        }
        if (apver < rqver) {
            log.error(sm.getString("aprListener.tcnInvalid", major + "." + minor + "." + patch, "1.2.14"));
            try {
                NativeLifecycleListener.terminateNative();
            }
            catch (Throwable t3) {
                t3 = ExceptionUtils.unwrapInvocationTargetException(t3);
                ExceptionUtils.handleThrowable(t3);
            }
            return;
        }
        if (apver < rcver) {
            initInfoLogMessages.add(sm.getString("aprListener.tcnVersion", major + "." + minor + "." + patch, "1.2.23"));
        }
        initInfoLogMessages.add(sm.getString("aprListener.tcnValid", major + "." + minor + "." + patch, Library.APR_MAJOR_VERSION + "." + Library.APR_MINOR_VERSION + "." + Library.APR_PATCH_VERSION));
        initInfoLogMessages.add(sm.getString("aprListener.flags", Library.APR_HAVE_IPV6, Library.APR_HAS_SENDFILE, Library.APR_HAS_SO_ACCEPTFILTER, Library.APR_HAS_RANDOM));
        initInfoLogMessages.add(sm.getString("aprListener.config", useNativeConnector, useOpenSSL));
        nativeAvailable = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initializeSSL() throws Exception {
        if ("off".equalsIgnoreCase(SSLEngine)) {
            return;
        }
        if (sslInitialized) {
            return;
        }
        sslInitialized = true;
        String methodName = "randSet";
        Class[] paramTypes = new Class[]{String.class};
        Object[] paramValues = new Object[]{SSLRandomSeed};
        Class<?> clazz = Class.forName("com.bes.enterprise.web.jni.SSL");
        Method method = clazz.getMethod(methodName, paramTypes);
        method.invoke(null, paramValues);
        methodName = "initialize";
        paramValues[0] = "on".equalsIgnoreCase(SSLEngine) ? null : SSLEngine;
        method = clazz.getMethod(methodName, paramTypes);
        method.invoke(null, paramValues);
        if (paramValues[0] == null) {
            log.info(sm.getString("aprListener.initializedOpenSSLWithoutEngineSet"));
        } else {
            log.info(sm.getString("aprListener.initializedOpenSSLWithEngine", paramValues[0]));
        }
        if (null != FIPSMode && !"off".equalsIgnoreCase(FIPSMode)) {
            boolean enterFipsMode;
            fipsModeActive = false;
            int fipsModeState = SSL.fipsModeGet();
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("aprListener.currentFIPSMode", fipsModeState));
            }
            if ("on".equalsIgnoreCase(FIPSMode)) {
                if (fipsModeState == 1) {
                    log.info(sm.getString("aprListener.skipFIPSInitialization"));
                    fipsModeActive = true;
                    enterFipsMode = false;
                } else {
                    enterFipsMode = true;
                }
            } else if ("require".equalsIgnoreCase(FIPSMode)) {
                if (fipsModeState != 1) throw new IllegalStateException(sm.getString("aprListener.requireNotInFIPSMode"));
                fipsModeActive = true;
                enterFipsMode = false;
            } else {
                if (!"enter".equalsIgnoreCase(FIPSMode)) throw new IllegalArgumentException(sm.getString("aprListener.wrongFIPSMode", FIPSMode));
                if (fipsModeState != 0) throw new IllegalStateException(sm.getString("aprListener.enterAlreadyInFIPSMode", fipsModeState));
                enterFipsMode = true;
            }
            if (enterFipsMode) {
                log.info(sm.getString("aprListener.initializingFIPS"));
                fipsModeState = SSL.fipsModeSet(1);
                if (fipsModeState != 1) {
                    String message = sm.getString("aprListener.initializeFIPSFailed");
                    log.error(message);
                    throw new IllegalStateException(message);
                }
                fipsModeActive = true;
                log.info(sm.getString("aprListener.initializeFIPSSuccess"));
            }
        }
        log.info(sm.getString("aprListener.initializedOpenSSL", SSL.versionString()));
    }

    public String getSSLEngine() {
        return SSLEngine;
    }

    public void setSSLEngine(String SSLEngine2) {
        if (!SSLEngine2.equals(SSLEngine)) {
            if (sslInitialized) {
                throw new IllegalStateException(sm.getString("aprListener.tooLateForSSLEngine"));
            }
            SSLEngine = SSLEngine2;
        }
    }

    public String getSSLRandomSeed() {
        return SSLRandomSeed;
    }

    public void setSSLRandomSeed(String SSLRandomSeed) {
        if (!SSLRandomSeed.equals(NativeLifecycleListener.SSLRandomSeed)) {
            if (sslInitialized) {
                throw new IllegalStateException(sm.getString("aprListener.tooLateForSSLRandomSeed"));
            }
            NativeLifecycleListener.SSLRandomSeed = SSLRandomSeed;
        }
    }

    public String getFIPSMode() {
        return FIPSMode;
    }

    public void setFIPSMode(String FIPSMode) {
        if (!FIPSMode.equals(NativeLifecycleListener.FIPSMode)) {
            if (sslInitialized) {
                throw new IllegalStateException(sm.getString("aprListener.tooLateForFIPSMode"));
            }
            NativeLifecycleListener.FIPSMode = FIPSMode;
        }
    }

    public boolean isFIPSModeActive() {
        return fipsModeActive;
    }

    public void setUseNativeConnector(boolean useNativeConnector) {
        if (useNativeConnector != NativeLifecycleListener.useNativeConnector) {
            NativeLifecycleListener.useNativeConnector = useNativeConnector;
        }
    }

    public static boolean getUseNativeConnector() {
        return useNativeConnector;
    }

    public void setUseOpenSSL(boolean useOpenSSL) {
        if (useOpenSSL != NativeLifecycleListener.useOpenSSL) {
            NativeLifecycleListener.useOpenSSL = useOpenSSL;
        }
    }

    public static boolean getUseOpenSSL() {
        return useOpenSSL;
    }

    public static boolean isInstanceCreated() {
        return instanceCreated;
    }
}

