/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.core;

import com.bes.enterprise.web.util.threads.ResizableExecutor;
import com.bes.enterprise.web.util.threads.ThreadPoolExecutor;
import com.bes.enterprise.web.util.threads.WorkQueue;
import com.bes.enterprise.web.util.threads.WorkThreadFactory;
import com.bes.enterprise.web.util.threads.trace.TracedThreadPoolExecutor;
import com.bes.enterprise.web.util.threads.trace.TracedWorkThreadFactory;
import com.bes.enterprise.webtier.Executor;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.LifecycleState;
import com.bes.enterprise.webtier.util.LifecycleMBeanBase;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WorkThreadExecutor
extends LifecycleMBeanBase
implements Executor,
ExecutorService,
ResizableExecutor {
    public static final int standbyPoolSize = Integer.parseInt(System.getProperty("com.bes.enterprise.web.standbyPoolSize", "0"));
    protected int threadPriority = 5;
    protected boolean daemon = true;
    protected String namePrefix = "appServer-exec-";
    protected int maxThreads = 200;
    protected int minSpareThreads = 25;
    protected int maxIdleTime = 60000;
    protected ThreadPoolExecutor executor = null;
    protected String name;
    protected String threadPoolName;
    protected boolean prestartminSpareThreads = false;
    protected int maxQueueSize = Integer.MAX_VALUE;
    protected int enqMaxWaitTime = 5000;
    protected long threadRenewalDelay = 1000L;
    private WorkQueue taskqueue = null;
    public static String DEFAULT_THREAD_POOL_NAME = "unnamed-thread-pool";
    protected boolean usingTrace;

    public boolean isUsingTrace() {
        return this.usingTrace;
    }

    public void setUsingTrace(boolean usingTrace) {
        this.usingTrace = usingTrace;
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
    }

    @Override
    protected void startInternal() throws LifecycleException {
        this.taskqueue = new WorkQueue(this.maxQueueSize);
        String finalName = this.getFinalThreadPoolName();
        if (this.usingTrace) {
            TracedWorkThreadFactory tf = new TracedWorkThreadFactory(finalName, this.name, this.namePrefix, this.daemon, this.getThreadPriority());
            this.executor = new TracedThreadPoolExecutor(finalName, this.getMinSpareThreads(), this.getMaxThreads() + standbyPoolSize, (long)this.maxIdleTime, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)this.taskqueue, tf);
        } else {
            WorkThreadFactory tf = new WorkThreadFactory(this.name, this.namePrefix, this.daemon, this.getThreadPriority());
            this.executor = new ThreadPoolExecutor(this.getMinSpareThreads(), this.getMaxThreads() + standbyPoolSize, (long)this.maxIdleTime, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)this.taskqueue, tf);
        }
        this.executor.setThreadRenewalDelay(this.threadRenewalDelay);
        if (this.prestartminSpareThreads) {
            this.executor.prestartAllCoreThreads();
        }
        this.taskqueue.setParent(this.executor);
        this.setState(LifecycleState.STARTING);
    }

    private String getFinalThreadPoolName() {
        if (this.name != null && !this.name.isEmpty()) {
            return this.name;
        }
        if (this.threadPoolName != null && !this.threadPoolName.isEmpty()) {
            return this.threadPoolName;
        }
        return DEFAULT_THREAD_POOL_NAME;
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.executor = null;
        this.taskqueue = null;
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        super.destroyInternal();
    }

    @Override
    public void execute(Runnable command, long timeout, TimeUnit unit) {
        if (this.executor == null) {
            throw new IllegalStateException("WorkThreadExecutor not started.");
        }
        this.executor.execute(command, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        block9: {
            if (this.executor != null) {
                try {
                    this.executor.execute(command);
                }
                catch (RejectedExecutionException rx) {
                    if (this.enqMaxWaitTime <= 0) {
                        if (!((WorkQueue)this.executor.getQueue()).force(command)) {
                            throw new RejectedExecutionException("The thread pool's work queue is full, limit: " + this.maxQueueSize);
                        }
                        break block9;
                    }
                    try {
                        if (!((WorkQueue)this.executor.getQueue()).force(command, this.enqMaxWaitTime, TimeUnit.MICROSECONDS)) {
                            throw new RejectedExecutionException("The thread pool's work queue is full after wait " + this.enqMaxWaitTime + " ms, limit: " + this.maxQueueSize);
                        }
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(WorkThreadExecutor.class.getName()).log(Level.WARNING, "Interrupted Exception", ex);
                    }
                }
            } else {
                throw new IllegalStateException("StandardThreadPool not started.");
            }
        }
    }

    public void contextStopping() {
        if (this.executor != null) {
            this.executor.contextStopping();
        }
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    @Override
    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getMinSpareThreads() {
        return this.minSpareThreads;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isPrestartminSpareThreads() {
        return this.prestartminSpareThreads;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
        if (this.executor != null) {
            this.executor.setKeepAliveTime(maxIdleTime, TimeUnit.MILLISECONDS);
        }
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        if (this.executor != null) {
            this.executor.setMaximumPoolSize(maxThreads);
        }
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.minSpareThreads = minSpareThreads;
        if (this.executor != null) {
            this.executor.setCorePoolSize(minSpareThreads);
        }
    }

    public void setPrestartminSpareThreads(boolean prestartminSpareThreads) {
        this.prestartminSpareThreads = prestartminSpareThreads;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public void setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
    }

    public void setMaxQueueSize(int size) {
        this.maxQueueSize = size;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public int getEnqMaxWaitTime() {
        return this.enqMaxWaitTime;
    }

    public void setEnqMaxWaitTime(int enqMaxWaitTime) {
        this.enqMaxWaitTime = enqMaxWaitTime;
    }

    public long getThreadRenewalDelay() {
        return this.threadRenewalDelay;
    }

    public void setThreadRenewalDelay(long threadRenewalDelay) {
        this.threadRenewalDelay = threadRenewalDelay;
        if (this.executor != null) {
            this.executor.setThreadRenewalDelay(threadRenewalDelay);
        }
    }

    @Override
    public int getActiveCount() {
        return this.executor != null ? this.executor.getActiveCount() : 0;
    }

    public long getCompletedTaskCount() {
        return this.executor != null ? this.executor.getCompletedTaskCount() : 0L;
    }

    public int getCorePoolSize() {
        return this.executor != null ? this.executor.getCorePoolSize() : 0;
    }

    public int getLargestPoolSize() {
        return this.executor != null ? this.executor.getLargestPoolSize() : 0;
    }

    @Override
    public int getPoolSize() {
        return this.executor != null ? this.executor.getPoolSize() : 0;
    }

    public int getQueueSize() {
        return this.executor != null ? this.executor.getQueue().size() : -1;
    }

    public int getIdleCount() {
        return this.executor != null ? this.executor.getPoolSize() - this.executor.getActiveCount() : 0;
    }

    @Override
    public boolean resizePool(int corePoolSize, int maximumPoolSize) {
        if (this.executor == null) {
            return false;
        }
        this.executor.setCorePoolSize(corePoolSize);
        this.executor.setMaximumPoolSize(maximumPoolSize);
        return true;
    }

    @Override
    public boolean resizeQueue(int capacity) {
        return false;
    }

    public ThreadPoolExecutor getUnderlyingExecutor() {
        return this.executor;
    }

    @Override
    protected String getDomainInternal() {
        return null;
    }

    @Override
    protected String getObjectNameKeyProperties() {
        StringBuilder name = new StringBuilder("type=Executor,name=");
        name.append(this.getName());
        name.append(",threadpool=");
        name.append(this.getThreadPoolName());
        return name.toString();
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.executor.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executor.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.executor.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.executor.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.executor.invokeAny(tasks, timeout, unit);
    }
}

