/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.core.task;

import com.bes.enterprise.webtier.core.task.DispatchableTask;
import com.bes.enterprise.webtier.core.task.TaskEvent;
import com.bes.enterprise.webtier.core.task.TaskListener;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractDispatchableTask
implements DispatchableTask {
    private boolean vipTask;
    private String priority;
    private int timeoutInMills = -1;
    private boolean cancelOnTimeout;
    private final AtomicBoolean runLock = new AtomicBoolean(false);
    private volatile boolean started = false;
    private volatile boolean finished = false;
    private volatile boolean canelled = false;
    private final long createTime = System.currentTimeMillis();
    private long begineTime = -1L;
    private long endTime = -1L;
    private volatile Thread runThread;
    private final ArrayList<TaskListener> listeners = new ArrayList();

    @Override
    public void addListener(TaskListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    @Override
    public void setVipTask(boolean vipTask) {
        this.vipTask = vipTask;
    }

    @Override
    public boolean isVipTask() {
        return this.vipTask;
    }

    @Override
    public void setPriority(String priority) {
        this.priority = priority;
    }

    @Override
    public String getPriority() {
        return this.priority;
    }

    @Override
    public boolean isCancelOnTimeout() {
        return this.cancelOnTimeout;
    }

    @Override
    public void setCancelOnTimeout(boolean cancelOnTimeout) {
        this.cancelOnTimeout = cancelOnTimeout;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public long getStartTime() {
        return this.begineTime;
    }

    @Override
    public long getFinishTime() {
        return this.endTime;
    }

    @Override
    public boolean isTimeOut() {
        return false;
    }

    @Override
    public int getTimeoutInMills() {
        return this.timeoutInMills;
    }

    @Override
    public void setTimeoutInMills(int timeoutInSecs) {
        this.timeoutInMills = timeoutInSecs;
    }

    @Override
    public long getElapsedTimeFromCreate() {
        return System.currentTimeMillis() - this.createTime;
    }

    @Override
    public long getElapsedTimeFromCreate(long currentTime) {
        return currentTime - this.createTime;
    }

    @Override
    public long getElapsedTimeFromStart() {
        if (this.started) {
            return System.currentTimeMillis() - this.begineTime;
        }
        return -1L;
    }

    @Override
    public long getElapsedTimeFromStart(long currentTime) {
        if (this.started) {
            return currentTime - this.begineTime;
        }
        return -1L;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean supportCancel() {
        return !this.started;
    }

    @Override
    public void cancel() {
        if (this.supportCancel()) {
            this.canelled = true;
            if (this.listeners.size() > 0) {
                TaskEvent taskEvent = new TaskEvent(TaskEvent.TaskEventType.CANCELLED, this);
                for (TaskListener listener : this.listeners) {
                    listener.handle(taskEvent);
                }
            }
        }
    }

    @Override
    public void recycle() {
        this.finished = false;
        this.endTime = -1L;
        this.canelled = false;
        this.begineTime = -1L;
        this.started = false;
    }

    @Override
    public void run() {
        block7: {
            if (!this.runLock.compareAndSet(false, true)) {
                return;
            }
            try {
                if (this.canelled) break block7;
                try {
                    this.preExecute();
                    if (!this.canelled) {
                        this.execute();
                    }
                }
                finally {
                    this.postExecute();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public abstract void execute();

    private void preExecute() {
        this.begineTime = System.currentTimeMillis();
        this.runThread = Thread.currentThread();
        if (this.cancelOnTimeout && this.begineTime - this.createTime > (long)this.timeoutInMills) {
            this.canelled = true;
            this.cancel();
            return;
        }
        this.started = true;
        if (this.listeners.size() > 0) {
            TaskEvent taskEvent = new TaskEvent(TaskEvent.TaskEventType.STARTED, this);
            for (TaskListener listener : this.listeners) {
                listener.handle(taskEvent);
            }
        }
    }

    public void postExecute() {
        this.endTime = System.currentTimeMillis();
        this.runThread = null;
        this.finished = true;
        if (this.listeners.size() > 0) {
            TaskEvent taskEvent = new TaskEvent(TaskEvent.TaskEventType.FINISHED, this);
            for (TaskListener listener : this.listeners) {
                listener.handle(taskEvent);
            }
        }
    }
}

