/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.core.task;

import com.bes.enterprise.web.util.threads.ThreadPoolExecutor;
import com.bes.enterprise.webtier.core.task.DispatchableTask;
import com.bes.enterprise.webtier.core.task.NamedExecutor;
import com.bes.enterprise.webtier.core.task.RunnableDelegateTask;
import com.bes.enterprise.webtier.core.task.TaskDispatcher;
import com.bes.enterprise.webtier.core.task.TaskEvent;
import com.bes.enterprise.webtier.core.task.TaskListener;
import com.bes.enterprise.webtier.core.task.ThreadPoolGroupConfig;
import com.bes.enterprise.webtier.core.task.VipTaskStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;

public class DefaultTaskDispatcher
implements TaskDispatcher,
Executor {
    private final ThreadPoolGroupConfig config;
    private final List<NamedExecutor> namedExecutors;
    private final Map<String, NamedExecutor> executors = new HashMap<String, NamedExecutor>();
    private final LinkedBlockingQueue<DispatchableTask> vipTasks = new LinkedBlockingQueue(1024);
    private final TaskStartedListener startedListener = new TaskStartedListener(this.vipTasks);
    private TaskCheckThread checkThread;
    private VipExecutorStrategy directlyStrategy = new VipExecutorDirectlyStrategy();
    private NormalExecutorIdleStrategy executorIdleStrategy = new NormalExecutorIdleStrategy();

    public DefaultTaskDispatcher(ThreadPoolGroupConfig config, List<NamedExecutor> namedVipExecutors) {
        this.config = config;
        this.namedExecutors = namedVipExecutors;
        this.initExecutors();
    }

    public void initExecutors() {
        Collections.sort(this.namedExecutors, new Comparator<NamedExecutor>(){

            @Override
            public int compare(NamedExecutor o1, NamedExecutor o2) {
                return o1.getPriority().compareTo(o2.getPriority());
            }
        });
        for (NamedExecutor vipExecutor : this.namedExecutors) {
            this.executors.put(vipExecutor.getName(), vipExecutor);
        }
    }

    @Override
    public String getName() {
        return this.config.getName();
    }

    public List<NamedExecutor> getNamedExecutors() {
        return this.namedExecutors;
    }

    public void addExecutor(NamedExecutor namedExecutor) {
        this.executors.put(namedExecutor.getName(), this.namedExecutors.get(this.namedExecutors.size() - 1));
    }

    public List<NamedExecutor> getExecutors() {
        ArrayList<NamedExecutor> executorLst = new ArrayList<NamedExecutor>();
        executorLst.addAll(this.executors.values());
        return executorLst;
    }

    @Override
    public void init() {
        this.checkThread = new TaskCheckThread();
        this.checkThread.setName("TaskDispatcher-" + this.config.getName());
        this.checkThread.start();
    }

    @Override
    public void dispatch(DispatchableTask task) {
        if (this.config.getMaxQueueTimeoutMills() != -1 && task.getTimeoutInMills() == -1) {
            task.setTimeoutInMills(this.config.getMaxQueueTimeoutMills());
        }
        if (this.config.isCancelOnQueueTimeout()) {
            task.setCancelOnTimeout(true);
        }
        VipTaskStrategy strategy = this.config.getStrategy();
        switch (strategy) {
            case NormalExecutorIdle: {
                this.executorIdleStrategy.execute(task);
                break;
            }
            default: {
                this.directlyStrategy.execute(task);
            }
        }
    }

    @Override
    public void dispatch(Runnable command) {
        if (command instanceof DispatchableTask) {
            this.dispatch((DispatchableTask)command);
        } else {
            RunnableDelegateTask delegateTask = new RunnableDelegateTask(command);
            if (this.config.getMaxQueueTimeoutMills() != -1) {
                delegateTask.setTimeoutInMills(this.config.getMaxQueueTimeoutMills());
            }
            if (this.config.isCancelOnQueueTimeout()) {
                delegateTask.setCancelOnTimeout(true);
            }
            this.dispatch(delegateTask);
        }
    }

    @Override
    public void execute(Runnable command) {
        this.dispatch(command);
    }

    protected NamedExecutor findRestExecutor(int index) {
        if (index == 0) {
            return this.namedExecutors.get(index);
        }
        NamedExecutor namedExecutor = this.namedExecutors.get(index);
        if (this.isExecutorBusy(namedExecutor.getExecutor())) {
            namedExecutor = this.doFindRestExecutor(index - 1);
        }
        return namedExecutor;
    }

    protected NamedExecutor doFindRestExecutor(int index) {
        if (index > this.namedExecutors.size() - 1) {
            index = this.namedExecutors.size() - 1;
        }
        NamedExecutor namedExecutor = null;
        for (int i2 = index; i2 >= 0; --i2) {
            ThreadPoolExecutor executor = this.namedExecutors.get(i2).getExecutor();
            if (this.isExecutorBusy(executor)) continue;
            namedExecutor = this.namedExecutors.get(i2);
            break;
        }
        return namedExecutor;
    }

    protected NamedExecutor findExecutorByPriority(String priority) {
        NamedExecutor namedExecutor = null;
        int targetPriority = Integer.parseInt(priority);
        for (int i2 = 0; i2 < this.namedExecutors.size(); ++i2) {
            if (!this.namedExecutors.get(i2).getPriority().equals(priority)) continue;
            namedExecutor = this.findRestExecutor(i2);
            break;
        }
        if (namedExecutor == null) {
            int firstPriority = Integer.parseInt(this.namedExecutors.get(0).getPriority());
            int lastPriority = Integer.parseInt(this.namedExecutors.get(this.namedExecutors.size() - 1).getPriority());
            if (targetPriority < firstPriority) {
                namedExecutor = this.findRestExecutor(0);
            } else if (targetPriority > lastPriority) {
                namedExecutor = this.findRestExecutor(this.namedExecutors.size() - 1);
            } else {
                for (int i3 = 1; i3 < this.namedExecutors.size(); ++i3) {
                    int otherPriority = Integer.parseInt(this.namedExecutors.get(i3).getPriority());
                    if (targetPriority >= otherPriority) continue;
                    namedExecutor = this.findRestExecutor(i3);
                    break;
                }
            }
        }
        return namedExecutor;
    }

    protected boolean isExecutorBusy(java.util.concurrent.ThreadPoolExecutor executor) {
        DispatchableTask task;
        long elapsedTime;
        if (executor.getPoolSize() < executor.getMaximumPoolSize()) {
            return false;
        }
        if (executor.getActiveCount() < executor.getMaximumPoolSize() - 3) {
            return false;
        }
        BlockingQueue<Runnable> queue = executor.getQueue();
        Object peekedObj = queue.peek();
        if (peekedObj == null) {
            return false;
        }
        return peekedObj instanceof DispatchableTask && (elapsedTime = (task = (DispatchableTask)peekedObj).getElapsedTimeFromCreate()) > (long)this.config.getQueueTimeBusyThresholdMills();
    }

    public void transferToVipChannel() {
        Iterator<DispatchableTask> iterator = this.vipTasks.iterator();
        long currentTime = System.currentTimeMillis();
        while (iterator.hasNext()) {
            DispatchableTask vipTask = iterator.next();
            if (!this.needTransfer(vipTask, currentTime)) continue;
            iterator.remove();
            this.findExecutorByPriority(vipTask.getPriority()).execute(vipTask);
        }
    }

    private boolean needTransfer(DispatchableTask vipTask, long currentTime) {
        int timeout = vipTask.getTimeoutInMills();
        if (timeout == -1) {
            return false;
        }
        long elapsedTime = vipTask.getElapsedTimeFromCreate(currentTime);
        return elapsedTime > (long)(timeout * this.config.getPromateRate() / 100);
    }

    @Override
    public void destroy() {
        if (this.checkThread != null) {
            this.checkThread.terminate();
        }
    }

    public class TaskCheckThread
    extends Thread {
        private volatile boolean doTask = true;

        @Override
        public void run() {
            int checkIntervalInMills = DefaultTaskDispatcher.this.config.getCheckIntervalMills();
            while (this.doTask) {
                DefaultTaskDispatcher.this.transferToVipChannel();
                try {
                    Thread.sleep(checkIntervalInMills);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void terminate() {
            this.doTask = false;
        }

        public boolean isTerminate() {
            return !this.doTask;
        }
    }

    class VipExecutorDirectlyStrategy
    implements VipExecutorStrategy {
        VipExecutorDirectlyStrategy() {
        }

        @Override
        public void execute(DispatchableTask task) {
            NamedExecutor executorService = null;
            executorService = task.isVipTask() ? DefaultTaskDispatcher.this.findExecutorByPriority(task.getPriority()) : DefaultTaskDispatcher.this.findRestExecutor(DefaultTaskDispatcher.this.namedExecutors.size() - 1);
            executorService.execute(task);
        }
    }

    class NormalExecutorIdleStrategy
    implements VipExecutorStrategy {
        NormalExecutorIdleStrategy() {
        }

        @Override
        public void execute(DispatchableTask task) {
            NamedExecutor executorService = null;
            if (task.isVipTask()) {
                NamedExecutor normalExecutor = DefaultTaskDispatcher.this.findExecutorByPriority(task.getPriority());
                if (DefaultTaskDispatcher.this.isExecutorBusy(normalExecutor.getExecutor())) {
                    executorService = DefaultTaskDispatcher.this.findRestExecutor(DefaultTaskDispatcher.this.namedExecutors.size() - 1);
                } else {
                    DefaultTaskDispatcher.this.vipTasks.offer(task);
                    task.addListener(DefaultTaskDispatcher.this.startedListener);
                    executorService = normalExecutor;
                }
            } else {
                executorService = DefaultTaskDispatcher.this.findRestExecutor(DefaultTaskDispatcher.this.namedExecutors.size() - 1);
            }
            try {
                executorService.execute(task);
            }
            catch (RejectedExecutionException ex) {
                if (task.isVipTask()) {
                    DefaultTaskDispatcher.this.findExecutorByPriority(task.getPriority()).getExecutor().execute(task);
                    return;
                }
                throw ex;
            }
        }
    }

    static interface VipExecutorStrategy {
        public void execute(DispatchableTask var1);
    }

    private static class TaskStartedListener
    implements TaskListener {
        private final Queue taskQueue;

        public TaskStartedListener(Queue taskQueue) {
            this.taskQueue = taskQueue;
        }

        @Override
        public void handle(TaskEvent event) {
            if (TaskEvent.TaskEventType.STARTED.equals((Object)event.getEventType())) {
                this.taskQueue.remove(event.getTask());
            }
        }
    }
}

