/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.core.task;

import com.bes.enterprise.common.request.dispatcher.RequestDispatcher;
import com.bes.enterprise.common.request.dispatcher.RequestDispatcherRegistry;
import com.bes.enterprise.common.request.dispatcher.config.RequestAllowRuleConfig;
import com.bes.enterprise.common.request.dispatcher.config.RequestDenyRuleConfig;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.crane.AbstractProcessor;
import com.bes.enterprise.web.crane.ActionCode;
import com.bes.enterprise.web.crane.Request;
import com.bes.enterprise.web.crane.Response;
import com.bes.enterprise.web.crane.http11.Http11Processor;
import com.bes.enterprise.web.util.buf.ByteChunk;
import com.bes.enterprise.web.util.net.NioChannel;
import com.bes.enterprise.web.util.net.NioEndpoint;
import com.bes.enterprise.web.util.net.SocketWrapperBase;
import com.bes.enterprise.webtier.core.task.RunnableDelegateTask;
import com.bes.enterprise.webtier.core.task.ThreadPoolGroupConfig;
import com.bes.enterprise.webtier.core.task.ThreadPoolGroupExecutor;
import java.io.IOException;
import java.util.concurrent.Executor;

public class RequestDispatchUtil {
    private static final Log logger = LogFactory.getLog(RequestDispatchUtil.class);

    public static Runnable wrappterAllowTask(Executor executor, Runnable runnable, String reqeustUrl, String queryString) {
        if (!(executor instanceof ThreadPoolGroupExecutor)) {
            return runnable;
        }
        ThreadPoolGroupExecutor taskDispatcher = (ThreadPoolGroupExecutor)executor;
        ThreadPoolGroupConfig config = taskDispatcher.getConfig();
        RequestDispatcher dispatcher = RequestDispatcherRegistry.findRequestAllowDispatcher(null);
        if (dispatcher != null) {
            RequestAllowRuleConfig rule = (RequestAllowRuleConfig)dispatcher.findDispatcherRule(reqeustUrl, queryString);
            if (rule == null) {
                RunnableDelegateTask delegateTask = new RunnableDelegateTask(runnable);
                delegateTask.setVipTask(false);
                return delegateTask;
            }
            RunnableDelegateTask delegateTask = new RunnableDelegateTask(runnable);
            delegateTask.setVipTask(true);
            delegateTask.setPriority(rule.getPriority());
            if (rule.getRequestTimeout() > 0) {
                delegateTask.setTimeoutInMills(rule.getRequestTimeout() * 1000);
            }
            return delegateTask;
        }
        return runnable;
    }

    public static RequestDenyRuleConfig findRejectRule(String reqeustUrl, String queryString) {
        RequestDispatcher excludeDispatcher = RequestDispatcherRegistry.findRequestDenyDispatcher(null);
        if (excludeDispatcher != null) {
            return (RequestDenyRuleConfig)excludeDispatcher.findDispatcherRule(reqeustUrl, queryString);
        }
        return null;
    }

    public static boolean wrapperCustomRejectTask(String reqeustUrl, RequestDenyRuleConfig ruleConfig, AbstractProcessor processor, SocketWrapperBase<NioChannel> socketWrapper, NioEndpoint endpoint) throws IOException {
        Response response = processor.getResponse();
        String errorCode = ruleConfig.getErrorCode();
        String errorDesc = ruleConfig.getErrorDesc();
        response.setStatus(Integer.parseInt(errorCode));
        response.setContentLength(errorDesc.getBytes().length);
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        boolean keepAlive = true;
        if (endpoint.getMaxKeepAliveRequests() == 1) {
            keepAlive = false;
        } else if (endpoint.getMaxKeepAliveRequests() > 0 && socketWrapper.decrementKeepAlive() <= 0) {
            keepAlive = false;
        }
        if (!keepAlive && processor instanceof Http11Processor) {
            ((Http11Processor)processor).setKeepAlive(keepAlive);
        }
        ByteChunk byteChunk = new ByteChunk();
        byteChunk.append(errorDesc.getBytes(), 0, errorDesc.getBytes().length);
        response.doWrite(byteChunk);
        response.action(ActionCode.CLOSE, null);
        endpoint.getHandler().release(socketWrapper);
        if (!keepAlive) {
            return true;
        }
        socketWrapper.registerReadInterest();
        logger.info("The request [" + reqeustUrl + "] was reject and return http status code due to reject business rule in configuration.");
        return false;
    }

    public static boolean doDispatchTask(AbstractProcessor processor, Executor executor, Runnable sc, SocketWrapperBase<NioChannel> socketWrapper, NioEndpoint endpoint) throws IOException {
        String queryString;
        Request request = processor.getRequest();
        String reqeustUrl = request.requestURI().toString();
        RequestDenyRuleConfig ruleConfig = RequestDispatchUtil.findRejectRule(reqeustUrl, queryString = request.queryString().toString());
        if (ruleConfig != null) {
            if (ruleConfig.isDiscard()) {
                logger.info("The request [" + reqeustUrl + "] was reject due to reject business rule in configuration.");
                return true;
            }
            RequestDispatchUtil.wrapperCustomRejectTask(reqeustUrl, ruleConfig, processor, socketWrapper, endpoint);
        }
        Runnable runable = RequestDispatchUtil.wrappterAllowTask(executor, sc, reqeustUrl, queryString);
        executor.execute(runable);
        return false;
    }
}

