/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.core.task;

import com.bes.enterprise.webtier.Executor;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.LifecycleState;
import com.bes.enterprise.webtier.core.WorkThreadExecutor;
import com.bes.enterprise.webtier.core.task.DefaultTaskDispatcher;
import com.bes.enterprise.webtier.core.task.NamedExecutor;
import com.bes.enterprise.webtier.core.task.TaskDispatcher;
import com.bes.enterprise.webtier.core.task.ThreadPoolGroupConfig;
import com.bes.enterprise.webtier.util.LifecycleMBeanBase;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ThreadPoolGroupExecutor
extends LifecycleMBeanBase
implements Executor {
    private ThreadPoolGroupConfig config;
    private final Map<Integer, WorkThreadExecutor> priorityToWorkExecutor = new LinkedHashMap<Integer, WorkThreadExecutor>();
    private TaskDispatcher dispatcher;

    public TaskDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    protected void initInternal() throws LifecycleException {
        for (Map.Entry<Integer, WorkThreadExecutor> executor : this.priorityToWorkExecutor.entrySet()) {
            executor.getValue().setDomain(this.getDomain());
            executor.getValue().init();
        }
    }

    @Override
    protected void startInternal() throws LifecycleException {
        ArrayList<NamedExecutor> namedVipExecutors = new ArrayList<NamedExecutor>();
        for (Map.Entry<Integer, WorkThreadExecutor> executor : this.priorityToWorkExecutor.entrySet()) {
            executor.getValue().start();
            NamedExecutor namedExecutor = new NamedExecutor(executor.getValue().getName(), executor.getValue().getUnderlyingExecutor(), String.valueOf(executor.getKey()));
            namedVipExecutors.add(namedExecutor);
        }
        this.dispatcher = new DefaultTaskDispatcher(this.config, namedVipExecutors);
        this.dispatcher.init();
        this.setState(LifecycleState.STARTING);
    }

    @Override
    public String getName() {
        return this.config.getName();
    }

    @Override
    public void execute(Runnable command, long timeout, TimeUnit unit) {
        this.dispatcher.dispatch(command);
    }

    @Override
    public void execute(Runnable command) {
        this.dispatcher.dispatch(command);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        super.destroyInternal();
        if (this.dispatcher != null) {
            this.dispatcher.destroy();
        }
        this.dispatcher = null;
    }

    @Override
    protected String getDomainInternal() {
        return null;
    }

    @Override
    protected String getObjectNameKeyProperties() {
        StringBuilder name = new StringBuilder("type=Executor,name=");
        name.append(this.getName());
        return name.toString();
    }

    public void addWorkExecutor(Integer priority, WorkThreadExecutor workExecutor) {
        this.priorityToWorkExecutor.put(priority, workExecutor);
    }

    public ThreadPoolGroupConfig getConfig() {
        return this.config;
    }

    public void setConfig(ThreadPoolGroupConfig config) {
        this.config = config;
    }
}

