/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.loader;

import com.bes.enterprise.logging.WebappProperties;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.InstrumentableClassLoader;
import com.bes.enterprise.web.util.ExceptionUtils;
import com.bes.enterprise.web.util.IntrospectionUtils;
import com.bes.enterprise.web.util.compat.JreCompat;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.web.util.security.PermissionCheck;
import com.bes.enterprise.webtier.Container;
import com.bes.enterprise.webtier.Globals;
import com.bes.enterprise.webtier.Lifecycle;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.LifecycleListener;
import com.bes.enterprise.webtier.LifecycleState;
import com.bes.enterprise.webtier.WebResource;
import com.bes.enterprise.webtier.WebResourceRoot;
import com.bes.enterprise.webtier.loader.ResourceEntry;
import com.bes.enterprise.webtier.loader.ResourceScopeType;
import com.bes.enterprise.webtier.webresources.BESURLStreamHandlerFactory;
import java.beans.Introspector;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public abstract class WebappClassLoaderBase
extends URLClassLoader
implements Lifecycle,
InstrumentableClassLoader,
WebappProperties,
PermissionCheck {
    private static final Log log = LogFactory.getLog(WebappClassLoaderBase.class);
    private static final List<String> JVM_THREAD_GROUP_NAMES = new ArrayList<String>();
    private static final String JVM_THREAD_GROUP_SYSTEM = "system";
    private static final String CLASS_FILE_SUFFIX = ".class";
    private static final List<String> webAppEnrichmentPrefixes = new ArrayList<String>();
    protected static final StringManager sm;
    protected WebResourceRoot resources = null;
    protected final Map<String, ResourceEntry> resourceEntries = new ConcurrentHashMap<String, ResourceEntry>();
    protected boolean delegate = false;
    private final HashMap<String, Long> jarModificationTimes = new HashMap();
    protected final ArrayList<Permission> permissionList = new ArrayList();
    protected final HashMap<String, PermissionCollection> loaderPC = new HashMap();
    protected final SecurityManager securityManager;
    protected final ClassLoader parent;
    private ClassLoader javaseClassLoader;
    @Deprecated
    protected final Permission allPermission = new AllPermission();
    private PermissionCollection permissionCollection;
    private boolean clearReferencesRmiTargets = true;
    private boolean clearReferencesStopThreads = false;
    private boolean clearReferencesStopTimerThreads = false;
    private boolean clearReferencesLogFactoryRelease = true;
    private boolean clearReferencesHttpClientKeepAliveThread = true;
    private boolean clearReferencesObjectStreamClassCaches = true;
    private boolean clearReferencesThreadLocals = true;
    private final List<ClassFileTransformer> transformers = new CopyOnWriteArrayList<ClassFileTransformer>();
    private boolean hasExternalRepositories = false;
    private Map<String, ResourceScopeType> overridableCustomClasses;
    private Map<String, ResourceScopeType> overridableCustomResources;
    private Map<String, ResourceScopeType> overridableCustomPackages;
    private Map<String, ResourceScopeType> overridableScopeResources;
    private List<URL> localRepositories = new ArrayList<URL>();
    private volatile LifecycleState state = LifecycleState.NEW;
    private ConcurrentLinkedQueue<String> overridablePackages;
    private ConcurrentLinkedQueue<String> preferServerPackages;

    protected WebappClassLoaderBase() {
        super(new URL[0]);
        ClassLoader p2 = this.getParent();
        if (p2 == null) {
            p2 = WebappClassLoaderBase.getSystemClassLoader();
        }
        this.parent = p2;
        ClassLoader j2 = String.class.getClassLoader();
        if (j2 == null) {
            j2 = WebappClassLoaderBase.getSystemClassLoader();
            while (j2.getParent() != null) {
                j2 = j2.getParent();
            }
        }
        this.javaseClassLoader = j2;
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
    }

    protected WebappClassLoaderBase(ClassLoader parent) {
        super(new URL[0], parent);
        ClassLoader p2 = this.getParent();
        if (p2 == null) {
            p2 = WebappClassLoaderBase.getSystemClassLoader();
        }
        this.parent = p2;
        ClassLoader j2 = String.class.getClassLoader();
        if (j2 == null) {
            j2 = WebappClassLoaderBase.getSystemClassLoader();
            while (j2.getParent() != null) {
                j2 = j2.getParent();
            }
        }
        this.javaseClassLoader = j2;
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
    }

    public WebResourceRoot getResources() {
        return this.resources;
    }

    public void setResources(WebResourceRoot resources) {
        this.resources = resources;
    }

    public String getContextName() {
        if (this.resources == null) {
            return "Unknown";
        }
        return this.resources.getContext().getBaseName();
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        this.delegate = delegate;
    }

    void addPermission(URL url) {
        if (url == null) {
            return;
        }
        if (this.securityManager != null) {
            String protocol = url.getProtocol();
            if ("file".equalsIgnoreCase(protocol)) {
                String path;
                File f2;
                try {
                    URI uri = url.toURI();
                    f2 = new File(uri);
                    path = f2.getCanonicalPath();
                }
                catch (IOException | URISyntaxException e2) {
                    log.warn(sm.getString("webappClassLoader.addPermisionNoCanonicalFile", url.toExternalForm()));
                    return;
                }
                if (f2.isFile()) {
                    this.addPermission(new FilePermission(path, "read"));
                } else if (f2.isDirectory()) {
                    this.addPermission(new FilePermission(path, "read"));
                    this.addPermission(new FilePermission(path + File.separator + "-", "read"));
                }
            } else {
                log.warn(sm.getString("webappClassLoader.addPermisionNoProtocol", protocol, url.toExternalForm()));
            }
        }
    }

    public PermissionCollection getPermissionCollection() {
        return this.permissionCollection;
    }

    public void setPermissionCollection(PermissionCollection permissionCollection) {
        this.permissionCollection = permissionCollection;
    }

    void addPermission(Permission permission) {
        if (this.securityManager != null && permission != null) {
            this.permissionList.add(permission);
        }
    }

    public boolean getClearReferencesRmiTargets() {
        return this.clearReferencesRmiTargets;
    }

    public void setClearReferencesRmiTargets(boolean clearReferencesRmiTargets) {
        this.clearReferencesRmiTargets = clearReferencesRmiTargets;
    }

    public boolean getClearReferencesStopThreads() {
        return this.clearReferencesStopThreads;
    }

    public void setClearReferencesStopThreads(boolean clearReferencesStopThreads) {
        this.clearReferencesStopThreads = clearReferencesStopThreads;
    }

    public boolean getClearReferencesStopTimerThreads() {
        return this.clearReferencesStopTimerThreads;
    }

    public void setClearReferencesStopTimerThreads(boolean clearReferencesStopTimerThreads) {
        this.clearReferencesStopTimerThreads = clearReferencesStopTimerThreads;
    }

    public boolean getClearReferencesLogFactoryRelease() {
        return this.clearReferencesLogFactoryRelease;
    }

    public void setClearReferencesLogFactoryRelease(boolean clearReferencesLogFactoryRelease) {
        this.clearReferencesLogFactoryRelease = clearReferencesLogFactoryRelease;
    }

    public boolean getClearReferencesHttpClientKeepAliveThread() {
        return this.clearReferencesHttpClientKeepAliveThread;
    }

    public void setClearReferencesHttpClientKeepAliveThread(boolean clearReferencesHttpClientKeepAliveThread) {
        this.clearReferencesHttpClientKeepAliveThread = clearReferencesHttpClientKeepAliveThread;
    }

    public boolean getClearReferencesObjectStreamClassCaches() {
        return this.clearReferencesObjectStreamClassCaches;
    }

    public void setClearReferencesObjectStreamClassCaches(boolean clearReferencesObjectStreamClassCaches) {
        this.clearReferencesObjectStreamClassCaches = clearReferencesObjectStreamClassCaches;
    }

    public boolean getClearReferencesThreadLocals() {
        return this.clearReferencesThreadLocals;
    }

    public void setClearReferencesThreadLocals(boolean clearReferencesThreadLocals) {
        this.clearReferencesThreadLocals = clearReferencesThreadLocals;
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        if (transformer == null) {
            throw new IllegalArgumentException(sm.getString("webappClassLoader.addTransformer.illegalArgument", this.getContextName()));
        }
        if (this.transformers.contains(transformer)) {
            log.warn(sm.getString("webappClassLoader.addTransformer.duplicate", transformer, this.getContextName()));
            return;
        }
        this.transformers.add(transformer);
        log.info(sm.getString("webappClassLoader.addTransformer", transformer, this.getContextName()));
    }

    @Override
    public void removeTransformer(ClassFileTransformer transformer) {
        if (transformer == null) {
            return;
        }
        if (this.transformers.remove(transformer)) {
            log.info(sm.getString("webappClassLoader.removeTransformer", transformer, this.getContextName()));
        }
    }

    protected void copyStateWithoutTransformers(WebappClassLoaderBase base) {
        base.resources = this.resources;
        base.delegate = this.delegate;
        base.state = LifecycleState.NEW;
        base.clearReferencesStopThreads = this.clearReferencesStopThreads;
        base.clearReferencesStopTimerThreads = this.clearReferencesStopTimerThreads;
        base.clearReferencesLogFactoryRelease = this.clearReferencesLogFactoryRelease;
        base.clearReferencesHttpClientKeepAliveThread = this.clearReferencesHttpClientKeepAliveThread;
        base.jarModificationTimes.putAll(this.jarModificationTimes);
        base.permissionList.addAll(this.permissionList);
        base.loaderPC.putAll(this.loaderPC);
    }

    public boolean modified() {
        if (log.isDebugEnabled()) {
            log.debug("modified()");
        }
        for (Map.Entry<String, ResourceEntry> entry : this.resourceEntries.entrySet()) {
            long cachedLastModified = entry.getValue().lastModified;
            long lastModified = this.resources.getClassLoaderResource(entry.getKey()).getLastModified();
            if (lastModified == cachedLastModified) continue;
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("webappClassLoader.resourceModified", entry.getKey(), new Date(cachedLastModified), new Date(lastModified)));
            }
            return true;
        }
        WebResource[] jars = this.resources.listResources("/WEB-INF/lib");
        int jarCount = 0;
        for (WebResource jar : jars) {
            if (!jar.getName().endsWith(".jar") || !jar.isFile() || !jar.canRead()) continue;
            ++jarCount;
            Long recordedLastModified = this.jarModificationTimes.get(jar.getName());
            if (recordedLastModified == null) {
                log.info(sm.getString("webappClassLoader.jarsAdded", this.resources.getContext().getName()));
                return true;
            }
            if (recordedLastModified.longValue() == jar.getLastModified()) continue;
            log.info(sm.getString("webappClassLoader.jarsModified", this.resources.getContext().getName()));
            return true;
        }
        if (jarCount < this.jarModificationTimes.size()) {
            log.info(sm.getString("webappClassLoader.jarsRemoved", this.resources.getContext().getName()));
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("\r\n  context: ");
        sb.append(this.getContextName());
        sb.append("\r\n  delegate: ");
        sb.append(this.delegate);
        sb.append("\r\n");
        if (this.parent != null) {
            sb.append("----------> Parent Classloader:\r\n");
            sb.append(this.parent.toString());
            sb.append("\r\n");
        }
        if (this.transformers.size() > 0) {
            sb.append("----------> Class file transformers:\r\n");
            for (ClassFileTransformer transformer : this.transformers) {
                sb.append(transformer).append("\r\n");
            }
        }
        return sb.toString();
    }

    protected final Class<?> doDefineClass(String name, byte[] b2, int off, int len, ProtectionDomain protectionDomain) {
        return super.defineClass(name, b2, off, len, protectionDomain);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        int i2;
        if (log.isDebugEnabled()) {
            log.debug("    findClass(" + name + ")");
        }
        this.checkStateForClassLoading(name);
        if (this.securityManager != null && (i2 = name.lastIndexOf(46)) >= 0) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace("      securityManager.checkPackageDefinition");
                }
                this.securityManager.checkPackageDefinition(name.substring(0, i2));
            }
            catch (Exception se) {
                if (log.isTraceEnabled()) {
                    log.trace("      -->Exception-->ClassNotFoundException", se);
                }
                throw new ClassNotFoundException(name, se);
            }
        }
        Class<?> clazz = null;
        try {
            if (log.isTraceEnabled()) {
                log.trace("      findClassInternal(" + name + ")");
            }
            try {
                if (this.securityManager != null) {
                    PrivilegedFindClassByName dp = new PrivilegedFindClassByName(name);
                    clazz = (Class<?>)AccessController.doPrivileged(dp);
                } else {
                    clazz = this.findClassInternal(name);
                }
            }
            catch (AccessControlException ace) {
                log.warn("WebappClassLoader.findClassInternal(" + name + ") security exception: " + ace.getMessage(), ace);
                throw new ClassNotFoundException(name, ace);
            }
            catch (RuntimeException e2) {
                if (log.isTraceEnabled()) {
                    log.trace("      -->RuntimeException Rethrown", e2);
                }
                throw e2;
            }
            if (clazz == null && this.hasExternalRepositories) {
                try {
                    clazz = super.findClass(name);
                }
                catch (AccessControlException ace) {
                    log.warn("WebappClassLoader.findClassInternal(" + name + ") security exception: " + ace.getMessage(), ace);
                    throw new ClassNotFoundException(name, ace);
                }
                catch (RuntimeException e3) {
                    if (log.isTraceEnabled()) {
                        log.trace("      -->RuntimeException Rethrown", e3);
                    }
                    throw e3;
                }
            }
            if (clazz == null) {
                if (log.isDebugEnabled()) {
                    log.debug("    --> Returning ClassNotFoundException");
                }
                throw new ClassNotFoundException(name);
            }
        }
        catch (ClassNotFoundException e4) {
            if (log.isTraceEnabled()) {
                log.trace("    --> Passing on ClassNotFoundException");
            }
            throw e4;
        }
        if (log.isTraceEnabled()) {
            log.debug("      Returning class " + clazz);
        }
        if (log.isTraceEnabled()) {
            ClassLoader cl = Globals.IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedGetClassLoader(clazz)) : clazz.getClassLoader();
            log.debug("      Loaded by " + cl.toString());
        }
        return clazz;
    }

    @Override
    public URL findResource(String name) {
        if (log.isDebugEnabled()) {
            log.debug("    findResource(" + name + ")");
        }
        this.checkStateForResourceLoading(name);
        URL url = null;
        String path = this.nameToPath(name);
        WebResource resource = this.resources.getClassLoaderResource(path);
        if (resource.exists()) {
            url = resource.getURL();
            this.trackLastModified(path, resource);
        }
        if (url == null && this.hasExternalRepositories) {
            url = super.findResource(name);
        }
        if (log.isDebugEnabled()) {
            if (url != null) {
                log.debug("    --> Returning '" + url.toString() + "'");
            } else {
                log.debug("    --> Resource not found, returning null");
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackLastModified(String path, WebResource resource) {
        if (this.resourceEntries.containsKey(path)) {
            return;
        }
        ResourceEntry entry = new ResourceEntry();
        entry.lastModified = resource.getLastModified();
        Map<String, ResourceEntry> map = this.resourceEntries;
        synchronized (map) {
            if (!this.resourceEntries.containsKey(path)) {
                this.resourceEntries.put(path, entry);
            }
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        final Enumeration[] enums = new Enumeration[2];
        Enumeration<URL> localResources = null;
        Enumeration<URL> parentResources = null;
        ResourceScopeType scopeType = null;
        if (this.overridableScopeResources != null) {
            scopeType = this.overridableScopeResources.get(name);
        }
        if (scopeType == null || scopeType == ResourceScopeType.ALL || scopeType == ResourceScopeType.NONE) {
            localResources = this.findResources(name);
            parentResources = this.parent != null ? this.parent.getResources(name) : this.getJavaseClassLoader().getResources(name);
        }
        if (scopeType == ResourceScopeType.DELEGATE && (parentResources = this.parent != null ? this.parent.getResources(name) : this.getJavaseClassLoader().getResources(name)) == null) {
            localResources = this.findResources(name);
        }
        if (scopeType == ResourceScopeType.SELF && (localResources = this.findResources(name)) == null) {
            parentResources = this.parent != null ? this.parent.getResources(name) : this.getJavaseClassLoader().getResources(name);
        }
        if (this.delegate) {
            enums[0] = parentResources;
            enums[1] = localResources;
        } else {
            enums[0] = localResources;
            enums[1] = parentResources;
        }
        return new Enumeration<URL>(){
            int index = 0;

            private boolean next() {
                while (this.index < enums.length) {
                    if (enums[this.index] != null && enums[this.index].hasMoreElements()) {
                        return true;
                    }
                    ++this.index;
                }
                return false;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }

            @Override
            public URL nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                return (URL)enums[this.index].nextElement();
            }
        };
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("    findResources(" + name + ")");
        }
        this.checkStateForResourceLoading(name);
        LinkedHashSet<URL> result = new LinkedHashSet<URL>();
        String path = this.nameToPath(name);
        if (this.resources != null) {
            WebResource[] webResources;
            for (WebResource webResource : webResources = this.resources.getClassLoaderResources(path)) {
                if (!webResource.exists()) continue;
                result.add(webResource.getURL());
            }
        }
        if (this.hasExternalRepositories) {
            Enumeration<URL> otherResourcePaths = super.findResources(name);
            while (otherResourcePaths.hasMoreElements()) {
                result.add(otherResourcePaths.nextElement());
            }
        }
        return Collections.enumeration(result);
    }

    @Override
    public URL getResource(String name) {
        if (log.isDebugEnabled()) {
            log.debug("getResource(" + name + ")");
        }
        this.checkStateForResourceLoading(name);
        URL url = null;
        boolean delegateFirst = this.delegate || this.filter(name, false);
        boolean isFilterResource = this.filterCustomResource(name);
        ResourceScopeType scopeType = this.getCustomResourceScope(name);
        boolean bl = delegateFirst = delegateFirst && !isFilterResource || !delegateFirst && isFilterResource;
        if (delegateFirst) {
            if (log.isDebugEnabled()) {
                log.debug("  Delegating to parent classloader " + this.parent);
            }
            if ((url = this.parent.getResource(name)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("  --> Returning '" + url.toString() + "'");
                }
                return url;
            }
            if (ResourceScopeType.SELF.equals((Object)scopeType)) {
                return null;
            }
        }
        if ((url = this.findResource(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("  --> Returning '" + url.toString() + "'");
            }
            return url;
        }
        if (ResourceScopeType.SELF.equals((Object)scopeType)) {
            return null;
        }
        if (!delegateFirst && (url = this.parent.getResource(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("  --> Returning '" + url.toString() + "'");
            }
            return url;
        }
        if (log.isDebugEnabled()) {
            log.debug("  --> Resource not found, returning null");
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        String path;
        WebResource resource;
        if (log.isDebugEnabled()) {
            log.debug("getResourceAsStream(" + name + ")");
        }
        this.checkStateForResourceLoading(name);
        InputStream stream = null;
        boolean delegateFirst = this.delegate || this.filter(name, false);
        boolean isFilterResource = this.filterCustomResource(name);
        ResourceScopeType scopeType = this.getCustomResourceScope(name);
        boolean bl = delegateFirst = delegateFirst && !isFilterResource || !delegateFirst && isFilterResource;
        if (delegateFirst) {
            if (log.isDebugEnabled()) {
                log.debug("  Delegating to parent classloader " + this.parent);
            }
            if ((stream = this.parent.getResourceAsStream(name)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("  --> Returning stream from parent");
                }
                return stream;
            }
            if (ResourceScopeType.SELF.equals((Object)scopeType)) {
                return null;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("  Searching local repositories");
        }
        if ((resource = this.resources.getClassLoaderResource(path = this.nameToPath(name))).exists()) {
            stream = resource.getInputStream();
            this.trackLastModified(path, resource);
        }
        try {
            URL url;
            if (this.hasExternalRepositories && stream == null && (url = super.findResource(name)) != null) {
                stream = url.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (stream != null) {
            if (log.isDebugEnabled()) {
                log.debug("  --> Returning stream from local");
            }
            return stream;
        }
        if (ResourceScopeType.SELF.equals((Object)scopeType)) {
            return null;
        }
        if (!delegateFirst) {
            if (log.isDebugEnabled()) {
                log.debug("  Delegating to parent classloader unconditionally " + this.parent);
            }
            if ((stream = this.parent.getResourceAsStream(name)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("  --> Resource not found, returning null");
        }
        return null;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            int i2;
            boolean tryLoadingFromJavaseLoader;
            if (log.isDebugEnabled()) {
                log.debug("loadClass(" + name + ", " + resolve + ")");
            }
            Class<?> clazz = null;
            this.checkStateForClassLoading(name);
            clazz = this.findLoadedClass0(name);
            if (clazz != null) {
                if (log.isDebugEnabled()) {
                    log.debug("  Returning class from cache");
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            clazz = this.findLoadedClass(name);
            if (clazz != null) {
                if (log.isDebugEnabled()) {
                    log.debug("  Returning class from cache");
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            String resourceName = this.binaryNameToPath(name, false);
            ClassLoader javaseLoader = this.getJavaseClassLoader();
            try {
                URL url;
                if (this.securityManager != null) {
                    PrivilegedJavaseGetResource dp = new PrivilegedJavaseGetResource(resourceName);
                    url = AccessController.doPrivileged(dp);
                } else {
                    url = javaseLoader.getResource(resourceName);
                }
                tryLoadingFromJavaseLoader = url != null;
            }
            catch (Throwable t2) {
                ExceptionUtils.handleThrowable(t2);
                tryLoadingFromJavaseLoader = true;
            }
            if (tryLoadingFromJavaseLoader) {
                try {
                    clazz = javaseLoader.loadClass(name);
                    if (clazz != null) {
                        if (resolve) {
                            this.resolveClass(clazz);
                        }
                        return clazz;
                    }
                }
                catch (ClassNotFoundException t2) {
                    // empty catch block
                }
            }
            if (this.securityManager != null && (i2 = name.lastIndexOf(46)) >= 0) {
                try {
                    this.securityManager.checkPackageAccess(name.substring(0, i2));
                }
                catch (SecurityException se) {
                    String error = "Security Violation, attempt to use Restricted Class: " + name;
                    log.info(error, se);
                    throw new ClassNotFoundException(error, se);
                }
            }
            if (WebappClassLoaderBase.isWebAppEnrichment(name)) {
                return this.findClass(name);
            }
            boolean delegateLoad = this.delegate || this.filter(name, true);
            boolean isFilterClass = this.filterCustomClasses(name);
            ResourceScopeType scopeType = this.getCustomClassScope(name);
            boolean bl = delegateLoad = delegateLoad && !isFilterClass || !delegateLoad && isFilterClass;
            if (delegateLoad) {
                if (log.isDebugEnabled()) {
                    log.debug("  Delegating to parent classloader1 " + this.parent);
                }
                try {
                    clazz = Class.forName(name, false, this.parent);
                    if (clazz != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("  Loading class from parent");
                        }
                        if (resolve) {
                            this.resolveClass(clazz);
                        }
                        return clazz;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (ResourceScopeType.SELF.equals((Object)scopeType)) {
                    throw new ClassNotFoundException(name);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("  Searching local repositories");
            }
            try {
                clazz = this.findClass(name);
                if (clazz != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("  Loading class from local repository");
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (ResourceScopeType.SELF.equals((Object)scopeType)) {
                throw new ClassNotFoundException(name);
            }
            if (!delegateLoad) {
                if (log.isDebugEnabled()) {
                    log.debug("  Delegating to parent classloader at end: " + this.parent);
                }
                try {
                    clazz = Class.forName(name, false, this.parent);
                    if (clazz != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("  Loading class from parent");
                        }
                        if (resolve) {
                            this.resolveClass(clazz);
                        }
                        return clazz;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        throw new ClassNotFoundException(name);
    }

    private static boolean isWebAppEnrichment(String className) {
        for (String packageName : webAppEnrichmentPrefixes) {
            if (!className.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    protected void checkStateForClassLoading(String className) throws ClassNotFoundException {
        try {
            this.checkStateForResourceLoading(className);
        }
        catch (IllegalStateException ise) {
            throw new ClassNotFoundException(ise.getMessage(), ise);
        }
    }

    protected void checkStateForResourceLoading(String resource) throws IllegalStateException {
        if (!this.state.isAvailable()) {
            String msg = sm.getString("webappClassLoader.stopped", resource);
            IllegalStateException ise = new IllegalStateException(msg);
            log.info(msg, ise);
            throw ise;
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        String codeUrl = codeSource.getLocation().toString();
        PermissionCollection pc = this.loaderPC.get(codeUrl);
        if (pc == null) {
            pc = super.getPermissions(codeSource);
            if (pc != null) {
                for (Permission p2 : this.permissionList) {
                    pc.add(p2);
                }
                this.loaderPC.put(codeUrl, pc);
            }
            if (System.getSecurityManager() == null) {
                return pc;
            }
            if (this.permissionCollection != null) {
                Enumeration<Permission> elements = this.permissionCollection.elements();
                while (elements.hasMoreElements()) {
                    Permission permission = elements.nextElement();
                    pc.add(permission);
                }
            }
        }
        return pc;
    }

    @Override
    public boolean check(Permission permission) {
        URL contextRootUrl;
        CodeSource cs;
        PermissionCollection pc;
        if (!Globals.IS_SECURITY_ENABLED) {
            return true;
        }
        Policy currentPolicy = Policy.getPolicy();
        return currentPolicy != null && (pc = currentPolicy.getPermissions(cs = new CodeSource(contextRootUrl = this.resources.getResource("/").getCodeBase(), (Certificate[])null))).implies(permission);
    }

    @Override
    public URL[] getURLs() {
        ArrayList<URL> result = new ArrayList<URL>();
        result.addAll(this.localRepositories);
        result.addAll(Arrays.asList(super.getURLs()));
        return result.toArray(new URL[result.size()]);
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
    }

    @Override
    public LifecycleState getState() {
        return this.state;
    }

    @Override
    public String getStateName() {
        return this.getState().toString();
    }

    @Override
    public void init() {
        this.state = LifecycleState.INITIALIZED;
    }

    @Override
    public void start() throws LifecycleException {
        WebResource[] jars;
        WebResource[] classesResources;
        this.state = LifecycleState.STARTING_PREP;
        for (WebResource classes : classesResources = this.resources.getResources("/WEB-INF/classes")) {
            if (!classes.isDirectory() || !classes.canRead()) continue;
            this.localRepositories.add(classes.getURL());
        }
        for (WebResource jar : jars = this.resources.listResources("/WEB-INF/lib")) {
            if (!jar.getName().endsWith(".jar") || !jar.isFile() || !jar.canRead()) continue;
            this.localRepositories.add(jar.getURL());
            this.jarModificationTimes.put(jar.getName(), jar.getLastModified());
        }
        this.state = LifecycleState.STARTED;
    }

    @Override
    public void stop() throws LifecycleException {
        this.state = LifecycleState.STOPPING_PREP;
        this.clearReferences();
        this.state = LifecycleState.STOPPING;
        this.resourceEntries.clear();
        this.jarModificationTimes.clear();
        this.resources = null;
        this.permissionList.clear();
        this.loaderPC.clear();
        this.state = LifecycleState.STOPPED;
    }

    @Override
    public void destroy() {
        this.state = LifecycleState.DESTROYING;
        try {
            super.close();
        }
        catch (IOException ioe) {
            log.warn(sm.getString("webappClassLoader.superCloseFail"), ioe);
        }
        this.state = LifecycleState.DESTROYED;
    }

    protected ClassLoader getJavaseClassLoader() {
        return this.javaseClassLoader;
    }

    protected void setJavaseClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException(sm.getString("webappClassLoader.javaseClassLoaderNull"));
        }
        this.javaseClassLoader = classLoader;
    }

    protected void clearReferences() {
        this.clearReferencesJdbc();
        this.clearReferencesThreads();
        if (this.clearReferencesObjectStreamClassCaches) {
            this.clearReferencesObjectStreamClassCaches();
        }
        if (this.clearReferencesThreadLocals) {
            this.checkThreadLocalsForLeaks();
        }
        if (this.clearReferencesRmiTargets) {
            this.clearReferencesRmiTargets();
        }
        IntrospectionUtils.clear();
        if (this.clearReferencesLogFactoryRelease) {
            LogFactory.release(this);
        }
        Introspector.flushCaches();
        BESURLStreamHandlerFactory.release(this);
    }

    private final void clearReferencesJdbc() {
        byte[] classBytes = new byte[2048];
        int offset = 0;
        try (InputStream is = this.getResourceAsStream("com/bes/enterprise/webtier/loader/JdbcLeakPrevention.class");){
            int read = is.read(classBytes, offset, classBytes.length - offset);
            while (read > -1) {
                if ((offset += read) == classBytes.length) {
                    byte[] tmp = new byte[classBytes.length * 2];
                    System.arraycopy(classBytes, 0, tmp, 0, classBytes.length);
                    classBytes = tmp;
                }
                read = is.read(classBytes, offset, classBytes.length - offset);
            }
            Class<?> lpClass = this.defineClass("com.bes.enterprise.webtier.loader.JdbcLeakPrevention", classBytes, 0, offset, this.getClass().getProtectionDomain());
            Object obj = lpClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            List driverNames = (List)obj.getClass().getMethod("clearJdbcDriverRegistrations", new Class[0]).invoke(obj, new Object[0]);
            for (String name : driverNames) {
                log.warn(sm.getString("webappClassLoader.clearJdbc", this.getContextName(), name));
            }
        }
        catch (Exception e2) {
            Throwable t2 = ExceptionUtils.unwrapInvocationTargetException(e2);
            ExceptionUtils.handleThrowable(t2);
            log.warn(sm.getString("webappClassLoader.jdbcRemoveFailed", this.getContextName()), t2);
        }
    }

    private void clearReferencesThreads() {
        Thread[] threads = this.getThreads();
        ArrayList<Thread> executorThreadsToStop = new ArrayList<Thread>();
        for (Thread thread : threads) {
            ClassLoader ccl;
            if (thread == null || (ccl = thread.getContextClassLoader()) != this || thread == Thread.currentThread()) continue;
            String threadName = thread.getName();
            ThreadGroup tg = thread.getThreadGroup();
            if (tg != null && JVM_THREAD_GROUP_NAMES.contains(tg.getName())) {
                if (!this.clearReferencesHttpClientKeepAliveThread || !threadName.equals("Keep-Alive-Timer")) continue;
                thread.setContextClassLoader(this.parent);
                log.debug(sm.getString("webappClassLoader.checkThreadsHttpClient"));
                continue;
            }
            if (!thread.isAlive()) continue;
            if (thread.getClass().getName().startsWith("java.util.Timer") && this.clearReferencesStopTimerThreads) {
                this.clearReferencesStopTimerThread(thread);
                continue;
            }
            if (this.isRequestThread(thread)) {
                log.warn(sm.getString("webappClassLoader.stackTraceRequestThread", this.getContextName(), threadName, this.getStackTrace(thread)));
            } else {
                log.warn(sm.getString("webappClassLoader.stackTrace", this.getContextName(), threadName, this.getStackTrace(thread)));
            }
            if (!this.clearReferencesStopThreads) continue;
            boolean usingExecutor = false;
            try {
                Object target = null;
                for (String fieldName : new String[]{"target", "runnable", "action"}) {
                    try {
                        Field targetField = thread.getClass().getDeclaredField(fieldName);
                        targetField.setAccessible(true);
                        target = targetField.get(thread);
                        break;
                    }
                    catch (NoSuchFieldException nfe) {
                    }
                }
                if (target != null && target.getClass().getCanonicalName() != null && target.getClass().getCanonicalName().equals("java.util.concurrent.ThreadPoolExecutor.Worker")) {
                    Field executorField = target.getClass().getDeclaredField("this$0");
                    executorField.setAccessible(true);
                    Object executor = executorField.get(target);
                    if (executor instanceof ThreadPoolExecutor) {
                        ((ThreadPoolExecutor)executor).shutdownNow();
                        usingExecutor = true;
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e2) {
                log.warn(sm.getString("webappClassLoader.stopThreadFail", thread.getName(), this.getContextName()), e2);
            }
            if (usingExecutor) {
                executorThreadsToStop.add(thread);
                continue;
            }
            thread.stop();
        }
        int count = 0;
        for (Thread t2 : executorThreadsToStop) {
            while (t2.isAlive() && count < 100) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e3) {
                    break;
                }
                ++count;
            }
            if (!t2.isAlive()) continue;
            t2.stop();
        }
    }

    private boolean isRequestThread(Thread thread) {
        StackTraceElement[] elements = thread.getStackTrace();
        if (elements == null || elements.length == 0) {
            return false;
        }
        for (int i2 = 0; i2 < elements.length; ++i2) {
            StackTraceElement element = elements[elements.length - (i2 + 1)];
            if (!"com.bes.enterprise.webtier.connector.CoyoteAdapter".equals(element.getClassName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearReferencesStopTimerThread(Thread thread) {
        try {
            try {
                Field newTasksMayBeScheduledField = thread.getClass().getDeclaredField("newTasksMayBeScheduled");
                newTasksMayBeScheduledField.setAccessible(true);
                Field queueField = thread.getClass().getDeclaredField("queue");
                queueField.setAccessible(true);
                Object queue = queueField.get(thread);
                Method clearMethod = queue.getClass().getDeclaredMethod("clear", new Class[0]);
                clearMethod.setAccessible(true);
                Object object = queue;
                synchronized (object) {
                    newTasksMayBeScheduledField.setBoolean(thread, false);
                    clearMethod.invoke(queue, new Object[0]);
                    queue.notifyAll();
                }
            }
            catch (NoSuchFieldException nfe) {
                Method cancelMethod = thread.getClass().getDeclaredMethod("cancel", new Class[0]);
                Thread thread2 = thread;
                synchronized (thread2) {
                    cancelMethod.setAccessible(true);
                    cancelMethod.invoke((Object)thread, new Object[0]);
                }
            }
            log.warn(sm.getString("webappClassLoader.warnTimerThread", this.getContextName(), thread.getName()));
        }
        catch (Exception e2) {
            Throwable t2 = ExceptionUtils.unwrapInvocationTargetException(e2);
            ExceptionUtils.handleThrowable(t2);
            log.warn(sm.getString("webappClassLoader.stopTimerThreadFail", thread.getName(), this.getContextName()), t2);
        }
    }

    private void checkThreadLocalsForLeaks() {
        Thread[] threads = this.getThreads();
        try {
            Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
            Field inheritableThreadLocalsField = Thread.class.getDeclaredField("inheritableThreadLocals");
            inheritableThreadLocalsField.setAccessible(true);
            Class<?> tlmClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            Field tableField = tlmClass.getDeclaredField("table");
            tableField.setAccessible(true);
            Method expungeStaleEntriesMethod = tlmClass.getDeclaredMethod("expungeStaleEntries", new Class[0]);
            expungeStaleEntriesMethod.setAccessible(true);
            for (int i2 = 0; i2 < threads.length; ++i2) {
                if (threads[i2] == null) continue;
                Object threadLocalMap = threadLocalsField.get(threads[i2]);
                if (null != threadLocalMap) {
                    expungeStaleEntriesMethod.invoke(threadLocalMap, new Object[0]);
                    this.checkThreadLocalMapForLeaks(threadLocalMap, tableField);
                }
                if (null == (threadLocalMap = inheritableThreadLocalsField.get(threads[i2]))) continue;
                expungeStaleEntriesMethod.invoke(threadLocalMap, new Object[0]);
                this.checkThreadLocalMapForLeaks(threadLocalMap, tableField);
            }
        }
        catch (Throwable t2) {
            JreCompat jreCompat = JreCompat.getInstance();
            if (jreCompat.isInstanceOfInaccessibleObjectException(t2)) {
                log.warn(sm.getString("webappClassLoader.addExportsThreadLocal"));
            }
            ExceptionUtils.handleThrowable(t2);
            log.warn(sm.getString("webappClassLoader.checkThreadLocalsForLeaksFail", this.getContextName()), t2);
        }
    }

    private void checkThreadLocalMapForLeaks(Object map, Field internalTableField) throws IllegalAccessException, NoSuchFieldException {
        Object[] table;
        if (map != null && (table = (Object[])internalTableField.get(map)) != null) {
            for (int j2 = 0; j2 < table.length; ++j2) {
                Object obj = table[j2];
                if (obj == null) continue;
                boolean keyLoadedByWebapp = false;
                boolean valueLoadedByWebapp = false;
                Object key = ((Reference)obj).get();
                if (this.equals(key) || this.loadedByThisOrChild(key)) {
                    keyLoadedByWebapp = true;
                }
                Field valueField = obj.getClass().getDeclaredField("value");
                valueField.setAccessible(true);
                Object value = valueField.get(obj);
                if (this.equals(value) || this.loadedByThisOrChild(value)) {
                    valueLoadedByWebapp = true;
                }
                if (!keyLoadedByWebapp && !valueLoadedByWebapp) continue;
                Object[] args = new Object[5];
                args[0] = this.getContextName();
                if (key != null) {
                    args[1] = this.getPrettyClassName(key.getClass());
                    try {
                        args[2] = key.toString();
                    }
                    catch (Exception e2) {
                        log.warn(sm.getString("webappClassLoader.checkThreadLocalsForLeaks.badKey", args[1]), e2);
                        args[2] = sm.getString("webappClassLoader.checkThreadLocalsForLeaks.unknown");
                    }
                }
                if (value != null) {
                    args[3] = this.getPrettyClassName(value.getClass());
                    try {
                        args[4] = value.toString();
                    }
                    catch (Exception e3) {
                        log.warn(sm.getString("webappClassLoader.checkThreadLocalsForLeaks.badValue", args[3]), e3);
                        args[4] = sm.getString("webappClassLoader.checkThreadLocalsForLeaks.unknown");
                    }
                }
                if (valueLoadedByWebapp) {
                    log.error(sm.getString("webappClassLoader.checkThreadLocalsForLeaks", args));
                    continue;
                }
                if (value == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug(sm.getString("webappClassLoader.checkThreadLocalsForLeaksNull", args));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug(sm.getString("webappClassLoader.checkThreadLocalsForLeaksNone", args));
            }
        }
    }

    private String getPrettyClassName(Class<?> clazz) {
        String name = clazz.getCanonicalName();
        if (name == null) {
            name = clazz.getName();
        }
        return name;
    }

    private String getStackTrace(Thread thread) {
        StringBuilder builder = new StringBuilder();
        for (StackTraceElement ste : thread.getStackTrace()) {
            builder.append("\n ").append(ste);
        }
        return builder.toString();
    }

    private boolean loadedByThisOrChild(Object o2) {
        if (o2 == null) {
            return false;
        }
        Class<?> clazz = o2 instanceof Class ? (Class<?>)o2 : o2.getClass();
        for (ClassLoader cl = clazz.getClassLoader(); cl != null; cl = cl.getParent()) {
            if (cl != this) continue;
            return true;
        }
        if (o2 instanceof Collection) {
            Iterator iter = ((Collection)o2).iterator();
            try {
                while (iter.hasNext()) {
                    Object entry = iter.next();
                    if (!this.loadedByThisOrChild(entry)) continue;
                    return true;
                }
            }
            catch (ConcurrentModificationException e2) {
                log.warn(sm.getString("webappClassLoader.loadedByThisOrChildFail", clazz.getName(), this.getContextName()), e2);
            }
        }
        return false;
    }

    private Thread[] getThreads() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        try {
            while (tg.getParent() != null) {
                tg = tg.getParent();
            }
        }
        catch (SecurityException se) {
            String msg = sm.getString("webappClassLoader.getThreadGroupError", tg.getName());
            if (log.isDebugEnabled()) {
                log.debug(msg, se);
            }
            log.warn(msg);
        }
        int threadCountGuess = tg.activeCount() + 50;
        Thread[] threads = new Thread[threadCountGuess];
        int threadCountActual = tg.enumerate(threads);
        while (threadCountActual == threadCountGuess) {
            threads = new Thread[threadCountGuess *= 2];
            threadCountActual = tg.enumerate(threads);
        }
        return threads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearReferencesRmiTargets() {
        try {
            Object tableLock;
            Class<?> objectTargetClass = Class.forName("sun.rmi.transport.Target");
            Field cclField = objectTargetClass.getDeclaredField("ccl");
            cclField.setAccessible(true);
            Field stubField = objectTargetClass.getDeclaredField("stub");
            stubField.setAccessible(true);
            Class<?> objectTableClass = Class.forName("sun.rmi.transport.ObjectTable");
            Field objTableField = objectTableClass.getDeclaredField("objTable");
            objTableField.setAccessible(true);
            Object objTable = objTableField.get(null);
            if (objTable == null) {
                return;
            }
            Field tableLockField = objectTableClass.getDeclaredField("tableLock");
            tableLockField.setAccessible(true);
            Object object = tableLock = tableLockField.get(null);
            synchronized (object) {
                if (objTable instanceof Map) {
                    Iterator iter = ((Map)objTable).values().iterator();
                    while (iter.hasNext()) {
                        Object obj = iter.next();
                        Object cclObject = cclField.get(obj);
                        if (this != cclObject) continue;
                        iter.remove();
                        Object stubObject = stubField.get(obj);
                        log.error(sm.getString("webappClassLoader.clearRmi", stubObject.getClass().getName(), stubObject));
                    }
                }
                Field implTableField = objectTableClass.getDeclaredField("implTable");
                implTableField.setAccessible(true);
                Object implTable = implTableField.get(null);
                if (implTable == null) {
                    return;
                }
                if (implTable instanceof Map) {
                    Iterator iter = ((Map)implTable).values().iterator();
                    while (iter.hasNext()) {
                        Object obj = iter.next();
                        Object cclObject = cclField.get(obj);
                        if (this != cclObject) continue;
                        iter.remove();
                    }
                }
            }
        }
        catch (ClassNotFoundException e2) {
            log.info(sm.getString("webappClassLoader.clearRmiInfo", this.getContextName()), e2);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e3) {
            log.warn(sm.getString("webappClassLoader.clearRmiFail", this.getContextName()), e3);
        }
        catch (Exception e4) {
            JreCompat jreCompat = JreCompat.getInstance();
            if (jreCompat.isInstanceOfInaccessibleObjectException(e4)) {
                log.warn(sm.getString("webappClassLoader.addExportsRmi"));
            }
            throw e4;
        }
    }

    private void clearReferencesObjectStreamClassCaches() {
        try {
            Class<?> clazz = Class.forName("java.io.ObjectStreamClass$Caches");
            this.clearCache(clazz, "localDescs");
            this.clearCache(clazz, "reflectors");
        }
        catch (ClassCastException | ReflectiveOperationException | SecurityException e2) {
            log.warn(sm.getString("webappClassLoader.clearObjectStreamClassCachesFail", this.getContextName()), e2);
        }
    }

    private void clearCache(Class<?> target, String mapName) throws ReflectiveOperationException, SecurityException, ClassCastException {
        Field f2 = target.getDeclaredField(mapName);
        f2.setAccessible(true);
        Map map = (Map)f2.get(null);
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            Object clazz;
            Object key = keys.next();
            if (!(key instanceof Reference) || !this.loadedByThisOrChild(clazz = ((Reference)key).get())) continue;
            keys.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> findClassInternal(String name) {
        Class<?> clazz;
        this.checkStateForResourceLoading(name);
        if (name == null) {
            return null;
        }
        String path = this.binaryNameToPath(name, true);
        ResourceEntry entry = this.resourceEntries.get(path);
        WebResource resource = null;
        if (entry == null) {
            resource = this.resources.getClassLoaderResource(path);
            if (!resource.exists()) {
                return null;
            }
            entry = new ResourceEntry();
            entry.lastModified = resource.getLastModified();
            Map<String, ResourceEntry> map = this.resourceEntries;
            synchronized (map) {
                ResourceEntry entry2 = this.resourceEntries.get(path);
                if (entry2 == null) {
                    this.resourceEntries.put(path, entry);
                } else {
                    entry = entry2;
                }
            }
        }
        if ((clazz = entry.loadedClass) != null) {
            return clazz;
        }
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            clazz = entry.loadedClass;
            if (clazz != null) {
                return clazz;
            }
            if (resource == null) {
                resource = this.resources.getClassLoaderResource(path);
            }
            if (!resource.exists()) {
                return null;
            }
            byte[] binaryContent = resource.getContent();
            if (binaryContent == null) {
                return null;
            }
            Manifest manifest = resource.getManifest();
            URL codeBase = resource.getCodeBase();
            Certificate[] certificates = resource.getCertificates();
            if (this.transformers.size() > 0) {
                String internalName = path.substring(1, path.length() - CLASS_FILE_SUFFIX.length());
                for (ClassFileTransformer transformer : this.transformers) {
                    try {
                        byte[] transformed = transformer.transform(this, internalName, null, null, binaryContent);
                        if (transformed == null) continue;
                        binaryContent = transformed;
                    }
                    catch (IllegalClassFormatException e2) {
                        log.error(sm.getString("webappClassLoader.transformError", name), e2);
                        return null;
                    }
                }
            }
            String packageName = null;
            int pos = name.lastIndexOf(46);
            if (pos != -1) {
                packageName = name.substring(0, pos);
            }
            Package pkg = null;
            if (packageName != null && (pkg = this.getPackage(packageName)) == null) {
                try {
                    if (manifest == null) {
                        this.definePackage(packageName, null, null, null, null, null, null, null);
                    } else {
                        this.definePackage(packageName, manifest, codeBase);
                    }
                }
                catch (IllegalArgumentException e2) {
                    // empty catch block
                }
                pkg = this.getPackage(packageName);
            }
            if (this.securityManager != null && pkg != null) {
                boolean sealCheck = true;
                if (pkg.isSealed()) {
                    sealCheck = pkg.isSealed(codeBase);
                } else {
                    boolean bl = sealCheck = manifest == null || !this.isPackageSealed(packageName, manifest);
                }
                if (!sealCheck) {
                    throw new SecurityException("Sealing violation loading " + name + " : Package " + packageName + " is sealed.");
                }
            }
            try {
                clazz = this.defineClass(name, binaryContent, 0, binaryContent.length, new CodeSource(codeBase, certificates));
            }
            catch (UnsupportedClassVersionError ucve) {
                throw new UnsupportedClassVersionError(ucve.getLocalizedMessage() + " " + sm.getString("webappClassLoader.wrongVersion", name));
            }
            entry.loadedClass = clazz;
        }
        return clazz;
    }

    private String binaryNameToPath(String binaryName, boolean withLeadingSlash) {
        StringBuilder path = new StringBuilder(7 + binaryName.length());
        if (withLeadingSlash) {
            path.append('/');
        }
        path.append(binaryName.replace('.', '/'));
        path.append(CLASS_FILE_SUFFIX);
        return path.toString();
    }

    private String nameToPath(String name) {
        if (name.startsWith("/")) {
            return name;
        }
        StringBuilder path = new StringBuilder(1 + name.length());
        path.append('/');
        path.append(name);
        return path.toString();
    }

    protected boolean isPackageSealed(String name, Manifest man) {
        String path = name.replace('.', '/') + '/';
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    protected Class<?> findLoadedClass0(String name) {
        String path = this.binaryNameToPath(name, true);
        ResourceEntry entry = this.resourceEntries.get(path);
        if (entry != null) {
            return entry.loadedClass;
        }
        return null;
    }

    protected void refreshPolicy() {
        try {
            Policy policy = Policy.getPolicy();
            policy.refresh();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    protected boolean filter(String name, boolean isClassName) {
        if (name == null) {
            return false;
        }
        String packageName = null;
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return false;
        }
        packageName = name.substring(0, pos);
        if (this.overridablePackages != null) {
            for (String overridePkg : this.overridablePackages) {
                if (!packageName.startsWith(overridePkg)) continue;
                return false;
            }
        }
        if (this.preferServerPackages != null) {
            for (String overridePkg : this.preferServerPackages) {
                if (!packageName.startsWith(overridePkg)) continue;
                return true;
            }
        }
        if (name.startsWith("javax")) {
            if (name.length() == 5) {
                return false;
            }
            char ch = name.charAt(5);
            if (isClassName && ch == '.') {
                if (name.startsWith("servlet.jsp.jstl.", 6)) {
                    return false;
                }
                if (name.startsWith("el.", 6) || name.startsWith("servlet.", 6) || name.startsWith("websocket.", 6) || name.startsWith("security.auth.message.", 6)) {
                    return true;
                }
            } else if (!isClassName && ch == '/') {
                if (name.startsWith("servlet/jsp/jstl/", 6)) {
                    return false;
                }
                if (name.startsWith("el/", 6) || name.startsWith("servlet/", 6) || name.startsWith("websocket/", 6) || name.startsWith("security/auth/message/", 6)) {
                    return true;
                }
            }
        } else if (name.startsWith("org")) {
            if (name.length() == 3) {
                return false;
            }
            char ch = name.charAt(3);
            if (isClassName && ch == '.' ? name.startsWith("apache.", 4) && name.startsWith("el.", 11) : !isClassName && ch == '/' && name.startsWith("apache/", 4) && name.startsWith("el/", 11)) {
                return true;
            }
        } else if (name.startsWith("com")) {
            if (name.length() == 3) {
                return false;
            }
            char ch = name.charAt(3);
            if (isClassName && ch == '.') {
                if (name.startsWith("bes.enterprise.", 4)) {
                    if (name.startsWith("appserver.", 19) || name.startsWith("appserv.", 19) || name.startsWith("webtier.", 19) || name.startsWith("web.", 19) || name.startsWith("context.", 19) || name.startsWith("logging.", 19) || name.startsWith("naming.", 19) || name.startsWith("gjc.", 19) || name.startsWith("jasper.", 19)) {
                        return true;
                    }
                    if (name.startsWith("bes.jndi.", 4)) {
                        return true;
                    }
                }
            } else if (!isClassName && ch == '/' && name.startsWith("bes/enterprise/", 4)) {
                if (name.startsWith("appserver/", 19) || name.startsWith("appserv/", 19) || name.startsWith("webtier/", 19) || name.startsWith("web/", 19) || name.startsWith("context/", 19) || name.startsWith("logging/", 19) || name.startsWith("naming/", 19) || name.startsWith("gjc/", 19) || name.startsWith("jasper/", 19)) {
                    return true;
                }
                if (name.startsWith("bes/jndi/", 4)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Deprecated
    protected boolean filter(String name) {
        return this.filter(name, true) || this.filter(name, false);
    }

    @Override
    protected void addURL(URL url) {
        super.addURL(url);
        this.hasExternalRepositories = true;
    }

    @Override
    public String getWebappName() {
        return this.getContextName();
    }

    @Override
    public String getHostName() {
        Container host;
        if (this.resources != null && (host = this.resources.getContext().getParent()) != null) {
            return host.getName();
        }
        return null;
    }

    @Override
    public String getServiceName() {
        Container engine;
        Container host;
        if (this.resources != null && (host = this.resources.getContext().getParent()) != null && (engine = host.getParent()) != null) {
            return engine.getName();
        }
        return null;
    }

    @Override
    public boolean hasLoggingConfig() {
        if (Globals.IS_SECURITY_ENABLED) {
            Boolean result = AccessController.doPrivileged(new PrivilegedHasLoggingConfig());
            return result;
        }
        return this.findResource("logging.properties") != null;
    }

    protected ResourceScopeType getCustomClassScope(String name) {
        if (name == null) {
            return ResourceScopeType.ALL;
        }
        if (this.overridableCustomPackages != null) {
            for (String pkg : this.overridableCustomPackages.keySet()) {
                if (!name.startsWith(pkg + ".")) continue;
                return this.overridableCustomPackages.get(pkg);
            }
        }
        if (this.overridableCustomClasses != null) {
            for (String cas : this.overridableCustomClasses.keySet()) {
                if (!name.endsWith(cas)) continue;
                return this.overridableCustomClasses.get(cas);
            }
        }
        return ResourceScopeType.ALL;
    }

    protected boolean filterCustomClasses(String name) {
        if (name == null) {
            return false;
        }
        if (this.overridableCustomPackages != null) {
            for (String pkg : this.overridableCustomPackages.keySet()) {
                if (!name.startsWith(pkg + ".")) continue;
                return true;
            }
        }
        if (this.overridableCustomClasses != null) {
            for (String cas : this.overridableCustomClasses.keySet()) {
                if (!name.endsWith(cas)) continue;
                return true;
            }
        }
        return false;
    }

    protected ResourceScopeType getCustomResourceScope(String name) {
        if (name == null) {
            return ResourceScopeType.ALL;
        }
        if (this.overridableCustomResources != null) {
            for (String res : this.overridableCustomResources.keySet()) {
                if (!name.equals(res)) continue;
                return this.overridableCustomResources.get(res);
            }
        }
        return ResourceScopeType.ALL;
    }

    protected boolean filterCustomResource(String name) {
        if (name == null) {
            return false;
        }
        if (this.overridableCustomResources != null) {
            for (String res : this.overridableCustomResources.keySet()) {
                if (!name.equals(res)) continue;
                return true;
            }
        }
        return false;
    }

    public Map<String, ResourceScopeType> getOverridableCustomClasses() {
        return this.overridableCustomClasses;
    }

    public void setOverridableCustomClasses(Map<String, ResourceScopeType> overridableCustomClasses) {
        this.overridableCustomClasses = overridableCustomClasses;
    }

    public void addOverridableCustomClasses(Map<String, ResourceScopeType> overridableCustomClasses) {
        if (this.overridableCustomClasses == null) {
            this.overridableCustomClasses = new LinkedHashMap<String, ResourceScopeType>();
        }
        this.overridableCustomClasses.putAll(overridableCustomClasses);
    }

    public void addOverridableCustomClasses(String key, ResourceScopeType scopeType) {
        if (this.overridableCustomClasses == null) {
            this.overridableCustomClasses = new LinkedHashMap<String, ResourceScopeType>();
        }
        this.overridableCustomClasses.put(key, scopeType);
    }

    public Map<String, ResourceScopeType> getOverridableCustomPackages() {
        return this.overridableCustomPackages;
    }

    public void setOverridableCustomPackages(Map<String, ResourceScopeType> overridableCustomPackages) {
        this.overridableCustomPackages = overridableCustomPackages;
    }

    public void addOverridableCustomPackages(Map<String, ResourceScopeType> overridableCustomPackages) {
        if (this.overridableCustomPackages == null) {
            this.overridableCustomPackages = new LinkedHashMap<String, ResourceScopeType>();
        }
        this.overridableCustomPackages.putAll(overridableCustomPackages);
    }

    public void addOverridableCustomPackages(String key, ResourceScopeType scopeType) {
        if (this.overridableCustomPackages == null) {
            this.overridableCustomPackages = new LinkedHashMap<String, ResourceScopeType>();
        }
        this.overridableCustomPackages.put(key, scopeType);
    }

    public Map<String, ResourceScopeType> getOverridableCustomResources() {
        return this.overridableCustomResources;
    }

    public void setOverridableCustomResources(Map<String, ResourceScopeType> overridableCustomResources) {
        this.overridableCustomResources = overridableCustomResources;
    }

    public void addOverridableCustomResources(Map<String, ResourceScopeType> overridableCustomResources) {
        if (this.overridableCustomResources == null) {
            this.overridableCustomResources = new LinkedHashMap<String, ResourceScopeType>();
        }
        this.overridableCustomResources.putAll(overridableCustomResources);
    }

    public void addOverridableCustomResources(String key, ResourceScopeType scopeType) {
        if (this.overridableCustomResources == null) {
            this.overridableCustomResources = new LinkedHashMap<String, ResourceScopeType>();
        }
        this.overridableCustomResources.put(key, scopeType);
    }

    public Map<String, ResourceScopeType> getOverridableScopeResources() {
        return this.overridableScopeResources;
    }

    public void setOverridableScopeResources(Map<String, ResourceScopeType> overridableScopeResources) {
        this.overridableScopeResources = overridableScopeResources;
    }

    public void addOverridableScopeResources(String key, ResourceScopeType scopeType) {
        if (this.overridableScopeResources == null) {
            this.overridableScopeResources = new LinkedHashMap<String, ResourceScopeType>();
        }
        this.overridableScopeResources.put(key, scopeType);
    }

    public void addPreferServerPackage(Collection<String> serverPackages) {
        if (this.preferServerPackages == null) {
            this.preferServerPackages = new ConcurrentLinkedQueue();
        }
        this.preferServerPackages.addAll(serverPackages);
    }

    static {
        ClassLoader.registerAsParallelCapable();
        JVM_THREAD_GROUP_NAMES.add(JVM_THREAD_GROUP_SYSTEM);
        JVM_THREAD_GROUP_NAMES.add("RMI Runtime");
        webAppEnrichmentPrefixes.add("com.bes.enterprise.ejb.jpa.integration.");
        webAppEnrichmentPrefixes.add("com.bes.enterprise.hibernate.");
        webAppEnrichmentPrefixes.add("com.bes.enterprise.toplink.");
        webAppEnrichmentPrefixes.add("com.bes.webbeans.jsf.");
        sm = StringManager.getManager("com.bes.enterprise.webtier.loader");
    }

    private static class CombinedEnumeration
    implements Enumeration<URL> {
        private final Enumeration<URL>[] sources;
        private int index = 0;

        public CombinedEnumeration(Enumeration<URL> enum1, Enumeration<URL> enum2) {
            Enumeration[] sources = new Enumeration[]{enum1, enum2};
            this.sources = sources;
        }

        @Override
        public boolean hasMoreElements() {
            return this.inc();
        }

        @Override
        public URL nextElement() {
            if (this.inc()) {
                return this.sources[this.index].nextElement();
            }
            throw new NoSuchElementException();
        }

        private boolean inc() {
            while (this.index < this.sources.length) {
                if (this.sources[this.index].hasMoreElements()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }
    }

    private class PrivilegedHasLoggingConfig
    implements PrivilegedAction<Boolean> {
        private PrivilegedHasLoggingConfig() {
        }

        @Override
        public Boolean run() {
            return WebappClassLoaderBase.this.findResource("logging.properties") != null;
        }
    }

    protected final class PrivilegedJavaseGetResource
    implements PrivilegedAction<URL> {
        private final String name;

        public PrivilegedJavaseGetResource(String name) {
            this.name = name;
        }

        @Override
        public URL run() {
            return WebappClassLoaderBase.this.javaseClassLoader.getResource(this.name);
        }
    }

    protected static final class PrivilegedGetClassLoader
    implements PrivilegedAction<ClassLoader> {
        public final Class<?> clazz;

        public PrivilegedGetClassLoader(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public ClassLoader run() {
            return this.clazz.getClassLoader();
        }
    }

    protected class PrivilegedFindClassByName
    implements PrivilegedAction<Class<?>> {
        protected final String name;

        PrivilegedFindClassByName(String name) {
            this.name = name;
        }

        @Override
        public Class<?> run() {
            return WebappClassLoaderBase.this.findClassInternal(this.name);
        }
    }
}

