/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.loader;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.ExceptionUtils;
import com.bes.enterprise.web.util.buf.UDecoder;
import com.bes.enterprise.web.util.modeler.Registry;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.Context;
import com.bes.enterprise.webtier.Filter;
import com.bes.enterprise.webtier.Globals;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.LifecycleState;
import com.bes.enterprise.webtier.Loader;
import com.bes.enterprise.webtier.loader.ParallelWebappClassLoader;
import com.bes.enterprise.webtier.loader.ResourceScopeType;
import com.bes.enterprise.webtier.loader.WebappClassLoaderBase;
import com.bes.enterprise.webtier.util.LifecycleMBeanBase;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PermissionCollection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.ObjectName;
import javax.servlet.ServletContext;

public class WebappLoader
extends LifecycleMBeanBase
implements Loader,
PropertyChangeListener {
    private WebappClassLoaderBase classLoader = null;
    private Context context = null;
    private boolean delegate = false;
    protected Map<String, String> overridableCustomClasses;
    protected Map<String, String> overridableCustomResources;
    protected Map<String, String> overridableCustomPackages;
    protected Map<String, String> overridableScopeResources;
    private String loaderClass = ParallelWebappClassLoader.class.getName();
    private ClassLoader parentClassLoader = null;
    private boolean reloadable = false;
    protected static final StringManager sm = StringManager.getManager("com.bes.enterprise.webtier.loader");
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private String classpath = null;
    private PermissionCollection permissionCollection;
    private static final Log log = LogFactory.getLog(WebappLoader.class);

    public WebappLoader() {
        this(null);
    }

    public WebappLoader(ClassLoader parent) {
        this.parentClassLoader = parent;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        if (this.context == context) {
            return;
        }
        if (this.getState().isAvailable()) {
            throw new IllegalStateException(sm.getString("webappLoader.setContext.ise"));
        }
        if (this.context != null) {
            this.context.removePropertyChangeListener(this);
        }
        Context oldContext = this.context;
        this.context = context;
        this.support.firePropertyChange("context", oldContext, this.context);
        if (this.context != null) {
            this.setReloadable(this.context.getReloadable());
            this.context.addPropertyChangeListener(this);
        }
    }

    @Override
    public boolean getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(boolean delegate) {
        boolean oldDelegate = this.delegate;
        this.delegate = delegate;
        this.support.firePropertyChange("delegate", (Object)oldDelegate, (Object)this.delegate);
    }

    public String getLoaderClass() {
        return this.loaderClass;
    }

    public void setLoaderClass(String loaderClass) {
        this.loaderClass = loaderClass;
    }

    @Override
    public boolean getReloadable() {
        return this.reloadable;
    }

    @Override
    public void setReloadable(boolean reloadable) {
        boolean oldReloadable = this.reloadable;
        this.reloadable = reloadable;
        this.support.firePropertyChange("reloadable", (Object)oldReloadable, (Object)this.reloadable);
    }

    public PermissionCollection getPermissionCollection() {
        return this.permissionCollection;
    }

    public void setPermissionCollection(PermissionCollection permissionCollection) {
        this.permissionCollection = permissionCollection;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void backgroundProcess() {
        if (this.reloadable && this.modified()) {
            try {
                Thread.currentThread().setContextClassLoader(WebappLoader.class.getClassLoader());
                if (this.context != null) {
                    this.context.reload();
                }
            }
            finally {
                if (this.context != null && this.context.getLoader() != null) {
                    Thread.currentThread().setContextClassLoader(this.context.getLoader().getClassLoader());
                }
            }
        }
    }

    public String[] getLoaderRepositories() {
        if (this.classLoader == null) {
            return new String[0];
        }
        URL[] urls = this.classLoader.getURLs();
        String[] result = new String[urls.length];
        for (int i2 = 0; i2 < urls.length; ++i2) {
            result[i2] = urls[i2].toExternalForm();
        }
        return result;
    }

    public String getLoaderRepositoriesString() {
        String[] repositories = this.getLoaderRepositories();
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < repositories.length; ++i2) {
            sb.append(repositories[i2]).append(':');
        }
        return sb.toString();
    }

    public String getClasspath() {
        return this.classpath;
    }

    @Override
    public boolean modified() {
        return this.classLoader != null ? this.classLoader.modified() : false;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WebappLoader[");
        if (this.context != null) {
            sb.append(this.context.getName());
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    protected void startInternal() throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("webappLoader.starting"));
        }
        if (this.context.getResources() == null) {
            log.info("No resources for " + this.context);
            this.setState(LifecycleState.STARTING);
            return;
        }
        try {
            this.classLoader = this.createClassLoader();
            this.classLoader.setResources(this.context.getResources());
            this.classLoader.setDelegate(this.delegate);
            this.configureClassLoaderOverridables();
            this.setClassPath();
            this.setPermissions();
            this.classLoader.start();
            String contextName = this.context.getName();
            if (!contextName.startsWith("/")) {
                contextName = "/" + contextName;
            }
            ObjectName cloname = new ObjectName(this.context.getDomain() + ":type=" + this.classLoader.getClass().getSimpleName() + ",host=" + this.context.getParent().getName() + ",context=" + contextName);
            Registry.getRegistry(null, null).registerComponent((Object)this.classLoader, cloname, null);
        }
        catch (Throwable t2) {
            t2 = ExceptionUtils.unwrapInvocationTargetException(t2);
            ExceptionUtils.handleThrowable(t2);
            log.error("LifecycleException ", t2);
            throw new LifecycleException("start: ", t2);
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("webappLoader.stopping"));
        }
        this.setState(LifecycleState.STOPPING);
        ServletContext servletContext = this.context.getServletContext();
        servletContext.removeAttribute("com.bes.enterprise.webtier.jsp_classpath");
        if (this.classLoader != null) {
            try {
                this.classLoader.stop();
            }
            finally {
                this.classLoader.destroy();
            }
            try {
                String contextName = this.context.getName();
                if (!contextName.startsWith("/")) {
                    contextName = "/" + contextName;
                }
                ObjectName cloname = new ObjectName(this.context.getDomain() + ":type=" + this.classLoader.getClass().getSimpleName() + ",host=" + this.context.getParent().getName() + ",context=" + contextName);
                Registry.getRegistry(null, null).unregisterComponent(cloname);
            }
            catch (Exception e2) {
                log.warn("LifecycleException ", e2);
            }
        }
        this.classLoader = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        if (event.getPropertyName().equals("reloadable")) {
            try {
                this.setReloadable((Boolean)event.getNewValue());
            }
            catch (NumberFormatException e2) {
                log.error(sm.getString("webappLoader.reloadable", event.getNewValue().toString()));
            }
        }
    }

    protected void configureClassLoaderOverridables() {
        String type;
        WebappClassLoaderBase webappClassLoader = (WebappClassLoaderBase)this.getClassLoader();
        if (this.overridableCustomClasses != null) {
            for (Map.Entry<String, String> entry : this.overridableCustomClasses.entrySet()) {
                type = entry.getValue();
                webappClassLoader.addOverridableCustomClasses(entry.getKey(), ResourceScopeType.getResourceScope(type));
            }
        }
        if (this.overridableCustomPackages != null) {
            for (Map.Entry<String, String> entry : this.overridableCustomPackages.entrySet()) {
                type = entry.getValue();
                webappClassLoader.addOverridableCustomPackages(entry.getKey(), ResourceScopeType.getResourceScope(type));
            }
        }
        if (this.overridableCustomResources != null) {
            for (Map.Entry<String, String> entry : this.overridableCustomResources.entrySet()) {
                type = entry.getValue();
                webappClassLoader.addOverridableCustomResources(entry.getKey(), ResourceScopeType.getResourceScope(type));
            }
        }
        if (this.overridableScopeResources != null) {
            for (Map.Entry<String, String> entry : this.overridableScopeResources.entrySet()) {
                type = entry.getValue();
                webappClassLoader.addOverridableScopeResources(entry.getKey(), ResourceScopeType.getResourceScope(type));
            }
        }
    }

    private WebappClassLoaderBase createClassLoader() throws Exception {
        Class<?> clazz = Class.forName(this.loaderClass);
        WebappClassLoaderBase classLoader = null;
        if (this.parentClassLoader == null) {
            this.parentClassLoader = this.context.getParentClassLoader();
        }
        Class[] argTypes = new Class[]{ClassLoader.class};
        Object[] args = new Object[]{this.parentClassLoader};
        Constructor<?> constr = clazz.getConstructor(argTypes);
        classLoader = (WebappClassLoaderBase)constr.newInstance(args);
        return classLoader;
    }

    private void setPermissions() {
        if (!Globals.IS_SECURITY_ENABLED) {
            return;
        }
        if (this.context == null) {
            return;
        }
        ServletContext servletContext = this.context.getServletContext();
        File workDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        if (workDir != null) {
            try {
                String workDirPath = workDir.getCanonicalPath();
                this.classLoader.addPermission(new FilePermission(workDirPath, "read,write"));
                this.classLoader.addPermission(new FilePermission(workDirPath + File.separator + "-", "read,write,delete"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (URL url : this.context.getResources().getBaseUrls()) {
            this.classLoader.addPermission(url);
        }
        this.classLoader.setPermissionCollection(this.permissionCollection);
    }

    private void setClassPath() {
        if (this.context == null) {
            return;
        }
        ServletContext servletContext = this.context.getServletContext();
        if (servletContext == null) {
            return;
        }
        StringBuilder classpath = new StringBuilder();
        ClassLoader loader = this.getClassLoader();
        if (this.delegate && loader != null) {
            loader = loader.getParent();
        }
        while (loader != null && this.buildClassPath(classpath, loader)) {
            loader = loader.getParent();
        }
        if (this.delegate && (loader = this.getClassLoader()) != null) {
            this.buildClassPath(classpath, loader);
        }
        this.classpath = classpath.toString();
        servletContext.setAttribute("com.bes.enterprise.webtier.jsp_classpath", this.classpath);
    }

    private boolean buildClassPath(StringBuilder classpath, ClassLoader loader) {
        if (loader instanceof URLClassLoader) {
            URL[] repositories = ((URLClassLoader)loader).getURLs();
            for (int i2 = 0; i2 < repositories.length; ++i2) {
                String repository = repositories[i2].toString();
                if (repository.startsWith("file://")) {
                    repository = UDecoder.URLDecode(repository.substring(7));
                } else {
                    if (!repository.startsWith("file:")) continue;
                    repository = UDecoder.URLDecode(repository.substring(5));
                }
                if (repository == null) continue;
                if (classpath.length() > 0) {
                    classpath.append(File.pathSeparator);
                }
                classpath.append(repository);
            }
        } else {
            if (loader == ClassLoader.getSystemClassLoader() || loader == ClassLoader.getSystemClassLoader().getParent()) {
                String cp = System.getProperty("java.class.path");
                if (cp != null && cp.length() > 0) {
                    if (classpath.length() > 0) {
                        classpath.append(File.pathSeparator);
                    }
                    classpath.append(cp);
                }
                return false;
            }
            log.info("Unknown loader " + loader + " " + loader.getClass());
            return false;
        }
        return true;
    }

    @Override
    protected String getDomainInternal() {
        return this.context.getDomain();
    }

    @Override
    protected String getObjectNameKeyProperties() {
        StringBuilder name = new StringBuilder("type=Loader");
        name.append(",host=");
        name.append(this.context.getParent().getName());
        name.append(",context=");
        String contextName = this.context.getName();
        if (!contextName.startsWith("/")) {
            name.append("/");
        }
        name.append(contextName);
        return name.toString();
    }

    public void addCustomOverridablePackage(String packageName, String scope) {
        if (packageName == null || packageName.trim().isEmpty()) {
            return;
        }
        if (this.overridableCustomPackages == null) {
            this.overridableCustomPackages = new LinkedHashMap<String, String>();
        }
        this.overridableCustomPackages.put(packageName, scope);
    }

    public void addCustomOverridableClass(String className, String scope) {
        if (className == null || className.trim().isEmpty()) {
            return;
        }
        if (this.overridableCustomClasses == null) {
            this.overridableCustomClasses = new LinkedHashMap<String, String>();
        }
        this.overridableCustomClasses.put(className, scope);
    }

    public void addCustomOverridableResource(String resourceName, String scope) {
        if (resourceName == null || resourceName.trim().isEmpty()) {
            return;
        }
        if (this.overridableCustomResources == null) {
            this.overridableCustomResources = new LinkedHashMap<String, String>();
        }
        this.overridableCustomResources.put(resourceName, scope);
    }

    public void addCustomResourceScopeName(String resourceName, String scope) {
        if (resourceName == null || resourceName.trim().isEmpty()) {
            return;
        }
        if (this.overridableScopeResources == null) {
            this.overridableScopeResources = new LinkedHashMap<String, String>();
        }
        this.overridableScopeResources.put(resourceName, scope);
    }

    public void addFilter(Filter filter) {
        String resourceName = null;
        String scope = filter.getScope();
        if (filter.getPackageName() != null && filter.getPackageName().length() > 0) {
            this.addCustomOverridablePackage(filter.getPackageName(), scope);
        } else if (filter.getClassName() != null && filter.getClassName().length() > 0) {
            this.addCustomOverridableClass(filter.getClassName(), scope);
        } else if (filter.getResourceFile() != null && filter.getResourceFile().length() > 0) {
            resourceName = filter.getResourceFile();
            this.addCustomOverridableResource(resourceName, scope);
            if (resourceName.startsWith("/")) {
                this.addCustomOverridableResource(resourceName.substring(1), scope);
            } else {
                this.addCustomOverridableResource("/" + resourceName, scope);
            }
        } else if (filter.getResourcesScope() != null && filter.getResourcesScope().length() > 0) {
            resourceName = filter.getResourcesScope();
            this.addCustomResourceScopeName(resourceName, scope);
            if (resourceName.startsWith("/")) {
                this.addCustomResourceScopeName(resourceName.substring(1), scope);
            } else {
                this.addCustomResourceScopeName("/" + resourceName, scope);
            }
        }
    }
}

