/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.mbeans;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.modeler.Registry;
import com.bes.enterprise.webtier.Group;
import com.bes.enterprise.webtier.Lifecycle;
import com.bes.enterprise.webtier.LifecycleEvent;
import com.bes.enterprise.webtier.LifecycleListener;
import com.bes.enterprise.webtier.Role;
import com.bes.enterprise.webtier.User;
import com.bes.enterprise.webtier.UserDatabase;
import com.bes.enterprise.webtier.mbeans.MBeanUtils;
import java.util.Iterator;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

public class GlobalResourcesLifecycleListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(GlobalResourcesLifecycleListener.class);
    protected Lifecycle component = null;
    protected static final Registry registry = MBeanUtils.createRegistry();

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("start".equals(event.getType())) {
            this.component = event.getLifecycle();
            this.createMBeans();
        } else if ("stop".equals(event.getType())) {
            this.destroyMBeans();
            this.component = null;
        }
    }

    protected void createMBeans() {
        Context context = null;
        try {
            context = (Context)new InitialContext().lookup("java:/");
        }
        catch (NamingException e2) {
            log.error("No global naming context defined for server");
            return;
        }
        try {
            this.createMBeans("", context);
        }
        catch (NamingException e3) {
            log.error("Exception processing Global JNDI Resources", e3);
        }
    }

    protected void createMBeans(String prefix, Context context) throws NamingException {
        if (log.isDebugEnabled()) {
            log.debug("Creating MBeans for Global JNDI Resources in Context '" + prefix + "'");
        }
        try {
            NamingEnumeration<Binding> bindings = context.listBindings("");
            while (bindings.hasMore()) {
                Binding binding = bindings.next();
                String name = prefix + binding.getName();
                Object value = context.lookup(binding.getName());
                if (log.isDebugEnabled()) {
                    log.debug("Checking resource " + name);
                }
                if (value instanceof Context) {
                    this.createMBeans(name + "/", (Context)value);
                    continue;
                }
                if (!(value instanceof UserDatabase)) continue;
                try {
                    this.createMBeans(name, (UserDatabase)value);
                }
                catch (Exception e2) {
                    log.error("Exception creating UserDatabase MBeans for " + name, e2);
                }
            }
        }
        catch (RuntimeException ex) {
            log.error("RuntimeException " + ex);
        }
        catch (OperationNotSupportedException ex) {
            log.error("Operation not supported " + ex);
        }
    }

    protected void createMBeans(String name, UserDatabase database) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Creating UserDatabase MBeans for resource " + name);
            log.debug("Database=" + database);
        }
        try {
            MBeanUtils.createMBean(database);
        }
        catch (Exception e2) {
            throw new IllegalArgumentException("Cannot create UserDatabase MBean for resource " + name, e2);
        }
        Iterator<Role> roles = database.getRoles();
        while (roles.hasNext()) {
            Role role = roles.next();
            if (log.isDebugEnabled()) {
                log.debug("  Creating Role MBean for role " + role);
            }
            try {
                MBeanUtils.createMBean(role);
            }
            catch (Exception e3) {
                throw new IllegalArgumentException("Cannot create Role MBean for role " + role, e3);
            }
        }
        Iterator<Group> groups = database.getGroups();
        while (groups.hasNext()) {
            Group group = groups.next();
            if (log.isDebugEnabled()) {
                log.debug("  Creating Group MBean for group " + group);
            }
            try {
                MBeanUtils.createMBean(group);
            }
            catch (Exception e4) {
                throw new IllegalArgumentException("Cannot create Group MBean for group " + group, e4);
            }
        }
        Iterator<User> users = database.getUsers();
        while (users.hasNext()) {
            User user = users.next();
            if (log.isDebugEnabled()) {
                log.debug("  Creating User MBean for user " + user);
            }
            try {
                MBeanUtils.createMBean(user);
            }
            catch (Exception e5) {
                throw new IllegalArgumentException("Cannot create User MBean for user " + user, e5);
            }
        }
    }

    protected void destroyMBeans() {
        if (log.isDebugEnabled()) {
            log.debug("Destroying MBeans for Global JNDI Resources");
        }
    }
}

