/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.mbeans;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.ExceptionUtils;
import java.lang.reflect.Array;
import java.util.Set;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class MBeanDumper {
    private static final Log log = LogFactory.getLog(MBeanDumper.class);
    private static final String CRLF = "\r\n";

    public static String dumpBeans(MBeanServer mbeanServer, Set<ObjectName> names) {
        StringBuilder buf = new StringBuilder();
        for (ObjectName oname : names) {
            buf.append("Name: ");
            buf.append(oname.toString());
            buf.append(CRLF);
            try {
                MBeanInfo minfo = mbeanServer.getMBeanInfo(oname);
                String code = minfo.getClassName();
                if ("org.apache.commons.modeler.BaseModelMBean".equals(code)) {
                    code = (String)mbeanServer.getAttribute(oname, "modelerType");
                }
                buf.append("modelerType: ");
                buf.append(code);
                buf.append(CRLF);
                MBeanAttributeInfo[] attrs = minfo.getAttributes();
                Object value = null;
                for (int i2 = 0; i2 < attrs.length; ++i2) {
                    String attName;
                    if (!attrs[i2].isReadable() || "modelerType".equals(attName = attrs[i2].getName()) || attName.indexOf(61) >= 0 || attName.indexOf(58) >= 0 || attName.indexOf(32) >= 0) continue;
                    try {
                        value = mbeanServer.getAttribute(oname, attName);
                    }
                    catch (JMRuntimeException rme) {
                        Throwable cause = rme.getCause();
                        if (cause instanceof UnsupportedOperationException) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Error getting attribute " + oname + " " + attName, rme);
                            continue;
                        }
                        if (cause instanceof NullPointerException) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Error getting attribute " + oname + " " + attName, rme);
                            continue;
                        }
                        log.error("Error getting attribute " + oname + " " + attName, rme);
                        continue;
                    }
                    catch (Throwable t2) {
                        ExceptionUtils.handleThrowable(t2);
                        log.error("Error getting attribute " + oname + " " + attName, t2);
                        continue;
                    }
                    if (value == null) continue;
                    try {
                        String valueString;
                        Class<?> c2 = value.getClass();
                        if (c2.isArray()) {
                            int len = Array.getLength(value);
                            StringBuilder sb = new StringBuilder("Array[" + c2.getComponentType().getName() + "] of length " + len);
                            if (len > 0) {
                                sb.append(CRLF);
                            }
                            for (int j2 = 0; j2 < len; ++j2) {
                                sb.append("\t");
                                Object item = Array.get(value, j2);
                                if (item == null) {
                                    sb.append("NULL VALUE");
                                } else {
                                    try {
                                        sb.append(MBeanDumper.escape(item.toString()));
                                    }
                                    catch (Throwable t3) {
                                        ExceptionUtils.handleThrowable(t3);
                                        sb.append("NON-STRINGABLE VALUE");
                                    }
                                }
                                if (j2 >= len - 1) continue;
                                sb.append(CRLF);
                            }
                            valueString = sb.toString();
                        } else {
                            valueString = MBeanDumper.escape(value.toString());
                        }
                        buf.append(attName);
                        buf.append(": ");
                        buf.append(valueString);
                        buf.append(CRLF);
                        continue;
                    }
                    catch (Throwable t4) {
                        ExceptionUtils.handleThrowable(t4);
                    }
                }
            }
            catch (Throwable t5) {
                ExceptionUtils.handleThrowable(t5);
            }
            buf.append(CRLF);
        }
        return buf.toString();
    }

    public static String escape(String value) {
        int idx = value.indexOf("\n");
        if (idx < 0) {
            return value;
        }
        int prev = 0;
        StringBuilder sb = new StringBuilder();
        while (idx >= 0) {
            MBeanDumper.appendHead(sb, value, prev, idx);
            sb.append("\\n\n ");
            prev = idx + 1;
            if (idx == value.length() - 1) break;
            idx = value.indexOf(10, idx + 1);
        }
        if (prev < value.length()) {
            MBeanDumper.appendHead(sb, value, prev, value.length());
        }
        return sb.toString();
    }

    private static void appendHead(StringBuilder sb, String value, int start, int end) {
        if (end < 1) {
            return;
        }
        int pos = start;
        while (end - pos > 78) {
            sb.append(value.substring(pos, pos + 78));
            sb.append("\n ");
            pos += 78;
        }
        sb.append(value.substring(pos, end));
    }
}

