/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.mbeans;

import com.bes.enterprise.web.util.modeler.BaseModelMBean;
import com.bes.enterprise.web.util.modeler.ManagedBean;
import com.bes.enterprise.web.util.modeler.Registry;
import com.bes.enterprise.webtier.Group;
import com.bes.enterprise.webtier.Role;
import com.bes.enterprise.webtier.User;
import com.bes.enterprise.webtier.UserDatabase;
import com.bes.enterprise.webtier.mbeans.MBeanUtils;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MemoryUserDatabaseMBean
extends BaseModelMBean {
    protected final Registry registry = MBeanUtils.createRegistry();
    protected final ManagedBean managed = this.registry.findManagedBean("MemoryUserDatabase");
    protected final ManagedBean managedGroup = this.registry.findManagedBean("Group");
    protected final ManagedBean managedRole = this.registry.findManagedBean("Role");
    protected final ManagedBean managedUser = this.registry.findManagedBean("User");

    public String[] getGroups() {
        UserDatabase database = (UserDatabase)this.resource;
        ArrayList<String> results = new ArrayList<String>();
        Iterator<Group> groups = database.getGroups();
        while (groups.hasNext()) {
            Group group = groups.next();
            results.add(this.findGroup(group.getGroupname()));
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getRoles() {
        UserDatabase database = (UserDatabase)this.resource;
        ArrayList<String> results = new ArrayList<String>();
        Iterator<Role> roles = database.getRoles();
        while (roles.hasNext()) {
            Role role = roles.next();
            results.add(this.findRole(role.getRolename()));
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getUsers() {
        UserDatabase database = (UserDatabase)this.resource;
        ArrayList<String> results = new ArrayList<String>();
        Iterator<User> users = database.getUsers();
        while (users.hasNext()) {
            User user = users.next();
            results.add(this.findUser(user.getUsername()));
        }
        return results.toArray(new String[results.size()]);
    }

    public String createGroup(String groupname, String description) {
        UserDatabase database = (UserDatabase)this.resource;
        Group group = database.createGroup(groupname, description);
        try {
            MBeanUtils.createMBean(group);
        }
        catch (Exception e2) {
            IllegalArgumentException iae = new IllegalArgumentException("Exception creating group [" + groupname + "] MBean");
            iae.initCause(e2);
            throw iae;
        }
        return this.findGroup(groupname);
    }

    public String createRole(String rolename, String description) {
        UserDatabase database = (UserDatabase)this.resource;
        Role role = database.createRole(rolename, description);
        try {
            MBeanUtils.createMBean(role);
        }
        catch (Exception e2) {
            IllegalArgumentException iae = new IllegalArgumentException("Exception creating role [" + rolename + "] MBean");
            iae.initCause(e2);
            throw iae;
        }
        return this.findRole(rolename);
    }

    public String createUser(String username, String password, String fullName) {
        UserDatabase database = (UserDatabase)this.resource;
        User user = database.createUser(username, password, fullName);
        try {
            MBeanUtils.createMBean(user);
        }
        catch (Exception e2) {
            IllegalArgumentException iae = new IllegalArgumentException("Exception creating user [" + username + "] MBean");
            iae.initCause(e2);
            throw iae;
        }
        return this.findUser(username);
    }

    public String findGroup(String groupname) {
        UserDatabase database = (UserDatabase)this.resource;
        Group group = database.findGroup(groupname);
        if (group == null) {
            return null;
        }
        try {
            ObjectName oname = MBeanUtils.createObjectName(this.managedGroup.getDomain(), group);
            return oname.toString();
        }
        catch (MalformedObjectNameException e2) {
            IllegalArgumentException iae = new IllegalArgumentException("Cannot create object name for group [" + groupname + "]");
            iae.initCause(e2);
            throw iae;
        }
    }

    public String findRole(String rolename) {
        UserDatabase database = (UserDatabase)this.resource;
        Role role = database.findRole(rolename);
        if (role == null) {
            return null;
        }
        try {
            ObjectName oname = MBeanUtils.createObjectName(this.managedRole.getDomain(), role);
            return oname.toString();
        }
        catch (MalformedObjectNameException e2) {
            IllegalArgumentException iae = new IllegalArgumentException("Cannot create object name for role [" + rolename + "]");
            iae.initCause(e2);
            throw iae;
        }
    }

    public String findUser(String username) {
        UserDatabase database = (UserDatabase)this.resource;
        User user = database.findUser(username);
        if (user == null) {
            return null;
        }
        try {
            ObjectName oname = MBeanUtils.createObjectName(this.managedUser.getDomain(), user);
            return oname.toString();
        }
        catch (MalformedObjectNameException e2) {
            IllegalArgumentException iae = new IllegalArgumentException("Cannot create object name for user [" + username + "]");
            iae.initCause(e2);
            throw iae;
        }
    }

    public void removeGroup(String groupname) {
        UserDatabase database = (UserDatabase)this.resource;
        Group group = database.findGroup(groupname);
        if (group == null) {
            return;
        }
        try {
            MBeanUtils.destroyMBean(group);
            database.removeGroup(group);
        }
        catch (Exception e2) {
            IllegalArgumentException iae = new IllegalArgumentException("Exception destroying group [" + groupname + "] MBean");
            iae.initCause(e2);
            throw iae;
        }
    }

    public void removeRole(String rolename) {
        UserDatabase database = (UserDatabase)this.resource;
        Role role = database.findRole(rolename);
        if (role == null) {
            return;
        }
        try {
            MBeanUtils.destroyMBean(role);
            database.removeRole(role);
        }
        catch (Exception e2) {
            IllegalArgumentException iae = new IllegalArgumentException("Exception destroying role [" + rolename + "] MBean");
            iae.initCause(e2);
            throw iae;
        }
    }

    public void removeUser(String username) {
        UserDatabase database = (UserDatabase)this.resource;
        User user = database.findUser(username);
        if (user == null) {
            return;
        }
        try {
            MBeanUtils.destroyMBean(user);
            database.removeUser(user);
        }
        catch (Exception e2) {
            IllegalArgumentException iae = new IllegalArgumentException("Exception destroying user [" + username + "] MBean");
            iae.initCause(e2);
            throw iae;
        }
    }
}

