/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.mbeans;

import com.bes.enterprise.webtier.Executor;
import com.bes.enterprise.webtier.Service;
import com.bes.enterprise.webtier.connector.Connector;
import com.bes.enterprise.webtier.mbeans.BaseHeavenMBean;
import javax.management.MBeanException;

public class ServiceMBean
extends BaseHeavenMBean<Service> {
    public void addConnector(String address, int port, boolean isAjp, boolean isSSL) throws MBeanException {
        Service service = (Service)this.doGetManagedResource();
        String protocol = isAjp ? "AJP/1.3" : "HTTP/1.1";
        Connector connector = new Connector(protocol);
        if (address != null && address.length() > 0) {
            connector.setProperty("address", address);
        }
        connector.setPort(port);
        connector.setSecure(isSSL);
        connector.setScheme(isSSL ? "https" : "http");
        service.addConnector(connector);
    }

    public void addExecutor(String type) throws MBeanException {
        Service service = (Service)this.doGetManagedResource();
        Executor executor = (Executor)ServiceMBean.newInstance(type);
        service.addExecutor(executor);
    }

    public String[] findConnectors() throws MBeanException {
        Service service = (Service)this.doGetManagedResource();
        Connector[] connectors = service.findConnectors();
        String[] str = new String[connectors.length];
        for (int i2 = 0; i2 < connectors.length; ++i2) {
            str[i2] = connectors[i2].toString();
        }
        return str;
    }

    public String[] findExecutors() throws MBeanException {
        Service service = (Service)this.doGetManagedResource();
        Executor[] executors = service.findExecutors();
        String[] str = new String[executors.length];
        for (int i2 = 0; i2 < executors.length; ++i2) {
            str[i2] = executors[i2].toString();
        }
        return str;
    }

    public String getExecutor(String name) throws MBeanException {
        Service service = (Service)this.doGetManagedResource();
        Executor executor = service.getExecutor(name);
        return executor.toString();
    }
}

